/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.stats;

import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.stats.HistoryEntry;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class HistoryColumnRenderer
extends AbstractColumnRenderer {
    public static final int DATE = 0;
    public static final int NODE = 1;
    public static final int ID = 2;
    public static final int TYPE = 3;
    public static final int OP = 4;
    public static final int INDEX = 5;
    public static final int ELAPSED = 6;
    public static final int STATUS = 7;
    private static final int COLUMN_NO = 8;
    public static final String DATE_NAME = "Date";
    public static final String NODE_NAME = "Node";
    public static final String ID_NAME = "Name";
    public static final String TYPE_NAME = "Type";
    public static final String OP_NAME = "Op";
    public static final String INDEX_NAME = "Index";
    public static final String ELAPSED_NAME = "Time";
    public static final String STATUS_NAME = "Status/Observer";
    private DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
    private int mode;
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 2);

    public HistoryColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.tcr.setBorder(emptyBorder);
        this.tcr.setHorizontalAlignment(n3);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        HistoryEntry historyEntry = (HistoryEntry)object;
        switch (this.mode) {
            case 2: {
                string = historyEntry.name;
                break;
            }
            case 3: {
                string = historyEntry.getType();
                break;
            }
            case 4: {
                string = historyEntry.getOp();
                break;
            }
            case 1: {
                string = historyEntry.nodeName;
                break;
            }
            case 0: {
                string = historyEntry.date;
                break;
            }
            case 5: {
                if (!historyEntry.isUpdate()) break;
                string = Integer.toHexString(historyEntry.index);
                break;
            }
            case 6: {
                if (historyEntry.status == null) break;
                string = Long.toString(historyEntry.elapsed);
                break;
            }
            case 7: {
                if (historyEntry.status == null) {
                    string = "Pending...";
                    break;
                }
                string = historyEntry.status;
                break;
            }
            default: {
                string = "???";
            }
        }
        return this.tcr.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[8];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = HistoryColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        String string;
        int n2 = 50;
        boolean bl = true;
        int n3 = 4;
        switch (n) {
            case 2: {
                string = ID_NAME;
                n2 = 250;
                n3 = 2;
                break;
            }
            case 0: {
                string = DATE_NAME;
                n2 = 70;
                n3 = 0;
                bl = false;
                break;
            }
            case 1: {
                string = NODE_NAME;
                n3 = 0;
                bl = false;
                n2 = 80;
                break;
            }
            case 4: {
                string = OP_NAME;
                n3 = 0;
                bl = false;
                n2 = 45;
                break;
            }
            case 6: {
                string = ELAPSED_NAME;
                bl = false;
                n2 = 50;
                break;
            }
            case 5: {
                string = INDEX_NAME;
                n2 = 55;
                break;
            }
            case 7: {
                n3 = 2;
                string = STATUS_NAME;
                n2 = 200;
                break;
            }
            case 3: {
                string = TYPE_NAME;
                n3 = 0;
                bl = false;
                n2 = 45;
                break;
            }
            default: {
                string = "???";
            }
        }
        return new HistoryColumnRenderer(n, string, n2, bl, n3);
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        return n2;
    }
}

