/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc;

import cerent.cms.CmsControlImpl;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ProgressManager;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.cms.ui.ForcePasswordChangeDialog;
import cerent.cms.ui.MainPanel;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.PasswordExprWarningDialog;
import cerent.cms.ui.PrefsNodesPropertyPane;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.ViewName;
import cerent.util.BuildInfo;
import cerent.util.BusEvent;
import cerent.util.CtcRuntime;
import cerent.util.DebugManager;
import cerent.util.DebugWindow;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.HelpMgr;
import cerent.util.IDebugDiag;
import cerent.util.JarFileDeleteEvent;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.SocketURLStreamHandler;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DefaultStatusItem;
import cerent.util.gui.DialogCache;
import cerent.util.gui.SubsystemStatus;
import cerent.util.gui.UFrame;
import cerent.util.job.JobControllerFactory;
import cerent.util.orb.AbstractORB;
import cerent.util.orb.OngORB;
import cerent.util.stats.StatsWindow;
import cerent.version.NetworkVersionMonitor;
import com.cisco.ctc.CtcIdleTimer;
import com.cisco.ctc.core.ClassLoaderEnum;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.JreReqs;
import com.cisco.ctc.core.JreVersion;
import com.cisco.ctc.ui.LoginDialog;
import com.cisco.ctc.ui.ProgressDialog;
import com.cisco.util.CtcRelauncher;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CtcApplication
implements Runnable,
ActionListener,
AWTEventListener,
Observer {
    private static final IClassLoaderManager clm = ClassLoaderManager.instance();
    private HashSet protectedOperations = new HashSet();
    private static long startTime;
    private boolean excludeDynamic = false;
    private boolean cktMgtDisabled = false;
    private String additionalNodeGroup;
    private static Preferences preferences;
    private static AbstractORB orb;
    private CtcIdleTimer timer;
    public static final int MAINTENANCE_SESSION_TIMEOUT = 3600000;
    public static final int PROVISIONING_SESSION_TIMEOUT = 1800000;
    public static final int SUPERUSER_SESSION_TIMEOUT = 900000;
    private static final String PROP_CORBA_URL = "ctc.corba.url";
    private static final String PROP_USER = "ctc.user";
    private static final String PROP_PASSWD = "ctc.password";
    private static final String OLD_PROP_CORBA_URL = "cms.corba.url";
    private static final String OLD_PROP_USER = "cms.user";
    private static final String OLD_PROP_PASSWD = "cms.password";
    private static final String EXIT_QUERY = "Really exit CTC?";
    private static final String EXIT_QUERY_WITH_JOBS = "Background tasks are still running, exit anyway?";
    public static final String PREFS_PATH = "ctc.network";
    public static final String PREFS_NODES = "nodes";
    private String nodeName = null;
    private CmsControlImpl cmsControl;
    private MainPanel mainPanel = null;
    private Exception runException;
    private String runReason;
    private boolean prdClosedByUser;
    private ProgressDialog prd;
    private HashSet protectedThreads = new HashSet();
    private DefaultStatusItem netStatusItem = new DefaultStatusItem((JComponent)new JLabel("NET"));
    private DefaultStatusItem cktStatusItem = new DefaultStatusItem((JComponent)new JLabel("CKT"));
    private static CtcApplication instance;
    private static final SDebug db;
    private static final SDebug idleTimerdb;
    private static boolean exitSuspended;

    private static void InitOrb(String[] stringArray) {
        try {
            OngORB.init((String[])stringArray, (Properties)new Properties());
            orb = AbstractORB.loadORB((ClassLoader)CtcApplication.class.getClassLoader());
        }
        catch (Error error) {
            Exception exception = new Exception(error.getMessage());
            SDebug.printStackTrace((Throwable)error);
            ErrorMsg.displayError(null, (EID)NEMC.EID_CORBA_FATAL_ERROR);
            System.exit(1);
        }
        catch (Exception exception) {
            db.println(exception.getMessage());
            db.println("ORB initialization failed - exiting");
            ErrorMsg.displayError(null, (EID)NEMC.EID_CORBA_FATAL_ERROR);
            System.exit(1);
        }
    }

    private static void InitNetwork(String[] stringArray) {
        try {
            NetworkModel.instance().init(stringArray);
        }
        catch (Exception exception) {
            System.err.println("Network Model initialization failed:" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static Object InitUnitTestApplicationNoInit(String string, String string2, String string3, String[] stringArray) throws Exception {
        CtcApplication.InitOrb(stringArray);
        return CtcApplication.CreateNetElement(string, string2, string3);
    }

    private static Object InitUnitTestApplication(String string, String string2, String string3, String[] stringArray) throws Exception {
        INetElement iNetElement = (INetElement)CtcApplication.InitUnitTestApplicationNoInit(string, string2, string3, stringArray);
        INodeModel iNodeModel = iNetElement.getNodeModel();
        iNodeModel.init();
        Network.instance().createTopology(iNetElement);
        return iNetElement;
    }

    private CtcApplication(String[] stringArray) {
        instance = this;
        startTime = System.currentTimeMillis();
        this.excludeDynamic = false;
        this.cktMgtDisabled = false;
        this.additionalNodeGroup = "(None)";
        if (!CtcRelauncher.checkLauncher()) {
            if (DebugWindow.instance() != null) {
                DebugWindow.instance().hide();
            }
            CtcRelauncher.reLaunch(stringArray);
        } else {
            Thread thread;
            this.checkVersion();
            CtcApplication.InitOrb(stringArray);
            this.printBuildInfo();
            CtcApplication.InitNetwork(stringArray);
            ErrorMsg.getString((EID)NEMC.EID_INVALID_ID);
            this.mainPanel = new MainPanel(this);
            this.timer = new CtcIdleTimer(idleTimerdb);
            this.nodeName = stringArray[0];
            String string = null;
            string = System.getProperty(PROP_CORBA_URL);
            if (string == null) {
                string = System.getProperty(OLD_PROP_CORBA_URL);
            }
            if (string != null) {
                this.initializeCORBAServant(string);
            }
            this.setLookandFeel();
            StatsWindow.instance().init();
            this.prd = ProgressDialog.instance(this.mainPanel, "Initializing CTC");
            int n = 0;
            while (true) {
                this.getUsernameAndPassword(n);
                if (db.on()) {
                    db.println("Starting login thread ...");
                }
                thread = new Thread((Runnable)this, "Login Thread");
                thread.start();
                this.prdClosedByUser = true;
                this.prd.show();
                if (this.prdClosedByUser) {
                    System.exit(0);
                }
                if (this.cmsControl != null) {
                    if (db.on()) {
                        db.println("unblocking CTC controller");
                    }
                    this.cmsControl.loginCompleted(this.runException, this.runReason);
                }
                if (this.runException == null) break;
                ++n;
            }
            if (this.prd != null) {
                this.prd.dispose();
                this.prd = null;
            }
            this.mainPanel.display();
            thread = null;
            String string2 = NetSecurityModel.instance().getUserName();
            String string3 = NetSecurityModel.instance().getPassword();
            String[] stringArray2 = preferences.getPropertyArray(PREFS_PATH, PREFS_NODES, null);
            for (int i = 0; stringArray2 != null && i < stringArray2.length; ++i) {
                try {
                    NetworkModel.instance().addNetElement(stringArray2[i], string2, string3);
                    continue;
                }
                catch (Exception exception) {
                    db.println("Warning cannot load topo host:" + stringArray2[i] + ":" + exception.getMessage());
                }
            }
            EventBus.instance().addObserver((Observer)this, (Object)NetCircuitManager.class.toString());
            EventBus.instance().addObserver((Observer)this, (Object)Topology.class.toString());
            EventBus.instance().addObserver((Observer)this, (Object)"JAR_DELETED");
            PasswordExprWarningDialog.instance(this.mainPanel, string2);
            ForcePasswordChangeDialog.instance(this.mainPanel, string2);
        }
    }

    private void setLookandFeel() {
        try {
            Object object = new WindowsLookAndFeel();
            if (!((LookAndFeel)object).isSupportedLookAndFeel()) {
                object = new MetalLookAndFeel();
            }
            if (System.getProperty("mrj.version") != null) {
                if (db.on()) {
                    db.println("Setting MacLookAndFeel");
                }
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            } else {
                if (db.on()) {
                    db.println("Setting " + ((LookAndFeel)object).getDescription());
                }
                UIManager.setLookAndFeel((LookAndFeel)object);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Exception received while setting up platform " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUsernameAndPassword(int n) {
        Object object;
        String string;
        String string2;
        if (db.on()) {
            db.println("obtainUserPass");
        }
        if ((string2 = System.getProperty(PROP_USER)) == null) {
            string2 = System.getProperty(OLD_PROP_USER);
        }
        if ((string = System.getProperty(PROP_PASSWD)) == null) {
            string = System.getProperty(OLD_PROP_PASSWD);
        }
        if (this.cmsControl != null) {
            if (db.on()) {
                db.println("Attempting login via CTC controller ...");
            }
            string2 = this.cmsControl.getUserName();
            string = this.cmsControl.getPassword();
            this.applyPreferences();
        } else {
            if (db.on()) {
                db.println("Attempting login via LoginDialog ...");
            }
            if (n == 0 && string2 != null && string != null) {
                this.applyPreferences();
            } else if (n > 0 || string2 == null && string == null) {
                if (db.on()) {
                    db.println("Creating Login Dialog ...");
                }
                object = clm.getSystemNgrp();
                Date date = object.getRebuildDateAsDate();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                String string3 = "2000-" + calendar.get(1);
                LoginDialog loginDialog = new LoginDialog(this, this.nodeName, string3);
                if (db.on()) {
                    db.println("Showing Login Dialog ..." + (Object)((Object)loginDialog));
                }
                loginDialog.showWindow();
                CtcApplication ctcApplication = this;
                synchronized (ctcApplication) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                if (!loginDialog.getLoginStatus()) {
                    if (db.on()) {
                        db.println("Graceful exit ...");
                    }
                    System.exit(0);
                }
                string2 = loginDialog.getUserName();
                string = loginDialog.getPassword();
                this.nodeName = loginDialog.getNodeName();
                this.excludeDynamic = loginDialog.getDisableNetworkState();
                this.cktMgtDisabled = loginDialog.getDisableCircuitState();
                this.setCktMgtMode(!this.cktMgtDisabled);
                this.additionalNodeGroup = loginDialog.getAdditionalNodeGroup();
                preferences.setPropertyArray(PREFS_PATH, PREFS_NODES, loginDialog.getNodes());
            }
            SubsystemStatus.addItem((DefaultStatusItem)this.netStatusItem);
            if (this.excludeDynamic) {
                SubsystemStatus.setStatus((DefaultStatusItem)this.netStatusItem, (int)0);
            } else {
                SubsystemStatus.setStatus((DefaultStatusItem)this.netStatusItem, (int)2);
            }
        }
        object = NetSecurityModel.instance();
        ((NetSecurityModel)((Object)object)).setUserName(string2);
        ((NetSecurityModel)((Object)object)).setPassword(string);
    }

    private void applyPreferences() {
        this.excludeDynamic = preferences.getBoolean("ctc.recent", "exclude_dyn", false);
        this.cktMgtDisabled = preferences.getBoolean("ctc.recent", "ckt_mgt", false);
        this.setCktMgtMode(!this.cktMgtDisabled);
    }

    public void lockCtc() {
        this.timer.lockCtc();
    }

    public boolean isLocked() {
        return this.timer.isLocked();
    }

    public void unlockCtc() {
        this.timer.unlockCtc();
    }

    private static INetElement CreateNetElement(String string, String string2, String string3) throws UnknownHostException {
        NetworkModel.instance().addNetElement(string, string2, string3);
        return null;
    }

    private static INodeModel CreateNode(String string, String string2, String string3) throws UnknownHostException {
        INetElement iNetElement = CtcApplication.CreateNetElement(string, string2, string3);
        INodeModel iNodeModel = iNetElement.getNodeModel();
        return iNodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string;
        CharSequence charSequence;
        while (!this.prd.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                db.finest("Exception in run()/Thread.sleep(100) " + exception);
            }
        }
        if (db.on()) {
            db.println("init thread started");
        }
        this.runException = null;
        this.runReason = null;
        ProgressManager progressManager = ProgressManager.instance();
        INetElement iNetElement = null;
        try {
            block39: {
                this.prd.setCursor(new Cursor(3));
                charSequence = NetSecurityModel.instance().getUserName();
                string = NetSecurityModel.instance().getPassword();
                boolean bl = Preferences.instance().getBoolean("ctc.recent", "exclude_dyn", false);
                NetworkVersionMonitor.instance().initialize();
                NetworkModel.instance().setExcludeDyn(bl);
                iNetElement = NetworkModel.instance().addNetElementBlocking(this.nodeName, (String)charSequence, string, false);
                INodeModel iNodeModel = iNetElement.getNodeModel();
                progressManager.startStep("Session Initialization");
                try {
                    if (db.on()) {
                        db.println("Waiting NMD init to complete...");
                    }
                    if (!((NodeModel)iNodeModel).isEnabled()) {
                        ((NodeModel)iNodeModel).setEnabled(true);
                    }
                    ((NodeModel)iNodeModel).firstInit();
                    this.runException = iNodeModel.getInitFailureException();
                    if (db.on()) {
                        db.println("NMD init to complete result=" + this.runException);
                    }
                    if (this.runException != null) break block39;
                    Network.instance().createTopology(iNetElement);
                    this.timer.start(this.mainPanel);
                    progressManager.startStep("Main Panel Initialization");
                    if (NetworkModel.instance().getTDMTerminology() instanceof SONETTDMTerminology) {
                        HelpMgr.setCSHPlatform((int)1);
                    } else {
                        HelpMgr.setCSHPlatform((int)2);
                    }
                    this.mainPanel.initialize();
                    try {
                        int n = 0;
                        boolean bl2 = false;
                        for (int i = 0; i < 30; ++i) {
                            n = iNodeModel.getNodeId();
                            if (Network.instance().getNodeModel(n) != null && iNodeModel.isInited()) {
                                if (db.on()) {
                                    db.println("NodeModel with NodeId " + n + " found in Network && inited");
                                }
                                bl2 = true;
                                break;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (Exception exception) {
                                db.finest("Exception in run()/Thread.sleep(200) " + exception);
                            }
                        }
                        if (!bl2) {
                            db.println("NodeModel with NodeId " + n + " not found in Network");
                        }
                        NetworkViewController networkViewController = this.mainPanel.getNetworkViewController();
                        ViewName viewName = new ViewName(n);
                        networkViewController.setHomeView(viewName);
                        networkViewController.jumpView(viewName, false);
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        this.mainPanel.getNetworkViewController().tryJumpView(ViewName.ROOT_VIEW);
                        ErrorMsg.displayError((Component)this.mainPanel, (EID)NEMC.EID_FAIL_JUMP_TO_VIEW_PARAM_1, (Object)"Shelf");
                    }
                    progressManager.allCompleted(null);
                }
                catch (Exception exception) {
                    db.println("run: setEnabled(false):" + exception);
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    ((NodeModel)iNodeModel).setEnabled(false);
                    this.runException = exception;
                }
            }
            this.prdClosedByUser = false;
        }
        catch (UnknownHostException unknownHostException) {
            try {
                this.runException = new Exception("Cannot locate host " + this.nodeName, unknownHostException);
                this.prdClosedByUser = false;
            }
            catch (Throwable throwable) {
                this.prdClosedByUser = false;
                this.prd.setCursor(new Cursor(0));
                if (this.runException != null) {
                    SDebug.printStackTrace((Throwable)this.runException);
                    NetworkModel.instance().destroyCmsHost();
                    if (this.cmsControl == null) {
                        this.prd.showDetails();
                        StringBuffer stringBuffer = new StringBuffer();
                        String string2 = this.runException.getMessage();
                        stringBuffer.append("\n");
                        if (string2 != null) {
                            stringBuffer.append("Exception = ");
                            stringBuffer.append(string2);
                        }
                        if (this.runReason != null && this.runReason.length() > 0) {
                            if (stringBuffer.length() > 1) {
                                stringBuffer.append("; ");
                            }
                            stringBuffer.append("Reason = ");
                            stringBuffer.append(this.runReason);
                        }
                        ErrorMsg.displayError(this.mainPanel, NEMC.EID_LOGIN_ERROR_PARAM_2, this.nodeName, stringBuffer.toString());
                    }
                }
                progressManager.addStepInfo("");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CtcApplication.this.prd.hide();
                    }
                });
                throw throwable;
            }
            this.prd.setCursor(new Cursor(0));
            if (this.runException != null) {
                SDebug.printStackTrace((Throwable)this.runException);
                NetworkModel.instance().destroyCmsHost();
                if (this.cmsControl == null) {
                    this.prd.showDetails();
                    StringBuffer stringBuffer = new StringBuffer();
                    String string3 = this.runException.getMessage();
                    stringBuffer.append("\n");
                    if (string3 != null) {
                        stringBuffer.append("Exception = ");
                        stringBuffer.append(string3);
                    }
                    if (this.runReason != null && this.runReason.length() > 0) {
                        if (stringBuffer.length() > 1) {
                            stringBuffer.append("; ");
                        }
                        stringBuffer.append("Reason = ");
                        stringBuffer.append(this.runReason);
                    }
                    ErrorMsg.displayError(this.mainPanel, NEMC.EID_LOGIN_ERROR_PARAM_2, this.nodeName, stringBuffer.toString());
                }
            }
            progressManager.addStepInfo("");
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        this.prd.setCursor(new Cursor(0));
        if (this.runException != null) {
            SDebug.printStackTrace((Throwable)this.runException);
            NetworkModel.instance().destroyCmsHost();
            if (this.cmsControl == null) {
                this.prd.showDetails();
                charSequence = new StringBuffer();
                string = this.runException.getMessage();
                ((StringBuffer)charSequence).append("\n");
                if (string != null) {
                    ((StringBuffer)charSequence).append("Exception = ");
                    ((StringBuffer)charSequence).append(string);
                }
                if (this.runReason != null && this.runReason.length() > 0) {
                    if (((StringBuffer)charSequence).length() > 1) {
                        ((StringBuffer)charSequence).append("; ");
                    }
                    ((StringBuffer)charSequence).append("Reason = ");
                    ((StringBuffer)charSequence).append(this.runReason);
                }
                ErrorMsg.displayError(this.mainPanel, NEMC.EID_LOGIN_ERROR_PARAM_2, this.nodeName, ((StringBuffer)charSequence).toString());
            }
        }
        progressManager.addStepInfo("");
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeCORBAServant(String string) {
        this.cmsControl = new CmsControlImpl(this.mainPanel);
        String string2 = this.cmsControl.getIor();
        PrintWriter printWriter = null;
        try {
            if (db.on()) {
                db.println("URL = " + string);
            }
            URL uRL = new URL(null, string, new SocketURLStreamHandler());
            URLConnection uRLConnection = uRL.openConnection();
            printWriter = new PrintWriter(uRLConnection.getOutputStream());
            printWriter.println(string2);
            System.out.println("CTC Control CORBA Servant Ready");
            System.out.println(string2);
        }
        catch (MalformedURLException malformedURLException) {
            if (db.on()) {
                db.println("ERROR: Invalid URL:" + malformedURLException);
            }
            SDebug.printStackTrace((Throwable)malformedURLException);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                db.finest("Exception in initializeCorbaServant()/Thread.sleep(2k) " + exception);
            }
            System.exit(1);
        }
        catch (IOException iOException) {
            if (db.on()) {
                db.println("ERROR: Cannot write into user's URL:" + iOException);
            }
            SDebug.printStackTrace((Throwable)iOException);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                db.finest("Exception in initializeCorbaServant()/Thread.sleep(2k) " + exception);
            }
            System.exit(2);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void printBuildInfo() {
        System.out.println("Version " + BuildInfo.sanitize(BuildInfo.version) + ", built " + BuildInfo.date);
    }

    private void checkVersion() {
        System.out.println("JVM " + JreVersion.USER_VERSION);
        boolean bl = CtcRuntime.isCiscoHost();
        if (bl) {
            DebugManager.instance().setExcToSysOut(true);
        }
    }

    public synchronized void addProtectedOperation(String string) {
        this.protectedOperations.add(string);
    }

    public synchronized void removeProtectedOperation(String string) {
        this.protectedOperations.remove(string);
    }

    public void exitCtc(boolean bl) {
        block31: {
            block30: {
                if (db.on()) {
                    db.println("exitCtc; checkThreads is " + bl);
                }
                try {
                    if (bl) {
                        boolean bl2 = true;
                        if (!JobControllerFactory.isDisposable()) {
                            bl2 = false;
                            if (!CerentDialog.yesNoDialog((Component)this.mainPanel, (String)EXIT_QUERY_WITH_JOBS, (String)"Exit CTC")) {
                                return;
                            }
                        }
                        if (this.protectedOperations.size() > 0) {
                            bl2 = false;
                            StringBuffer stringBuffer = new StringBuffer();
                            String string = this.protectedOperations.size() == 1 ? "operation" : "operations";
                            stringBuffer.append("The following " + string + " may still be active " + "and may be interrupted if you exit CTC.\n");
                            Iterator iterator = this.protectedOperations.iterator();
                            while (iterator.hasNext()) {
                                stringBuffer.append("       - " + (String)iterator.next() + "\n");
                            }
                            stringBuffer.append("\nExit anyway?");
                            if (!CerentDialog.yesNoDialog((Component)this.mainPanel, (String)stringBuffer.toString(), (String)"Exit CTC")) {
                                return;
                            }
                        }
                        if (bl2 && !CerentDialog.yesNoDialog((Component)this.mainPanel, (String)EXIT_QUERY, (String)"Confirm Exit")) {
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    db.severe("Dialog exception on exit; exiting anyhow");
                    if (!db.on()) break block30;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (db.on()) {
                db.println("Disposing network and element UI objects");
            }
            try {
                UFrame.setMainFrame(null);
                this.timer.stop();
                UiToolkit.destroy();
                SubsystemStatus.deleteItem((DefaultStatusItem)this.netStatusItem);
                SubsystemStatus.deleteItem((DefaultStatusItem)this.cktStatusItem);
                this.mainPanel.dispose();
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Caught exception - ");
                    db.println("       UI object destroy may be incomplete");
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.mainPanel.hide();
            }
            this.mainPanel = null;
            Cleaner cleaner = new Cleaner(Thread.currentThread());
            new Thread((Runnable)cleaner, "cleaner").start();
            if (exitSuspended) {
                while (exitSuspended) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        db.finest("InterruptedException in exitCtc()/Thread.Sleep(1k) " + interruptedException);
                    }
                }
            } else {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException interruptedException) {
                    db.finest("InterruptedException in exitCtc()/Thread.Sleep(20k) " + interruptedException);
                }
            }
            if (db.on()) {
                db.println("Storing preferences");
            }
            try {
                while (true) {
                    try {
                        preferences.store();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (!db.on()) continue;
                        db.println("caught InterruptedIOException, trying again...");
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (db.on()) {
                    db.println("exitCtc(): FileNotFoundException\n" + fileNotFoundException);
                    SDebug.printStackTrace((Throwable)fileNotFoundException);
                }
            }
            catch (IOException iOException) {
                if (!db.on()) break block31;
                db.println("exitCtc(): IOException\n" + iOException);
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        if (db.on()) {
            db.println("Calling System.exit(0)");
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length != 1) {
            boolean bl = preferences.getBoolean("ctc", "console.available", false);
            if (bl) {
                BufferedReader bufferedReader = null;
                try {
                    System.out.print("Enter a login network element: ");
                    System.out.flush();
                    bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (string != null) {
                stringArray = new String[]{string};
            } else {
                System.err.println("usage: CtcApplication <node name>");
                System.exit(1);
            }
        }
        new CtcApplication(stringArray);
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public Object getOrb() {
        return orb;
    }

    public String getAdditionalNodeGroup() {
        return this.additionalNodeGroup;
    }

    public static CtcApplication instance() {
        return instance;
    }

    protected void startIdleTimer() {
        this.timer.start(this.mainPanel);
    }

    protected void restartIdleTimer() {
        this.timer.restart();
    }

    protected void stopIdleTimer() {
        this.timer.stop();
    }

    public void fireIdleTimer() {
        this.timer.fire();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.timer.actionPerformed(actionEvent);
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        this.timer.eventDispatched(aWTEvent);
    }

    public void setCktMgtMode(boolean bl) {
        NetworkModel.instance().setEnableCircuitDiscovery(bl);
        SubsystemStatus.addItem((DefaultStatusItem)this.cktStatusItem);
        if (bl) {
            SubsystemStatus.setStatus((DefaultStatusItem)this.cktStatusItem, (int)1);
        } else {
            SubsystemStatus.setStatus((DefaultStatusItem)this.cktStatusItem, (int)0);
        }
        this.cktMgtDisabled = !bl;
    }

    public boolean getCktMgtMode() {
        return !this.cktMgtDisabled;
    }

    public boolean checkCktMgtMode() {
        if (this.cktMgtDisabled) {
            if (!CerentDialog.yesNoDialog((Component)this.getMainPanel(), (String)"Circuit operations require Circuit Management to be enabled.\nDo you want to enable circuit management?", (String)"Enable Circuit Management", (int)0)) {
                return false;
            }
            this.setCktMgtMode(true);
        }
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof BusEvent) {
            BusEvent busEvent = (BusEvent)object;
            String string = (String)busEvent.getSource();
            Object object2 = busEvent.getEvent();
            if (string == null && object2 == null) {
                if (db.on()) {
                    db.println("busEvent source or event is null");
                }
                return;
            }
            if (string.equals("JAR_DELETED")) {
                this.handleJarDelete((JarFileDeleteEvent)((BusEvent)object).getEvent());
            } else if (db.on()) {
                db.println("busEvent source=" + string + ", event=" + object2);
            }
            if (object2 instanceof Integer) {
                if (string.equals(NetCircuitManager.class.toString())) {
                    if (db.on()) {
                        db.println("NCP new status is " + object2);
                    }
                    SubsystemStatus.setStatus((DefaultStatusItem)this.cktStatusItem, (int)((Integer)object2));
                } else if (string.equals(Topology.class.toString()) && this.netStatusItem.getStatus() != 0) {
                    if (db.on()) {
                        db.println("NET new status is " + object2);
                    }
                    SubsystemStatus.setStatus((DefaultStatusItem)this.netStatusItem, (int)((Integer)object2));
                }
            } else if (db.on()) {
                db.println("Unknown event " + object2);
            }
        }
    }

    private void handleJarDelete(JarFileDeleteEvent jarFileDeleteEvent) {
        db.severe("Jar file deleted: " + jarFileDeleteEvent.toString());
        if (jarFileDeleteEvent.getClassLoaderEnum().equals((Object)ClassLoaderEnum.ELE)) {
            ErrorMsg.displayError((Component)this.getMainPanel(), (EID)NEMC.EID_SESSION_FILES_DELETED);
        } else {
            boolean bl = CerentDialog.yesNoDialog((Component)this.getMainPanel(), (String)"CTC has detected a jar file deletion.\nThe jar file was part of the core CTC\napplication. It is recommended that you\nexit this CTC session and start a new one.\nIf you choose to continue, unexpected\nresults are likely to occur.\n\nDo you want to exit now?", (String)"Jar File Deleted", (int)0);
            if (bl) {
                this.exitCtc(false);
            }
        }
    }

    static {
        preferences = Preferences.instance();
        db = new CtcAppDebug("CtcApplication");
        idleTimerdb = new IdleTimerDebug("IdleTimer");
        exitSuspended = false;
    }

    private class Cleaner
    implements Runnable {
        private Thread caller;

        Cleaner(Thread thread) {
            this.caller = thread;
        }

        @Override
        public void run() {
            block8: {
                Vector vector;
                block7: {
                    try {
                        if (db.on()) {
                            db.println("Disposing ncp objects");
                        }
                        NetCircuitManager.instance().dispose();
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block7;
                        db.println("Caught exception - ");
                        db.println("       ncp object destroy may be incomplete");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                JobControllerFactory.dispose();
                if (db.on()) {
                    db.println("Checking Preferences listeners");
                }
                if ((vector = preferences.getListeners()) != null) {
                    CmsObservable.listObservers(this, vector);
                }
                DialogCache.destroy();
                try {
                    NetworkModel.instance().destroy();
                }
                catch (Exception exception) {
                    if (!db.on()) break block8;
                    db.println("Caught exception - ");
                    db.println("       Network Model destroy may be incomplete");
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            CtcApplication.this.cmsControl = null;
            instance = null;
            CtcApplication.this.nodeName = null;
            CtcApplication.this.prd = null;
            CtcApplication.this.protectedThreads = null;
            CtcApplication.this.runException = null;
            CtcApplication.this.runReason = null;
            this.caller.interrupt();
        }
    }

    public static class CtcAppDebug
    extends SDebug
    implements IDebugDiag {
        public CtcAppDebug(String string) {
            super(string);
        }

        public final void suspend(boolean bl) {
            exitSuspended = bl;
        }

        public final void dumpDiag() {
            this.display("Recommended JVM:" + JreReqs.CURRENT.RECOMMENDED_VERSION);
            this.display("CTC (NET) Version:" + BuildInfo.sanitize(BuildInfo.version));
            this.display("Built:" + BuildInfo.date);
            this.display("Started:" + DateFormat.getDateTimeInstance().format(new Date(startTime)));
            this.display("Dump time:" + DateFormat.getDateTimeInstance().format(new Date()));
            try {
                this.display("Host:" + InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                CtcAppDebug.printStackTrace((Throwable)unknownHostException);
            }
            this.display("Login user name:" + NetSecurityModel.instance().getUserName());
            this.display("Login node:" + instance.nodeName);
            this.display("Additional login node group:" + instance.additionalNodeGroup);
            String[] stringArray = PrefsNodesPropertyPane.getGroupMembers(instance.additionalNodeGroup);
            for (int i = 0; i < stringArray.length; ++i) {
                this.display("    " + stringArray[i]);
            }
            this.display("Disable Network Discovery:" + instance.excludeDynamic);
            this.display("Disable Circuit Management:" + instance.cktMgtDisabled);
        }

        public final String getDiagLabel() {
            return "General";
        }
    }

    public static class IdleTimerDebug
    extends SDebug {
        public static final String Hstart = "Start the IdleTimer";
        public static final String Hstop = "Stop the IdleTimer";
        public static final String Hfire = "Fire the IdleTimer";

        public IdleTimerDebug(String string) {
            super(string);
        }

        public final void start() {
            instance.timer.setActive(true);
            instance.startIdleTimer();
            this.println("Idle timer enabled");
        }

        public final void stop() {
            instance.timer.setActive(false);
            instance.stopIdleTimer();
            this.println("Idle timer disabled");
        }

        public final void fire() {
            instance.fireIdleTimer();
            this.println("fired idle timer");
        }
    }
}

