/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc.util.map;

import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractGraph;
import com.cisco.ctc.util.map.Link;
import com.cisco.ctc.util.map.LinkBundle;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.ctc.util.map.MapImage;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapNode;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import com.cisco.fv.grapher.util.FvMapGraph;
import com.cisco.fv.grapher.util.MapGrapherNode;
import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;

public class MapGraph
extends AbstractGraph {
    private MapImage bkImage = null;
    private Color backColor = Color.lightGray;
    protected LinkedList<MapLink> connectedLinks = new LinkedList();

    public MapGraph(MapToolkit mapToolkit) {
        super(mapToolkit);
        this.initProperties();
    }

    public MapGraph(MapToolkit mapToolkit, Object object) {
        super(mapToolkit, object);
        this.initProperties();
    }

    public MapGraph(MapToolkit mapToolkit, Object object, boolean bl) {
        super(mapToolkit, object, bl);
        this.initProperties();
    }

    private void initProperties() {
        this.mtk.getMapProperty((Object)this, 108);
        if (!this.mtk.getMapProperty((Object)this, 107)) {
            this.setBackgroundColor(Color.lightGray);
        }
    }

    @Override
    public void removeBackgroundImage() {
        if (this.bkImage != null & this.contains((Object)this.bkImage)) {
            this.remove((IlvGraphic)this.bkImage);
            this.bkImage = null;
            this.mtk.mapPropertyChanged((Object)this, 108, null, null);
        }
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setBackgroundColor(Color color) {
        this.backColor = color;
        this.mtk.mapPropertyChanged((Object)this, 107, null, null);
    }

    @Override
    public void setBackgroundImage(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        try {
            URL uRL = new URL("file:///" + file.getCanonicalPath());
            this.setBackgroundImage(uRL);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.mtk.mapPropertyChanged((Object)this, 108, null, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBackgroundImage(URL uRL) {
        if (uRL == null) {
            return;
        }
        if (this.bkImage != null && this.contains((Object)this.bkImage)) {
            this.remove((IlvGraphic)this.bkImage);
        }
        this.bkImage = new MapImage(uRL);
        if (this.bkImage == null) return;
        this.add((Object)this.bkImage);
        if (this.bkImage.getWidth() != 0.0 && this.bkImage.getHeight() != 0.0) {
            MapGraph mapGraph = this;
            if (!(this.bkImage.getWidth() > (double)mapGraph.mtk.getCanvasWidth())) {
                MapGraph mapGraph2 = this;
                if (!(this.bkImage.getHeight() > (double)mapGraph2.mtk.getCanvasHeight())) {
                    MapGraph mapGraph3 = this;
                    double d = (double)mapGraph3.mtk.getCanvasCenterX() - this.bkImage.getWidth() / 2.0;
                    MapGraph mapGraph4 = this;
                    double d2 = (double)mapGraph4.mtk.getCanvasCenterY() - this.bkImage.getHeight() / 2.0;
                    this.bkImage.setLocation(d, d2);
                    return;
                }
            }
        }
        this.bkImage.setLocation(0.0, 0.0);
    }

    Rectangle2D.Double getBackgroundImageRect() {
        if (this.bkImage == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return new Rectangle2D.Double(0.0, 0.0, this.bkImage.getWidth(), this.bkImage.getHeight());
    }

    public MapNode getMapNode(Object object) {
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapNode mapNode;
            ActionListener actionListener;
            if (objectArray[i] instanceof MapNode && (actionListener = (MapNode)objectArray[i]).getUserObject().equals(object)) {
                return actionListener;
            }
            if (!(objectArray[i] instanceof FvMapGraph) || (mapNode = (MapNode)(actionListener = (FvMapGraph)objectArray[i]).getCollapsedGraphic()) == null || !mapNode.getUserObject().equals(object)) continue;
            return mapNode;
        }
        return null;
    }

    public MapGraph getMapGraph(Object object) {
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapGraph mapGraph;
            if (!(objectArray[i] instanceof MapGraph) || !((mapGraph = (MapGraph)((Object)objectArray[i])).getOwner() instanceof MapGrapherNode) || !((MapGrapherNode)mapGraph.getOwner()).getUserObject().equals(object)) continue;
            return mapGraph;
        }
        return null;
    }

    public MapNode[] getMapNodes() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof MapNode)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapNode[0]);
    }

    public Link[] getLinks() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof LinkBundle) {
                LinkBundle linkBundle = (LinkBundle)objectArray[i];
                Link[] linkArray = linkBundle.getLinks();
                if (linkArray == null) continue;
                for (int j = 0; j < linkArray.length; ++j) {
                    linkedList.add(linkArray[j]);
                }
                continue;
            }
            if (!(objectArray[i] instanceof Link)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new Link[0]);
    }

    public Node[] getNodes() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Node)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new Node[0]);
    }

    MapLink[] getMapLinks() {
        LinkedList<Link> linkedList = new LinkedList<Link>();
        Link[] linkArray = this.getLinks();
        for (int i = 0; i < linkArray.length; ++i) {
            if (!(linkArray[i] instanceof MapLink)) continue;
            linkedList.add(linkArray[i]);
        }
        return linkedList.toArray(new MapLink[0]);
    }

    public MapLinkBundle[] getDomainLinks() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapLinkBundle mapLinkBundle;
            if (!(objectArray[i] instanceof MapLinkBundle) || !(mapLinkBundle = (MapLinkBundle)objectArray[i]).isDomainLink()) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapLinkBundle[0]);
    }

    public MapLinkBundle[] getGrapherLinks() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object[] objectArray = this.getComponents();
        for (int i = 0; i < objectArray.length; ++i) {
            MapLinkBundle mapLinkBundle;
            if (!(objectArray[i] instanceof MapLinkBundle) || !(mapLinkBundle = (MapLinkBundle)objectArray[i]).isGrapherLink()) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList.toArray(new MapLinkBundle[0]);
    }

    public String getDomainName() {
        Object object = this.getOwner();
        if (object instanceof MapDomain) {
            return ((MapDomain)object).getName();
        }
        return "";
    }

    public void linkAdded(MapLink mapLink) {
        this.connectedLinks.add(mapLink);
    }

    public void linkRemoved(MapLink mapLink) {
        this.connectedLinks.remove(mapLink);
    }
}

