/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv;

import cerent.cms.fv.IFVPowerModel;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.circuits.FVCircuitsTabbedView;
import cerent.cms.ui.network.NetworkTabbedView;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.view.fv.IPowerBallon;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.alarms.FvNetworkAlarmStore;
import com.cisco.fv.circuit.FvPatchCordVerify;
import com.cisco.fv.grapher.FunctNetMapNode;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.gui.NfvMenuToolBar;
import com.cisco.fv.power.PowerBallon;
import com.cisco.fv.power.SpanLossBalloon;
import java.awt.Cursor;
import java.util.Iterator;
import java.util.LinkedList;

public class FunctViewManagerDelegate
extends UObservable
implements IPowerBallon {
    public static final int SPANLOSS_BALLOON = 0;
    public static final int PORTPOWER_BALLOON = 1;
    public static final int ALL_BALLOON = 2;
    private SDebug db = new SDebug("FunctViewManagerDelegate");
    private static FunctViewManagerDelegate _instance;
    private static FvNetworkAlarmStore alarmStore;
    private int hasOpenNode = 0;
    private FvNetworkMap networkMap;
    private boolean portPowerIsVisible = false;
    private boolean spanlossPowerIsVisible = false;
    private FVCircuitsTabbedView circuitTabPane;
    private Integer activedisabled;
    private Boolean exclusive = new Boolean(false);
    private NfvMenuToolBar toolBar;
    private FvPatchCordVerify fvPatchCordVeirfy;
    private static LinkedList<FunctNetMapNode> openNodes;

    protected FunctViewManagerDelegate() {
        this.initVariable();
    }

    private void initVariable() {
        this.portPowerIsVisible = false;
        this.spanlossPowerIsVisible = false;
        alarmStore = null;
        this.activedisabled = 0;
        this.networkMap = null;
        this.circuitTabPane = null;
        this.toolBar = null;
        this.fvPatchCordVeirfy = null;
    }

    public static FunctViewManagerDelegate getInstance() {
        if (_instance == null) {
            _instance = new FunctViewManagerDelegate();
            openNodes = new LinkedList();
        }
        return _instance;
    }

    public static FvNetworkAlarmStore getAlarmStore() {
        if (alarmStore == null) {
            alarmStore = new FvNetworkAlarmStore(((NetworkTabbedView)NetworkViewController.instance().getTabbedView()).getAlarmStore(), "FvNetworkAlarmStore");
        }
        return alarmStore;
    }

    private void closeNode(FunctNetMapNode functNetMapNode) {
        IFvNetNode iFvNetNode = (IFvNetNode)functNetMapNode.getUserObject();
        iFvNetNode.fvActive(false);
        --this.hasOpenNode;
        openNodes.remove(functNetMapNode);
        this.notifyOpenCloseNode(iFvNetNode, 1);
    }

    private void openNode(FunctNetMapNode functNetMapNode) {
        IFvNetNode iFvNetNode = (IFvNetNode)functNetMapNode.getUserObject();
        iFvNetNode.fvActive(true);
        ++this.hasOpenNode;
        openNodes.add(functNetMapNode);
        this.notifyOpenCloseNode(iFvNetNode, 0);
    }

    public LinkedList<FunctNetMapNode> getAllOpenNodes() {
        return openNodes;
    }

    private void notifyOpenCloseNode(IFvNetNode iFvNetNode, int n) {
        FunctObserverArgument functObserverArgument = new FunctObserverArgument(iFvNetNode, n);
        if (this.hasOpenNode != 1 || iFvNetNode.isFVActive()) {
            // empty if block
        }
        if (this.hasOpenNode == 0) {
            // empty if block
        }
        functObserverArgument.addNodeData(this.hasOpenNode);
        this.notifyObserver(functObserverArgument);
    }

    private void notifyObserver(FunctObserverArgument functObserverArgument) {
        this.setChanged();
        this.notifyObservers(functObserverArgument);
    }

    public void powerButtonAction(boolean bl, int n) {
        if (n == 1) {
            this.portPowerIsVisible = bl;
            if (bl) {
                PowerBallon.getInstance().startCalculation(this);
            } else {
                FvNetworkMap.getInstance().showPower(this.portPowerIsVisible, n);
            }
        } else if (n == 0) {
            this.spanlossPowerIsVisible = bl;
            if (bl) {
                SpanLossBalloon.getInstance().startCalculation(this);
            } else {
                FvNetworkMap.getInstance().showPower(this.spanlossPowerIsVisible, n);
            }
        }
    }

    public void addNetworkMap(FvNetworkMap fvNetworkMap) {
        this.networkMap = fvNetworkMap;
    }

    public FvNetworkMap getNetworkMap() {
        return this.networkMap;
    }

    public boolean isPowerVisible() {
        return this.portPowerIsVisible;
    }

    public boolean isSpanLossPowerVisible() {
        return this.spanlossPowerIsVisible;
    }

    public void dispose() {
        _instance = null;
        if (alarmStore != null) {
            alarmStore.destroy();
        }
        PowerBallon.getInstance().dispose();
        this.initVariable();
    }

    public void nodeChange(FunctNetMapNode functNetMapNode, int n) {
        switch (n) {
            case 4: {
                IFvNetNode iFvNetNode = (IFvNetNode)functNetMapNode.getUserObject();
                FunctObserverArgument functObserverArgument = new FunctObserverArgument(iFvNetNode, n);
                this.notifyObserver(functObserverArgument);
                break;
            }
            case 1: {
                this.closeNode(functNetMapNode);
                break;
            }
            case 0: {
                this.openNode(functNetMapNode);
                break;
            }
            default: {
                if (!this.db.on()) break;
                this.db.println("Wrong case in node change");
            }
        }
    }

    public void powerModelUpdate(IFVPowerModel iFVPowerModel) {
        if (this.networkMap != null) {
            this.networkMap.calculatePowerBalloon();
        }
    }

    public void addCircuitPane(FVCircuitsTabbedView fVCircuitsTabbedView) {
        this.circuitTabPane = fVCircuitsTabbedView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void circuitTableAndToolsButtonEnable(boolean bl, boolean bl2) {
        Integer n = this.activedisabled;
        synchronized (n) {
            if (this.circuitTabPane == null) {
                return;
            }
            if (!bl) {
                Integer n2 = this.activedisabled;
                Integer n3 = this.activedisabled = Integer.valueOf(this.activedisabled + 1);
                if (this.db.on()) {
                    this.db.println("Enable =" + bl + "    activedisabled" + this.activedisabled);
                    this.db.println("ADDED - activedisabled = " + this.activedisabled);
                }
                if (this.activedisabled == 1) {
                    if (this.db.on()) {
                        this.db.println("DISABLE all !!!!!!!!!!!!");
                    }
                    this.setMousePointer(3);
                    this.circuitTabPane.setEnabledAllComponents(bl);
                    if (this.toolBar != null) {
                        this.toolBar.enableButtons(bl);
                    }
                }
            } else {
                if (this.activedisabled > 0) {
                    Integer n4 = this.activedisabled;
                    Integer n5 = this.activedisabled = Integer.valueOf(this.activedisabled - 1);
                }
                if (this.db.on()) {
                    this.db.println("Enable =" + bl + "    activedisabled" + this.activedisabled);
                    this.db.println("DELETED - activedisabled = " + this.activedisabled);
                }
                if (bl2) {
                    this.activedisabled = 0;
                }
                if (this.activedisabled == 0) {
                    if (this.db.on()) {
                        this.db.println("ENABLE all !!!!!!!!!!!!");
                    }
                    this.setMousePointer(0);
                    this.circuitTabPane.setEnabledAllComponents(bl);
                    if (this.toolBar != null) {
                        this.toolBar.enableButtons(bl);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void circuitTableEnable(boolean bl) {
        Integer n = this.activedisabled;
        synchronized (n) {
            if (this.circuitTabPane == null) {
                return;
            }
            if (!bl) {
                Integer n2 = this.activedisabled;
                Integer n3 = this.activedisabled = Integer.valueOf(this.activedisabled + 1);
                if (this.db.on()) {
                    this.db.println("ADDED - activedisabled = " + this.activedisabled);
                }
                if (this.activedisabled == 1) {
                    if (this.db.on()) {
                        this.db.println("DISABLE all !!!!!!!!!!!!");
                    }
                    this.setMousePointer(3);
                    this.circuitTabPane.setEnabledAllComponents(bl);
                }
            } else {
                Integer n4 = this.activedisabled;
                Integer n5 = this.activedisabled = Integer.valueOf(this.activedisabled - 1);
                if (this.db.on()) {
                    this.db.println("DELETED - activedisabled = " + this.activedisabled);
                }
                if (this.activedisabled == 0) {
                    if (this.db.on()) {
                        this.db.println("ENABLE all !!!!!!!!!!!!");
                    }
                    this.setMousePointer(0);
                    this.circuitTabPane.setEnabledAllComponents(bl);
                }
            }
        }
    }

    public void addToolBar(NfvMenuToolBar nfvMenuToolBar) {
        this.toolBar = nfvMenuToolBar;
    }

    public void patchCordVerify(boolean bl) {
        if (this.fvPatchCordVeirfy == null) {
            this.fvPatchCordVeirfy = new FvPatchCordVerify();
        }
        this.fvPatchCordVeirfy.verifyPatchCord(bl);
    }

    public void refreshButtonAction() {
        if (this.portPowerIsVisible) {
            PowerBallon.getInstance().startCalculation(this);
        }
        if (this.spanlossPowerIsVisible) {
            SpanLossBalloon.getInstance().startCalculation(this);
        }
        Iterator iterator = openNodes.iterator();
        while (iterator.hasNext()) {
            FunctObserverArgument functObserverArgument = new FunctObserverArgument(((FunctNetMapNode)iterator.next()).getNodeModel(), 3);
            functObserverArgument.setRefreshPowerData();
            this.notifyObserver(functObserverArgument);
        }
    }

    public void setMousePointer(int n) {
        FvNetworkMap fvNetworkMap = this.getNetworkMap();
        if (fvNetworkMap != null) {
            fvNetworkMap.setCursor(new Cursor(n));
        }
    }

    public void powerPortIsReady() {
        FvNetworkMap.getInstance().showPower(this.portPowerIsVisible, 1);
    }

    public void spanLossIsReady() {
        FvNetworkMap.getInstance().showPower(this.spanlossPowerIsVisible, 0);
    }

    static {
        alarmStore = null;
    }
}

