/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit;

import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.network.NetworkTabbedView;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.alarms.FVEventPanel;
import com.cisco.fv.alarms.FVPaintAlarm;
import com.cisco.fv.alarms.FvCircuitAlarmStore;
import com.cisco.fv.circuit.FvSelCircuitPwrPane;
import com.cisco.fv.circuit.model.FvCircuitModels;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class FvSelCircuitToolPane
extends JTabbedPane
implements IObserver,
IEventPanelController {
    private FvSelCircuitPwrPane powerPane;
    private FvSelectedCircuitModel ckt;
    private FvCircuitAlarmStore alarmStore;
    private FVEventPanel eventPane;
    private KDebug sd = new KDebug("FvSelCircuitToolPane");
    private Thread updAlarmStore;
    private Boolean threadRunning = false;
    private static FvSelCircuitToolPane _instance;

    public FvSelCircuitToolPane() {
        this.powerPane = new FvSelCircuitPwrPane();
        this.addTab("Span and Power Level", (Component)((Object)this.powerPane));
        this.addAlarmPane();
        this.addTab("Circuit Alarms", this.eventPane);
        FvCircuitModels.getInstance().addObserver(this);
        FunctViewManagerDelegate.getInstance().addObserver(this);
        _instance = this;
    }

    private FVEventPanel addAlarmPane() {
        int n = 31457;
        this.alarmStore = new FvCircuitAlarmStore(((NetworkTabbedView)NetworkViewController.instance().getTabbedView()).getAlarmStore());
        this.alarmStore.addFilterPane(FunctViewManagerDelegate.getAlarmStore().getFilterPane());
        this.eventPane = new FVEventPanel(this.alarmStore, (IEventPanelController)this, n);
        this.alarmStore.addEventPanel(this.eventPane);
        this.eventPane.getTable().setName("Circuit Alarm");
        this.alarmStore.getAlarmStore().getStoreObservable().addObserver((IObserver)this);
        return this.eventPane;
    }

    public synchronized void update(IObservable iObservable, Object object) {
        if (iObservable instanceof FvCircuitModels) {
            this.handleChanges((FvCircuitModels.NotifyCircuitModel)object);
        } else if (object instanceof FunctObserverArgument) {
            switch (((FunctObserverArgument)object).getType()) {
                case 5: {
                    this.refreshTable();
                    break;
                }
                case 0: 
                case 1: {
                    this.powerPane.update(iObservable, object);
                    break;
                }
                case 3: {
                    this.powerPane.update(iObservable, object);
                    this.powerPane.refreshTable();
                }
            }
        }
    }

    public void refreshTable() {
        this.powerPane.refreshTable();
    }

    public void updateTable(IFvNetNode iFvNetNode) {
        this.powerPane.updateTable(iFvNetNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updAlarmStore() {
        Boolean bl = this.threadRunning;
        synchronized (bl) {
            if (!this.threadRunning.booleanValue() && this.ckt != null) {
                this.updAlarmStore = new Thread((Runnable)new AlarmThread(), "Alm Refresh FvSelCircuitToolPane");
                this.updAlarmStore.start();
            }
        }
    }

    private INetCircuit handleChanges(FvCircuitModels.NotifyCircuitModel notifyCircuitModel) {
        INetCircuit iNetCircuit = null;
        switch (notifyCircuitModel.changes) {
            case 0: {
                if (this.sd.on()) {
                    this.sd.println("Circuit Selected");
                }
                if (this.ckt != null) {
                    ((INetCircuit)this.ckt.getCircuitModel()).deleteObserver(this);
                }
                this.ckt = (FvSelectedCircuitModel)FvCircuitModels.getInstance().getCircuit(notifyCircuitModel.id);
                iNetCircuit = (INetCircuit)this.ckt.getCircuitModel();
                this.updatePanels(notifyCircuitModel.changes);
                iNetCircuit.addObserver(this);
                break;
            }
            case 1: {
                if (this.ckt == null || this.ckt.getCircuitId() != notifyCircuitModel.id) break;
                if (this.sd.on()) {
                    this.sd.println("Circuit DE-selected");
                }
                ((INetCircuit)this.ckt.getCircuitModel()).deleteObserver(this);
                this.updatePanels(notifyCircuitModel.changes);
                this.ckt.dispose();
                this.ckt = null;
                break;
            }
        }
        return iNetCircuit;
    }

    private void updatePanels(int n) {
        switch (n) {
            case 0: {
                this.powerPane.newCircuit(this.ckt);
                this.updAlarmStore();
                break;
            }
            case 1: {
                FVPaintAlarm.getInstance().clearAlarms();
                ((FvCircuitAlarmStore)this.eventPane.getAlarmStore()).removeCircuits();
                break;
            }
            default: {
                if (!this.sd.on()) break;
                this.sd.println("Impossible to update the panel on a wron notify");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, JTable jTable, AbstractTableModel abstractTableModel) {
    }

    public void destroy() {
        INetCircuit iNetCircuit;
        FvCircuitModels.getInstance().deleteObserver(this);
        if (this.alarmStore != null) {
            this.alarmStore.getAlarmStore().getStoreObservable().deleteObserver((IObserver)this);
            this.alarmStore.destroy();
            this.alarmStore = null;
        }
        if (this.ckt != null && (iNetCircuit = (INetCircuit)this.ckt.getCircuitModel()) != null) {
            iNetCircuit.deleteObserver(this);
        }
        this.powerPane.destroy();
        this.powerPane = null;
        this.eventPane.dispose();
        this.eventPane = null;
        _instance = null;
    }

    public JTable[] getTables() {
        JTable[] jTableArray = new JTable[]{this.eventPane.getTable(), this.powerPane.getTable()};
        return jTableArray;
    }

    public static FvSelCircuitToolPane getInstance() {
        return _instance;
    }

    private class AlarmThread
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AlarmThread() {
            Boolean bl = FvSelCircuitToolPane.this.threadRunning;
            synchronized (bl) {
                FvSelCircuitToolPane.this.threadRunning = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Boolean bl = FvSelCircuitToolPane.this.threadRunning;
            synchronized (bl) {
                if (FvSelCircuitToolPane.this.ckt != null && FvSelCircuitToolPane.this.eventPane != null) {
                    ((FvCircuitAlarmStore)FvSelCircuitToolPane.this.eventPane.getAlarmStore()).newCircuit(FvSelCircuitToolPane.this.ckt);
                    FvSelCircuitToolPane.this.eventPane.refresh();
                }
                FvSelCircuitToolPane.this.threadRunning = false;
            }
        }
    }
}

