/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.net.IFVCircuitSpan;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.OchncHelper;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchccCircuitSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.util.IObservable;
import cerent.util.SDebug;
import cerent.util.view.fv.helper.FunctDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FvSelectedCircuitModel
implements IFVSelectedPowerModel {
    private LinkedList<IFvEntityModel> pathIn;
    private LinkedList<IFvEntityModel> pathOut;
    private int lambda = 0;
    private Integer circuitType;
    private INetCircuit circuitModel = null;
    private INetCircuit[] trailModel = null;
    private List<IObservable> ctcNodeLinkModels;
    private HashMap nodesPathIn;
    private HashMap nodesPathOut;
    private HashMap nodesLamda;
    private HashMap<Integer, IFvNetElement> usedNode = new HashMap();
    private static Boolean newCircuit = true;
    static final SDebug sd = new SDebug("FVCircuitTableModel");

    public FvSelectedCircuitModel() {
        this.ctcNodeLinkModels = new ArrayList<IObservable>();
        this.nodesPathIn = new HashMap();
        this.nodesPathOut = new HashMap();
        this.nodesLamda = new HashMap();
    }

    public FvSelectedCircuitModel(INetCircuit iNetCircuit) {
        this();
        this.addCircuitModel(iNetCircuit);
        this.addCircuitType(iNetCircuit.getCircuitType());
        int n = iNetCircuit.getCircuitOptChannel();
        this.addUsedLambda(n);
    }

    public void addPathIn(LinkedList<IFvEntityModel> linkedList) {
        this.pathIn = linkedList;
    }

    public void addPathOut(LinkedList<IFvEntityModel> linkedList) {
        this.pathOut = linkedList;
    }

    public void addPathInForNode(LinkedList<IFvEntityModel> linkedList, INetElement iNetElement) {
        this.nodesPathIn.put(iNetElement, linkedList);
    }

    public void addPathOutForNode(LinkedList<IFvEntityModel> linkedList, INetElement iNetElement) {
        this.nodesPathOut.put(iNetElement, linkedList);
    }

    public void addUsedLambda(int n) {
        this.lambda = n;
    }

    public void addUsedLambdaForNode(int n, INetElement iNetElement) {
        this.nodesLamda.put(iNetElement, new Integer(n));
    }

    public void addCircuitType(int n) {
        this.circuitType = new Integer(n);
    }

    public LinkedList<IFvEntityModel> getPathIn() {
        return this.pathIn;
    }

    public LinkedList<IFvEntityModel> getPathInForNode(INetElement iNetElement) {
        return (LinkedList)this.nodesPathIn.get(iNetElement);
    }

    public LinkedList<IFvEntityModel> getPathInForNode(IFvNodeModel iFvNodeModel) {
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        INetElement iNetElement = netCircuitManager.getNetwork().getNetElem(iFvNodeModel.getNodeId());
        return (LinkedList)this.nodesPathIn.get(iNetElement);
    }

    public LinkedList<IFvEntityModel> getPathOutForNode(IFvNodeModel iFvNodeModel) {
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        INetElement iNetElement = netCircuitManager.getNetwork().getNetElem(iFvNodeModel.getNodeId());
        return (LinkedList)this.nodesPathOut.get(iNetElement);
    }

    public LinkedList<IFvEntityModel> getPathOut() {
        return this.pathOut;
    }

    public LinkedList<IFvEntityModel> getPathOutForNode(INetElement iNetElement) {
        return (LinkedList)this.nodesPathOut.get(iNetElement);
    }

    public int getLambda() {
        return this.lambda;
    }

    public int getLambdaForNode(INetElement iNetElement) {
        return (Integer)this.nodesLamda.get(iNetElement);
    }

    public Integer getCircuitType() {
        return this.circuitType;
    }

    public ICircuitId getCircuitId() {
        if (this.circuitModel != null) {
            Integer n = this.circuitModel.getCircuitType();
            if (n == 14) {
                if (this.trailModel != null && this.trailModel.length != 0) {
                    return this.trailModel[0].getCircuitId();
                }
            } else {
                return this.circuitModel.getCircuitId();
            }
        }
        return null;
    }

    public void addCircuitModel(INetCircuit iNetCircuit) {
        this.circuitModel = iNetCircuit;
        Integer n = this.circuitModel.getCircuitType();
        this.trailModel = n == 14 ? ((OchccCircuit)this.circuitModel).getTunnelCircuits() : null;
    }

    public Object getCircuitModel() {
        INetCircuit iNetCircuit = this.circuitModel;
        if (newCircuit.booleanValue()) {
            if (this.trailModel != null && this.trailModel.length != 0) {
                iNetCircuit = this.trailModel[0];
                return iNetCircuit;
            }
            return iNetCircuit;
        }
        return iNetCircuit;
    }

    private INetCircuit getSecondTunnel() {
        if (this.trailModel != null) {
            return this.trailModel[1];
        }
        return null;
    }

    public Object getCircuitModel(boolean bl) {
        if (bl) {
            return this.circuitModel;
        }
        return this.getCircuitModel();
    }

    public IFvNetNode getDstNode() {
        INetElement iNetElement = ((NetCircuit)this.getCircuitModel()).getDropNE();
        if (iNetElement == null) {
            return null;
        }
        return (IFvNetNode)iNetElement.getNodeModel();
    }

    public List<IFvNetNode> getSpanNodes() {
        ArrayList<IFvNetNode> arrayList = new ArrayList<IFvNetNode>();
        List list = ((NetCircuit)this.getCircuitModel()).getCircuitNodes();
        for (INetCircuitNode iNetCircuitNode : list) {
            IFvNetNode iFvNetNode = (IFvNetNode)iNetCircuitNode.getNodeModel();
            if (arrayList.contains(iFvNetNode)) continue;
            arrayList.add(iFvNetNode);
        }
        return arrayList;
    }

    public IFvNetNode getSrcNode() {
        INetElement iNetElement = ((NetCircuit)this.getCircuitModel()).getSourceNE();
        if (iNetElement == null) {
            return null;
        }
        return (IFvNetNode)iNetElement.getNodeModel();
    }

    public List<INetCircuitSpan> orderLinks() {
        ArrayList<INetCircuitSpan> arrayList;
        List<INetCircuitSpan> list = this.findNcFromCc();
        if (((INetCircuit)this.getCircuitModel()).getState() == 4) {
            return list;
        }
        if (sd.on()) {
            arrayList = (INetCircuit)this.getCircuitModel();
            sd.println(arrayList.getCircuitName() + "ENTER");
        }
        if (((INetCircuit)this.getCircuitModel()).getCircuitType() != 9) {
            arrayList = new ArrayList();
            for (INetCircuitSpan iNetCircuitSpan : list) {
                if (iNetCircuitSpan.isInternalSpan()) continue;
                arrayList.add(iNetCircuitSpan);
            }
        } else {
            arrayList = new ArrayList<INetCircuitSpan>(list);
        }
        return arrayList;
    }

    private List<INetCircuitSpan> findNcFromCc() {
        boolean bl = this.circuitModel.isCircuitProtected();
        ArrayList<INetCircuitSpan> arrayList = new ArrayList<INetCircuitSpan>();
        if (!(bl &= this.circuitModel.getCircuitType() == 14)) {
            INetCircuit iNetCircuit = (INetCircuit)this.getCircuitModel();
            List list = iNetCircuit.getCircuitSpans();
            for (INetCircuitSpan iNetCircuitSpan : list) {
                arrayList.add(iNetCircuitSpan);
            }
        } else {
            for (int i = 0; i < this.trailModel.length; ++i) {
                INetCircuit iNetCircuit = this.trailModel[i];
                List list = iNetCircuit.getCircuitSpans();
                for (INetCircuitSpan iNetCircuitSpan : list) {
                    arrayList.add(iNetCircuitSpan);
                }
            }
        }
        return arrayList;
    }

    private void getSpanFromOch(OchccCircuit ochccCircuit, ArrayList<INetCircuitSpan> arrayList) {
        Object object;
        INetCircuit[] iNetCircuitArray = ochccCircuit.getTunnelCircuits();
        if (iNetCircuitArray.length == 0) {
            List list = ochccCircuit.getCircuitSpans();
            object = list.iterator();
            while (object.hasNext()) {
                arrayList.add((INetCircuitSpan)object.next());
            }
        }
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            object = iNetCircuitArray[i].getCircuitSpans();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
                if (arrayList.contains(iNetCircuitSpan)) continue;
                arrayList.add(iNetCircuitSpan);
            }
        }
    }

    public List<IFVCircuitSpan> getCircuitSpans() {
        List<INetCircuitSpan> list = this.orderLinks();
        ArrayList<IFVCircuitSpan> arrayList = new ArrayList<IFVCircuitSpan>();
        Iterator<INetCircuitSpan> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add((IFVCircuitSpan)iterator.next());
        }
        return arrayList;
    }

    public List<IFvNetLink> getCircuitLink() {
        ArrayList<IFvNetLink> arrayList = new ArrayList<IFvNetLink>();
        List<IFVCircuitSpan> list = this.getCircuitSpans();
        for (IFVCircuitSpan iFVCircuitSpan : list) {
            arrayList.add(iFVCircuitSpan.getIFvLink());
        }
        return arrayList;
    }

    public ArrayList<HashMap<String, String>> getNodePower(IFvNetNode iFvNetNode) {
        return null;
    }

    public String[] getSpanLoss(IFvNetNode iFvNetNode, IFvNetLink iFvNetLink) {
        if (iFvNetNode.isInited()) {
            this.addObserver(iFvNetLink);
            try {
                return ((NodeModel)iFvNetNode).getSpanLoss(OchncHelper.getSideFromPortIndex((NodeModel)iFvNetNode, ((INetLink)iFvNetLink).getSrcEntityIndex()));
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private String printablePwr(int n) {
        String string = String.valueOf(n);
        int n2 = string.startsWith("-") ? 2 : 1;
        string = string.length() > n2 ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (n2 == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    public void dispose() {
        for (IObservable iObservable : this.ctcNodeLinkModels) {
        }
        this.ctcNodeLinkModels.clear();
    }

    private void addObserver(IFvNetLink iFvNetLink) {
        IFvNetElement iFvNetElement = iFvNetLink.getDestination();
        IFvNetElement iFvNetElement2 = iFvNetLink.getSource();
        this.usedNode.put(iFvNetElement.getNetworkNode().getNodeId(), iFvNetElement);
        this.usedNode.put(iFvNetElement2.getNetworkNode().getNodeId(), iFvNetElement2);
        if (!this.ctcNodeLinkModels.contains(iFvNetLink)) {
            this.ctcNodeLinkModels.add((IObservable)iFvNetLink);
        }
    }

    public HashMap<Integer, IFvNetElement> getUsedNode() {
        return this.usedNode;
    }

    public void addPortsForCircuitNode(IFvNetNode iFvNetNode) {
        this.addIngressAndEgressPorts(this, iFvNetNode.getNodeId());
    }

    public void addPortsForCircuitNodes() {
        List<IFvNetNode> list = this.getSpanNodes();
        for (int i = 0; i < list.size(); ++i) {
            IFvNetNode iFvNetNode = list.get(i);
            if (!iFvNetNode.isFVActive()) continue;
            this.addIngressAndEgressPorts(this, iFvNetNode.getNodeId());
        }
    }

    private void addIngressAndEgressPorts(FvSelectedCircuitModel fvSelectedCircuitModel, int n) {
        int n2;
        INetCircuit[] iNetCircuitArray;
        int n3 = -1;
        LinkedList<IFvEntityModel> linkedList = new LinkedList<IFvEntityModel>();
        LinkedList<IFvEntityModel> linkedList2 = new LinkedList<IFvEntityModel>();
        INetCircuit iNetCircuit = (INetCircuit)fvSelectedCircuitModel.getCircuitModel(true);
        if (iNetCircuit.getCircuitType() == 14 && iNetCircuit.isCircuitProtected()) {
            iNetCircuitArray = new INetCircuit[2];
            iNetCircuitArray[1] = this.getSecondTunnel();
        } else {
            iNetCircuitArray = new INetCircuit[]{(INetCircuit)fvSelectedCircuitModel.getCircuitModel()};
        }
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        INetElement iNetElement = netCircuitManager.getNetwork().getNetElem(n);
        for (n2 = 0; n2 < iNetCircuitArray.length; ++n2) {
            List list = iNetCircuitArray[n2].getCircuitNodeFromNE(iNetElement);
            INetCircuitNode iNetCircuitNode2 = null;
            if (list == null) continue;
            for (INetCircuitNode iNetCircuitNode2 : list) {
                n3 = iNetCircuitNode2.getCircuit().getCircuitType();
                this.findDatafromCircuit(iNetCircuitNode2, linkedList2, linkedList, iNetElement);
            }
        }
        if (n3 != -1) {
            fvSelectedCircuitModel.addPathInForNode(linkedList2, iNetElement);
            fvSelectedCircuitModel.addPathOutForNode(linkedList, iNetElement);
            n2 = ((INetCircuit)fvSelectedCircuitModel.getCircuitModel()).getCircuitOptChannel();
            fvSelectedCircuitModel.addUsedLambdaForNode(this.lambda, iNetElement);
            fvSelectedCircuitModel.addCircuitType(n3);
        }
    }

    private void findDatafromCircuit(INetCircuitNode iNetCircuitNode, LinkedList<IFvEntityModel> linkedList, LinkedList<IFvEntityModel> linkedList2, INetElement iNetElement) {
        List list = iNetCircuitNode.getPathList();
        if (iNetCircuitNode.getCircuit().getCircuitType() == 14) {
            OchccCircuitSpan ochccCircuitSpan = (OchccCircuitSpan)((OchccCircuitNode)iNetCircuitNode).getAllSpansList().get(0);
            if (ochccCircuitSpan.getIFvLink() instanceof OchTrailTunnelNetLink) {
                OchTrailTunnelNetLink ochTrailTunnelNetLink = (OchTrailTunnelNetLink)ochccCircuitSpan.getIFvLink();
                List list2 = ochTrailTunnelNetLink.getLotCircuit().getCircuitNodeFromNE(iNetElement);
                if (list2 != null && list2.size() <= 1) {
                    iNetCircuitNode = (INetCircuitNode)list2.get(0);
                }
            } else {
                return;
            }
            this.lambda = ((IOchccPathDefModel)list.get(0)).getOchTrailAdit().getOptChannel();
        } else {
            this.lambda = ((IOchncPathDefModel)list.get(0)).getOptChannel();
        }
        try {
            this.takeIngressEgressPort(iNetCircuitNode.getConnectionType(), list.toArray(), linkedList, linkedList2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            FunctDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
    }

    private void takeIngressEgressPort(int n, Object[] objectArray, LinkedList<IFvEntityModel> linkedList, LinkedList<IFvEntityModel> linkedList2) throws AbstractCmsNoSuchEntityException {
        int[] nArray = new int[]{-1, -1, -1};
        switch (n) {
            case 0: 
            case 1: 
            case 9: {
                nArray[0] = 0;
                break;
            }
            case 2: 
            case 4: 
            case 19: {
                nArray[0] = 2;
                break;
            }
            case 17: {
                nArray[0] = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                nArray[0] = 0;
                nArray[1] = 1;
                break;
            }
            case 20: {
                nArray[0] = 0;
                nArray[1] = 1;
                nArray[2] = 4;
                break;
            }
        }
        for (int i = 0; i < objectArray.length; ++i) {
            IOchncPathDefModel iOchncPathDefModel = (IOchncPathDefModel)objectArray[i];
            if (i == nArray[0] || i == nArray[1] || i == nArray[2]) {
                linkedList.add((IFvEntityModel)iOchncPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchncPathDefModel.getPortEntityIdx()));
                continue;
            }
            linkedList2.add((IFvEntityModel)iOchncPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchncPathDefModel.getPortEntityIdx()));
        }
    }

    public boolean isBidirectional() {
        return ((INetCircuit)this.getCircuitModel()).isBidirectional();
    }
}

