/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.circuit.model;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.InvalidNodeId;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchncFilterManager;
import cerent.util.KDebug;
import com.cisco.fv.circuit.model.CircuitTableRowModel;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SelectedPowerRowModel
extends CircuitTableRowModel {
    private static final int ACTIVE = 1;
    private static final int STBY = 2;
    private static final int ALL = 3;
    private IFVSelectedPowerModel circuitModel;
    public static final String POUT = "POUT";
    public static final String PIN = "PIN";
    public static final String IDX = "IDX";
    public static final String NAME = "NAME";

    public SelectedPowerRowModel(IFVSelectedPowerModel iFVSelectedPowerModel) {
        this.circuitModel = iFVSelectedPowerModel;
        this.prepareRow();
    }

    @Override
    protected void prepareRow() {
        int n;
        INetCircuit iNetCircuit = (INetCircuit)this.circuitModel.getCircuitModel();
        IFvNetNode iFvNetNode = this.circuitModel.getSrcNode();
        List<INetCircuitSpan> list = ((FvSelectedCircuitModel)this.circuitModel).orderLinks();
        if (iNetCircuit.getState() == 4) {
            while (list.size() != 0) {
                IFvNetNode iFvNetNode2 = (IFvNetNode)list.get(0).getSrcNCN().getNodeModel();
                this.prepareNodeAndLinks(iFvNetNode2, list, 3);
            }
            return;
        }
        IFvNetNode iFvNetNode3 = iFvNetNode;
        while (list.size() != 0) {
            n = list.size();
            iFvNetNode = this.prepareNodeAndLinks(iFvNetNode, list, 1);
            if (list.size() != n) continue;
            break;
        }
        if (iNetCircuit.isCircuitProtected()) {
            iFvNetNode = iFvNetNode3;
            while (list.size() != 0) {
                n = list.size();
                iFvNetNode = this.prepareNodeAndLinks(iFvNetNode, list, 2);
                if (list.size() != n) continue;
                break;
            }
        }
    }

    @Override
    String[] calculateSpanLoss(IFvNetNode iFvNetNode, IFvNetLink iFvNetLink) {
        return this.circuitModel.getSpanLoss(iFvNetNode, iFvNetLink);
    }

    @Override
    ArrayList<HashMap<String, String>> getNodePower(IFvNetNode iFvNetNode) {
        return this.circuitModel.getNodePower(iFvNetNode);
    }

    private IFvNetNode prepareNodeAndLinks(IFvNetNode iFvNetNode, List<INetCircuitSpan> list, int n) {
        INetCircuitSpan object = null;
        INetCircuitSpan object2 = null;
        IFvNetNode iFvNetNode2 = iFvNetNode;
        for (INetCircuitSpan object3 : list) {
            boolean bl;
            boolean bl2 = ((NetCircuitSpan)object3).getSpanState(((NetCircuitSpan)object3).getDstNCN().getNodeModel()) == 0;
            switch (n) {
                case 1: {
                    bl = bl2;
                    break;
                }
                case 2: {
                    bl = !bl2;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl) continue;
            if (iFvNetNode == object3.getSrcNCN().getNodeModel()) {
                object = object3;
                iFvNetNode2 = (IFvNetNode)object3.getDstNCN().getNodeModel();
                continue;
            }
            if (iFvNetNode != object3.getDstNCN().getNodeModel()) continue;
            object2 = object3;
            iFvNetNode2 = (IFvNetNode)object3.getSrcNCN().getNodeModel();
        }
        try {
            if (iFvNetNode.isFVActive()) {
                if (object2 == null) {
                    INetLink nullPointerException = OchncFilterManager.findLinkForReversePath(object.getLink(), this.sd);
                } else {
                    INetLink nullPointerException = object2.getLink();
                }
                this.prepareNode(iFvNetNode);
            }
        }
        catch (NullPointerException nullPointerException) {
            KDebug.printStackTrace((Throwable)nullPointerException);
        }
        if (object2 != null) {
            this.prepareLink(iFvNetNode, iFvNetNode2, object2.getLink());
        }
        if (object != null) {
            this.prepareLink(iFvNetNode2, iFvNetNode, object.getLink());
        }
        try {
            if (iFvNetNode2.isFVActive() && object != null && object2 != null) {
                this.prepareNode(iFvNetNode2);
            }
        }
        catch (NullPointerException nullPointerException) {
            KDebug.printStackTrace((Throwable)nullPointerException);
        }
        list.remove(object);
        list.remove(object2);
        return iFvNetNode2;
    }

    @Override
    public void prepareNodeData(IFvNetNode iFvNetNode) {
        if (!iFvNetNode.isFVActive()) {
            this.prepareNode(iFvNetNode);
        } else {
            try {
                IFvNodeModel iFvNodeModel = iFvNetNode.getFvDelegate();
                ArrayList arrayList = (ArrayList)iFvNodeModel.getSelectedCircuitCells().clone();
                if (arrayList == null) {
                    return;
                }
                int n = arrayList.size();
                block2: for (int i = 0; i < n; ++i) {
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        HashMap hashMap = (HashMap)object.next();
                        if (hashMap == null || !((String)hashMap.get(IDX)).equals(String.valueOf(i))) continue;
                        this.addData(iFvNetNode, 0, (String)hashMap.get(NAME), (String)hashMap.get(PIN), (String)hashMap.get(POUT));
                        object.remove();
                        continue block2;
                    }
                }
                for (Object object : arrayList) {
                    if (object == null) continue;
                    this.addData(iFvNetNode, 0, (String)((HashMap)object).get(NAME), (String)((HashMap)object).get(PIN), (String)((HashMap)object).get(POUT));
                }
            }
            catch (InvalidNodeId invalidNodeId) {
                invalidNodeId.printStackTrace();
            }
        }
    }
}

