/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.grapher.circuit;

import cerent.cms.fv.IFVSelectedPowerModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvOpticsChannelModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvViewCircuitPath;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IOpticsChannelModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import com.cisco.fv.FunctObserverArgument;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.circuit.FunctionalNetworkCircuitHelper;
import com.cisco.fv.circuit.model.FvSelectedCircuitModel;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import com.cisco.fv.grapher.circuit.FvNodePinTask;
import com.cisco.fv.power.FvNodePwrBalloonTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FvNodeCircuitPath
implements Runnable {
    private IFvNetNode node;
    private FvNetworkMap netMap;
    private boolean nodeInCircuit;
    private FvNetworkCircuitPath fvNetworkCircuitPath;
    private ViewManagerToolKit tk;
    private ViewGrapher nodeFv;

    public FvNodeCircuitPath(FvNetworkCircuitPath fvNetworkCircuitPath, IFvNetNode iFvNetNode, FvNetworkMap fvNetworkMap, boolean bl) {
        this.fvNetworkCircuitPath = fvNetworkCircuitPath;
        fvNetworkCircuitPath.nodeThreadStart();
        if (FvNetworkCircuitPath.sd.on()) {
            FvNetworkCircuitPath.sd.println("[" + fvNetworkCircuitPath.getRunningNodeThread() + "]Node " + iFvNetNode.getName() + " Added ");
        }
        this.node = iFvNetNode;
        this.netMap = fvNetworkMap;
        this.nodeInCircuit = bl;
        this.tk = fvNetworkMap.getTk(iFvNetNode);
        this.nodeFv = this.tk.getGraph();
    }

    @Override
    public void run() {
        if (this.nodeInCircuit) {
            if (this.nodeFv != null) {
                ViewManager viewManager = this.nodeFv.getViewManager();
                if (!this.fvNetworkCircuitPath.addNewOpenNode(viewManager)) {
                    if (FvNetworkCircuitPath.sd.on()) {
                        FvNetworkCircuitPath.sd.println("\t" + viewManager.getNode().getName() + " already present in the list");
                    }
                    return;
                }
            } else {
                return;
            }
            this.paintInCircuit();
        } else {
            this.makeBalloonVisible(false);
            this.fvNetworkCircuitPath.paintFinished(true);
        }
    }

    private void paintInCircuit() {
        this.makeBalloonVisible(false);
        if (FvNetworkCircuitPath.sd.on()) {
            FvNetworkCircuitPath.sd.println("\t Start patchcords for node  " + this.node.getName() + "after " + (System.currentTimeMillis() - FvNetworkCircuitPath.circuitDbgtime) + "mSec.");
        }
        IFvViewCircuitPath iFvViewCircuitPath = this.prepareUsedPatchCords();
        this.addSrcAndDstPowerBalloon();
        if (iFvViewCircuitPath != null) {
            iFvViewCircuitPath.paint();
        }
        this.addSrcAndDstPin();
        if (FvNetworkCircuitPath.sd.on()) {
            FvNetworkCircuitPath.sd.println("\t\t End patchcords for node  " + this.node.getName() + "after " + (System.currentTimeMillis() - FvNetworkCircuitPath.circuitDbgtime) + "mSec.");
        }
        this.makeBalloonVisible(true);
        FunctObserverArgument functObserverArgument = new FunctObserverArgument(this.node, 0);
        this.fvNetworkCircuitPath.setChanged();
        this.fvNetworkCircuitPath.notifyObservers(functObserverArgument);
        this.fvNetworkCircuitPath.paintFinished(true);
    }

    private IFvViewCircuitPath prepareUsedPatchCords() {
        List list;
        IFvInterfaceModel iFvInterfaceModel = null;
        INodeOpticsTopologyModel iNodeOpticsTopologyModel = null;
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>();
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        INetElement iNetElement = netCircuitManager.getNetwork().getNetElem(this.node.getNodeId());
        LinkedList<IFvEntityModel> linkedList = ((FvSelectedCircuitModel)this.fvNetworkCircuitPath.getSelectedCircuit()).getPathInForNode(iNetElement);
        IFvViewCircuitPath iFvViewCircuitPath = null;
        boolean bl = this.fvNetworkCircuitPath.isInActivePath(iNetElement, this.fvNetworkCircuitPath.getSelectedCircuit().getCircuitLink(), this.fvNetworkCircuitPath.getSelectedCircuit().getCircuitSpans());
        if (linkedList == null) {
            return null;
        }
        if (linkedList.size() > 0) {
            for (int i = 0; i < linkedList.size(); ++i) {
                list = (IEntityModel)linkedList.get(i);
                if (hashMap.containsKey(list.getIndex())) continue;
                hashMap.put(list.getIndex(), list);
            }
        }
        IFVSelectedPowerModel iFVSelectedPowerModel = this.fvNetworkCircuitPath.getSelectedCircuit();
        list = ((INetCircuit)iFVSelectedPowerModel.getCircuitModel()).getCircuitNodes();
        Object[] objectArray = new IOchncPathDefModel[]{};
        for (Object object : list) {
            IConnectionModel iConnectionModel;
            if (!(object instanceof INetCircuitNode) || !((iConnectionModel = ((INetCircuitNode)object).getConn()) instanceof IOchncConnectionModel) || iConnectionModel.getNodeModel().getNodeId() != this.node.getNodeId()) continue;
            objectArray = ((IOchncConnectionModel)iConnectionModel).getPaths();
        }
        Integer n = iFVSelectedPowerModel.getCircuitType();
        for (IConnectionModel iConnectionModel : hashMap.values()) {
            if (!(iConnectionModel instanceof IPortModel)) continue;
            IPortModel iPortModel = (IPortModel)iConnectionModel;
            IFvInterfaceModel[] iFvInterfaceModelArray = null;
            iFvInterfaceModel = (IFvInterfaceModel)iPortModel.getInterfaceModel();
            if (!(iFvInterfaceModel instanceof IFvDwdmTrkLineModel) && !(iFvInterfaceModel instanceof IFvOpticsChannelModel)) {
                if (!(iFvInterfaceModel instanceof IFvOpticsLineModel)) continue;
                IFvInterfaceModel iFvInterfaceModel2 = (IFvInterfaceModel)iPortModel.getInterfaceModel();
                iFvInterfaceModelArray = iFvInterfaceModel2.getTheHigherLayerModels();
                for (int i = 0; i < iFvInterfaceModelArray.length; ++i) {
                    try {
                        if (((IOpticsChannelModel)iFvInterfaceModelArray[i]).getActualWaveLength() != this.fvNetworkCircuitPath.getSelectedCircuit().getLambda()) continue;
                        iFvInterfaceModel = iFvInterfaceModelArray[i];
                        continue;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        wrongInterfaceType.printStackTrace();
                        continue;
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        noSuchInterface.printStackTrace();
                    }
                }
            }
            iNodeOpticsTopologyModel = iNetElement.getNodeModel().getINodeOpticsTopologyModel();
            if (this.netMap == null) continue;
            ViewManager viewManager = this.nodeFv.getViewManager();
            iFvViewCircuitPath = viewManager.getFunctionalCircuitPath();
            iFvViewCircuitPath.addCircuitPath(iNodeOpticsTopologyModel.getAllOchListFromPort(iFvInterfaceModel.getIndex()), n, ((FvSelectedCircuitModel)this.fvNetworkCircuitPath.getSelectedCircuit()).getLambdaForNode(iNetElement), bl, objectArray);
        }
        return iFvViewCircuitPath;
    }

    private void addSrcAndDstPin() {
        String string = "addSrcAndDstPin " + this.node.getName();
        new Thread((Runnable)new FvNodePinTask(this.tk, this.fvNetworkCircuitPath), string).start();
    }

    private void addSrcAndDstPowerBalloon() {
        INetCircuit iNetCircuit = (INetCircuit)this.fvNetworkCircuitPath.getSelectedCircuit().getCircuitModel();
        List list = iNetCircuit.getSources();
        List list2 = iNetCircuit.getDrops();
        int n = 174;
        List<Integer> list3 = FunctionalNetworkCircuitHelper.getSourceKeys(iNetCircuit, this.tk);
        for (Integer object2 : list3) {
            this.tk.attachSourceDestinationBalloon(object2.intValue(), true, iNetCircuit.isBidirectional());
        }
        List list4 = FunctionalNetworkCircuitHelper.getDestinationKeys(iNetCircuit, this.tk);
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            this.tk.attachSourceDestinationBalloon(n2.intValue(), false, iNetCircuit.isBidirectional());
        }
    }

    private void makeBalloonVisible(boolean bl) {
        boolean bl2 = FunctViewManagerDelegate.getInstance().isPowerVisible();
        if (!bl) {
            if (bl2) {
                this.tk.setBalloonsPowerAndVisibility(false, bl);
                this.tk.showFunctViewPowerBallons();
            }
        } else if (bl2) {
            FvNodePwrBalloonTask fvNodePwrBalloonTask = new FvNodePwrBalloonTask(this.tk, true, this.netMap);
            fvNodePwrBalloonTask.setCircuitSelected(bl);
            String string = "FvNodeCircuitPath " + this.node.getName();
            new Thread((Runnable)fvNodePwrBalloonTask, string).start();
        }
    }
}

