/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.fv.gui;

import cerent.cms.fv.IFvEditDialog;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.network.MapPersist;
import cerent.util.DebugManager;
import cerent.util.IFvDebug;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFrame;
import cerent.util.view.fv.IFunctDialog;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctDialog;
import cerent.util.view.fv.helper.FunctException;
import com.cisco.fv.FunctViewManagerDelegate;
import com.cisco.fv.FvKeyStrokeAction;
import com.cisco.fv.circuit.model.FvCircuitModels;
import com.cisco.fv.grapher.FvNetMapFactory;
import com.cisco.fv.grapher.FvNetworkMap;
import com.cisco.fv.grapher.circuit.FvNetworkCircuitPath;
import com.cisco.fv.gui.NfvMenuToolBar;
import com.cisco.fv.gui.dockFrame.FunctDockableFrame;
import com.cisco.fv.gui.dockFrame.OverViewDockableFrame;
import com.cisco.fv.gui.dockFrame.SelectedCircuitDockableFrame;
import com.cisco.fv.power.SpanLossBalloon;
import com.cisco.newSwing.framework.CTCDockableFramework;
import com.cisco.newSwing.framework.ICTCDockContext;
import com.cisco.newSwing.framework.ICTCDockableFrame;
import com.cisco.newSwing.framework.ICTCDockingManager;
import com.cisco.newSwing.framework.helper.CTCDockableFrameHelper;
import com.jidesoft.utils.Lm;
import ilog.views.swing.IlvJScrollManagerView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class FunctionalNetworkDialog
extends CTCDockableFramework
implements IFvEditDialog,
WindowListener {
    private static final String FUNCTIONAL_VIEW_ICON = "/images/icons/CTC_icon.gif";
    private static final String DEBUG_INFORMATION_TITLE = "Debug Information ";
    private static FunctionalNetworkDialog _instance;
    JPanel parent;
    private JSplitPane graphAndSplitPane;
    private JComponent graph;
    private FvNetworkMap nm;
    private NfvMenuToolBar menuAndToolBar;
    private static AbstractViewController _avc;
    private ArrayList<JTable> allExportableTable;
    private String exportableTitle = "Debug Information ";
    private FunctViewManagerDelegate viewManager;
    private FunctDockableFrame generalFrame;
    private static IUiToolkit _uiToolkit;

    public IUiToolkit getUiToolkit() {
        return _uiToolkit;
    }

    public FunctionalNetworkDialog(IUiToolkit iUiToolkit, AbstractViewController abstractViewController) {
        super((KDebug)new SDebug("FunctionalNetworkDialog"), "DWDM Network Functional View");
        this.generalFrame.addExportableTable(this);
    }

    public static FunctionalNetworkDialog getInstance() {
        if (_instance != null) {
            return _instance;
        }
        return null;
    }

    public void fitGraphView() {
        if (this.graph != null) {
            ((FvNetworkMap)((IlvJScrollManagerView)this.graph).getView()).fitView();
        }
    }

    public void updateGraph(Component component) {
        this.graphAndSplitPane.setRightComponent(component);
        this.graphAndSplitPane.updateUI();
    }

    public static FunctionalNetworkDialog instance(IUiToolkit iUiToolkit, AbstractViewController abstractViewController) {
        if (_instance == null) {
            Lm.verifyLicense((String)"Cisco Photonics Italy", (String)"CTC (Cisco Transport Controller)", (String)"QUxKRJiL0aPX5G3fKTVB:0i5XPF7bvZ2");
            FunctDebug.instance().init((IFvDebug)DebugManager.instance().getRoot());
            FunctDialog.init((IFunctDialog)new CerentDialog());
            _avc = abstractViewController;
            _uiToolkit = iUiToolkit;
            _instance = new FunctionalNetworkDialog(iUiToolkit, abstractViewController);
        }
        return _instance;
    }

    public static FunctionalNetworkDialog instance() {
        return _instance;
    }

    private void initFV() {
        try {
            this.nm = new FvNetworkMap((IFvDebug)this.db, 2, FvNetMapFactory.instance(), Network.instance(), VirtualLinksDirector.instance(), new MapPersist());
            this.graph = this.nm.getGraphWindow();
            this.viewManager = FunctViewManagerDelegate.getInstance();
            this.viewManager.addNetworkMap(this.nm);
        }
        catch (RuntimeException runtimeException) {
            SDebug.printStackTrace((Throwable)runtimeException);
            runtimeException.printStackTrace();
        }
    }

    public JButton addToolbar(ActionListener actionListener, String string, String string2, Object object) {
        return null;
    }

    public Container getToolBar() {
        return null;
    }

    public void syncButton(String string, boolean bl) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public AbstractViewController getViewController() {
        return _avc;
    }

    public void dispose() {
        FvCircuitModels.getInstance().dispose();
        FvNetworkCircuitPath.getInstance().dispose();
        FunctViewManagerDelegate.getInstance().dispose();
        this.nm.dispose();
        this.nm = null;
        if (this.menuAndToolBar != null) {
            this.menuAndToolBar.destroy();
            this.menuAndToolBar = null;
        }
        this.graphAndSplitPane = null;
        this.parent = null;
        this.graph = null;
        this.allExportableTable = null;
        this.viewManager = null;
        _uiToolkit = null;
        this.disposeAllSingleton();
        super.dispose();
        _instance = null;
    }

    public JTable[] getExportableTables() {
        return this.allExportableTable.toArray(new JTable[0]);
    }

    public void addTableToExport(JTable jTable) {
        if (!this.allExportableTable.contains(jTable)) {
            this.allExportableTable.add(jTable);
        }
    }

    public void removeTableToExport(JTable jTable) {
        this.allExportableTable.remove(jTable);
    }

    public void removeTableToExport(JTable[] jTableArray) {
        for (int i = 0; i < jTableArray.length; ++i) {
            JTable jTable = jTableArray[i];
            this.removeTableToExport(jTable);
        }
        this.setExportableTitle(DEBUG_INFORMATION_TITLE);
    }

    public void addTableToExport(JTable[] jTableArray) {
        for (int i = 0; i < jTableArray.length; ++i) {
            JTable jTable = jTableArray[i];
            this.addTableToExport(jTable);
        }
    }

    public String getExportableTitle() {
        return this.exportableTitle;
    }

    public void setExportableTitle(String string) {
        this.exportableTitle = string;
    }

    private void setKeyStroke() {
        FvKeyStrokeAction.getInstance().setKeyStroke(this.graph);
    }

    public boolean isPortPowerVisible() {
        return this.viewManager.isPowerVisible();
    }

    private void disposeAllSingleton() {
        FvKeyStrokeAction.getInstance().dispose();
        FvNetMapFactory.instance().dispose();
        FunctDebug.instance().disposeInstance();
        SpanLossBalloon.getInstance().dispose();
    }

    public void resetFrameToDefault() {
        this.getDockingManager().resetFrameToDefaultPosition();
        SelectedCircuitDockableFrame selectedCircuitDockableFrame = (SelectedCircuitDockableFrame)this.getDockingManager().getFrame("Circuit: ");
        selectedCircuitDockableFrame.resetFrameVisibility();
    }

    protected void createDockableFrames() {
        this.initFV();
        this.generalFrame = new FunctDockableFrame("Network Data", _uiToolkit);
        CTCDockableFrameHelper.addFrameDocked((ICTCDockableFrame)this.generalFrame, (ICTCDockingManager)this.getDockingManager(), (ICTCDockContext.IDockContextPos)ICTCDockContext.IDockContextPos.DOCK_SIDE_WEST, (int)1);
        CTCDockableFrameHelper.addFrameDocked((ICTCDockableFrame)new OverViewDockableFrame("OverView", this.nm), (ICTCDockingManager)this.getDockingManager(), (ICTCDockContext.IDockContextPos)ICTCDockContext.IDockContextPos.DOCK_SIDE_WEST, (int)1);
        SelectedCircuitDockableFrame selectedCircuitDockableFrame = new SelectedCircuitDockableFrame("Circuit: ");
        CTCDockableFrameHelper.addFrameDocked((ICTCDockableFrame)selectedCircuitDockableFrame, (ICTCDockingManager)this.getDockingManager(), (ICTCDockContext.IDockContextPos)ICTCDockContext.IDockContextPos.DOCK_SIDE_EAST, (int)1);
        this.getDockingManager().setFrameVisible((ICTCDockableFrame)selectedCircuitDockableFrame, false);
        this.getDockingManager().addMainFrame((Component)this.graph, "Center");
        try {
            this.menuAndToolBar = new NfvMenuToolBar(this, this.getFrame().getContentPane(), this.graph);
            this.viewManager.addToolBar(this.menuAndToolBar);
        }
        catch (FunctException functException) {
            SDebug.printStackTrace((Throwable)functException);
        }
        this.setKeyStroke();
        this.getFrame().setSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    protected void init() {
        this.allExportableTable = new ArrayList();
        URL uRL = UFrame.class.getResource(FUNCTIONAL_VIEW_ICON);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        this.getFrame().setIconImage(image);
    }
}

