/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.GridBagPanel;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.Preferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginDialog
extends JDialog
implements DocumentListener,
KeyListener,
ActionListener {
    private Log mLog = LogFactory.getLog(LoginDialog.class);
    private static final int MAX_FIELD_LENGTH = 20;
    private static final String LOGIN_VIGNETTE = "/images/app_dialogVignette.gif";
    private static final String LOGIN_TITLE = "/images/app_title.gif";
    private static final String DIALOG_TITLE = "CWI";
    private static final String PREFS_PATH = "cwi.recent";
    private static final String PREFS_NE_KEY = "nodes";
    private static final String PREFS_USER = "user";
    private String mNEName = null;
    private String mUserName = null;
    private boolean isLogin = false;
    private Vector mNodeVector = null;
    private JPasswordField mPasswordField = null;
    private JTextField mUserNameField = null;
    private JComboBox mNENameField = null;
    private JButton mLoginButton = null;
    private JButton mClearButton = null;
    private Component mComponent = null;
    private JCheckBox mUseHTTPS = null;
    private JLabel mImageLabel = null;
    private JLabel mTitleLabel = null;

    public LoginDialog(Frame frame, String neName, String userName) {
        super(frame, DIALOG_TITLE, true);
        this.mNEName = neName;
        this.mUserName = userName;
        this.initialize();
        this.mNENameField.setEditable(true);
        if (userName != null) {
            this.mUserNameField.setText(userName);
        } else {
            this.mUserNameField.setText(Preferences.getPreferenceInstance(InstallerUtil.getCWIPreferenceFileName()).getProperty(PREFS_PATH, PREFS_USER, null));
        }
        this.mNodeVector = this.getNEsFromPrefs(neName);
        for (int i = 0; i < this.mNodeVector.size(); ++i) {
            this.mNENameField.addItem(this.mNodeVector.get(i));
        }
        if (neName != null) {
            this.mNENameField.setSelectedItem(neName);
        } else if (this.mNodeVector.size() > 0) {
            this.mNENameField.setSelectedItem(this.mNodeVector.firstElement());
        }
        this.toFront();
        this.requestFocus();
    }

    private void initialize() {
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBackground(Color.white);
        cp.add(this.createLoginPanel(this.mNEName), "Center");
    }

    private Component createLoginPanel(String neName) {
        int y = 0;
        GridBagPanel p = new GridBagPanel();
        this.mNENameField = new JComboBox();
        this.mNENameField.addKeyListener(this);
        this.mComponent = this.mNENameField.getEditor().getEditorComponent();
        this.mComponent.addKeyListener(this);
        this.mUseHTTPS = new JCheckBox("Use HTTPS Connection");
        this.mUseHTTPS.setBackground(Color.white);
        this.mUseHTTPS.setSelected(false);
        this.mUserNameField = new JTextField(20);
        this.mUserNameField.setText("");
        this.mUserNameField.addKeyListener(this);
        this.mPasswordField = new JPasswordField(20);
        this.mPasswordField.addKeyListener(this);
        this.mPasswordField.setRequestFocusEnabled(true);
        this.mPasswordField.requestFocus();
        this.mLoginButton = new JButton(" Connect ");
        this.mLoginButton.addActionListener(this);
        this.mLoginButton.addKeyListener(this);
        this.mClearButton = new JButton(" Clear ");
        this.mClearButton.addActionListener(this);
        p.inset(4, 2);
        p.fillHorizontal();
        p.anchorWest();
        JLabel jl = new JLabel("User Name");
        p.add((Component)jl, 0, y);
        p.anchorEast();
        p.add(this.mUserNameField, 1, y, 2, 1);
        p.anchorWest();
        jl = new JLabel("Password");
        p.add((Component)jl, 0, ++y);
        p.anchorEast();
        p.add(this.mPasswordField, 1, y, 2, 1);
        p.anchorWest();
        jl = new JLabel("Node Name");
        p.add((Component)jl, 0, ++y);
        p.anchorEast();
        p.add(this.mNENameField, 1, y, 2, 1);
        p.anchorEast();
        p.add(this.mUseHTTPS, 1, ++y, 2, 1);
        p.add((Component)new JLabel(), 0, y);
        p.add((Component)new JLabel(), 1, y);
        p.add((Component)new JLabel(), 2, y++);
        p.fillNone();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0, 3, 3));
        buttonPanel.add(this.mLoginButton);
        buttonPanel.add(this.mClearButton);
        buttonPanel.setBackground(Color.white);
        p.anchorEast();
        p.add((Component)buttonPanel, 2, y);
        this.mUserNameField.requestFocus();
        this.setBackground(Color.white);
        p.setBackground(Color.white);
        return p;
    }

    public String getUserName() {
        return this.mUserNameField.getText().trim();
    }

    public String getPassword() {
        return new String(this.mPasswordField.getPassword());
    }

    public String getNodeName() {
        if ((String)this.mNENameField.getSelectedItem() != null) {
            return ((String)this.mNENameField.getSelectedItem()).trim();
        }
        return "";
    }

    public boolean isHTTPSConnection() {
        return this.mUseHTTPS.isSelected();
    }

    public void clear() {
        this.mUserNameField.setText("");
        this.mPasswordField.setText("");
    }

    public boolean isLogin() {
        return this.isLogin;
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.isLogin = false;
        }
        super.setVisible(isVisible);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.isVisible()) {
            Object source = ae.getSource();
            if (source == this.mLoginButton) {
                String userName = this.mUserNameField.getText();
                String password = this.mPasswordField.getText();
                this.isLogin = true;
                this.setVisible(false);
            } else if (source == this.mClearButton) {
                this.clear();
            }
        }
    }

    public void keyPressed(KeyEvent ke) {
        Object source;
        if (this.isVisible() && ((source = ke.getSource()) == this.mPasswordField || source == this.mNENameField || source == this.mLoginButton || source == this.mComponent || source == this.mUserNameField) && ke.getKeyCode() == 10 && this.mLoginButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.mLoginButton, 0, "Enter"));
        }
    }

    public void keyTyped(KeyEvent ke) {
        Object source;
        if (this.isVisible() && (source = ke.getSource()) == this.mNENameField) {
            this.mLoginButton.setEnabled(this.getNodeName().length() != 0);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.mLoginButton.setEnabled(this.getNodeName().length() != 0);
    }

    public void removeUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.insertUpdate(e);
    }

    public void displayAtCenter() {
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension appSize = this.getSize();
        int x = (screenSize.width - appSize.width) / 2;
        int y = (screenSize.height - appSize.height) / 2;
        this.setLocation(x, y);
        this.setSize(330, 185);
    }

    public void selectNetworkElement(String neName) {
        this.mNENameField.setSelectedItem(neName);
    }

    public void show() {
        this.isLogin = false;
        this.displayAtCenter();
        super.show();
    }

    private Vector getNEsFromPrefs(String newNE) {
        Vector<String> neList = new Vector<String>();
        if (newNE == null) {
            newNE = "";
        }
        String recentNodes = null;
        recentNodes = Preferences.getPreferenceInstance(InstallerUtil.getCWIPreferenceFileName()).getProperty(PREFS_PATH, PREFS_NE_KEY, null);
        if (recentNodes == null) {
            recentNodes = newNE;
        } else if (recentNodes.toLowerCase().indexOf(newNE.toLowerCase() + ",") == -1) {
            recentNodes = recentNodes + "," + newNE;
        }
        StringTokenizer tokenizer = new StringTokenizer(recentNodes, ",");
        while (tokenizer.hasMoreTokens()) {
            neList.add(tokenizer.nextToken());
        }
        return neList;
    }

    public void saveLoginPreferences() {
        try {
            Preferences prefs = Preferences.getPreferenceInstance(InstallerUtil.getCWIPreferenceFileName());
            if (this.getUserName() != null) {
                prefs.setProperty(PREFS_PATH, PREFS_USER, this.getUserName());
            }
            String loginNEName = this.getNodeName();
            StringBuffer buffer = new StringBuffer();
            buffer.append(loginNEName).append(",");
            for (int i = 0; i < this.mNodeVector.size(); ++i) {
                String temp = (String)this.mNodeVector.get(i);
                if (temp.equalsIgnoreCase(loginNEName)) continue;
                buffer.append(temp).append(",");
            }
            prefs.setProperty(PREFS_PATH, PREFS_NE_KEY, buffer.toString());
            prefs.store();
        }
        catch (IOException ex) {
            this.mLog.warn("Exception occurred while storing login preferences", ex);
        }
    }
}

