/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Preferences {
    private Log mLog = LogFactory.getLog(Preferences.class);
    private static final char pathDelim = '.';
    private static final char arrayDelim = '\n';
    private static final String CWIPreferencesPrefix = "cwi";
    private static final String preferencesFileHeader = "Preferences File";
    private static final String version = "1.0";
    private static final String title = "CWI";
    private static final String versionKey = "version";
    private static final String includeKey = "include";
    private static final String titleKey = "title";
    private String fileName = null;
    private long fileLastModified = 0L;
    private Properties prefs = null;
    private SortableProperties originalPrefs = null;
    private boolean isOriginalPrefFile = false;
    private HashSet includeFileSet = null;
    private static HashMap preferencesMap = new HashMap();
    private Vector listeners;

    private Preferences(String filename) {
        this.fileName = filename;
        this.prefs = new Properties();
        this.init();
    }

    public static synchronized Preferences getPreferenceInstance(String filename) {
        Preferences pref = (Preferences)preferencesMap.get(filename);
        if (pref == null) {
            pref = new Preferences(filename);
            preferencesMap.put(filename, pref);
        }
        return pref;
    }

    public void init() {
        File f = new File(this.fileName);
        this.fileLastModified = f.lastModified();
        this.prefs = new Properties();
        this.originalPrefs = new SortableProperties();
        this.isOriginalPrefFile = true;
        this.includeFileSet = new HashSet();
        this.init(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String fileName) {
        String includeFileName;
        FileInputStream in = null;
        Object oldIn = null;
        BufferedInputStream bufin = null;
        Properties tempPrefs = new Properties();
        if (!new File(fileName).exists()) return;
        in = new FileInputStream(fileName);
        bufin = new BufferedInputStream(in);
        tempPrefs.load(bufin);
        if (this.isOriginalPrefFile) {
            this.originalPrefs.putAll((Map<?, ?>)tempPrefs);
            this.isOriginalPrefFile = false;
        }
        this.includeFileSet.add(fileName);
        if (tempPrefs.containsKey("cwi.include") && !this.includeFileSet.contains(includeFileName = tempPrefs.getProperty("cwi.include"))) {
            this.init(includeFileName);
        }
        this.prefs.putAll((Map<?, ?>)tempPrefs);
        Object var9_8 = null;
        if (bufin == null) return;
        try {
            bufin.close();
            in.close();
            return;
        }
        catch (IOException ex) {
            this.mLog.warn("IOException occurred while closing " + fileName, ex);
        }
        return;
        {
            catch (IOException e) {
                this.mLog.warn("IOException occurred while loading preferences file " + fileName, e);
                try {
                    this.store();
                }
                catch (IOException ex) {
                    this.mLog.warn("IOException occurred while storing preferences file " + fileName, ex);
                }
                Object var9_9 = null;
                if (bufin == null) return;
                try {
                    bufin.close();
                    in.close();
                    return;
                }
                catch (IOException ex) {
                    this.mLog.warn("IOException occurred while closing " + fileName, ex);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (bufin == null) throw throwable;
            try {
                bufin.close();
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                this.mLog.warn("IOException occurred while closing " + fileName, ex);
            }
            throw throwable;
        }
    }

    private void checkForFileChange() {
        if (new File(this.fileName).lastModified() != this.fileLastModified) {
            this.init();
        }
    }

    public static String getFullName(String path, String key) {
        return path + '.' + key;
    }

    public boolean propertyExist(String path, String key) {
        return this.prefs.getProperty(Preferences.getFullName(path, key)) == null;
    }

    private String getProperty(String key, String defaultValue) {
        String value = this.prefs.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getProperty(String path, String key, String defaultValue) {
        this.checkForFileChange();
        return this.getProperty(Preferences.getFullName(path, key), defaultValue);
    }

    public boolean getBoolean(String path, String key, boolean defaultValue) {
        String booleanStr = this.getProperty(path, key, null);
        if (booleanStr != null) {
            return new Boolean(booleanStr);
        }
        return defaultValue;
    }

    public int getInt(String path, String key, int defaultValue) {
        String intStr = this.getProperty(path, key, null);
        if (intStr != null) {
            try {
                return Integer.parseInt(intStr);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String[] getPropertyArray(String path, String key, String[] defaultValue) throws IOException {
        this.checkForFileChange();
        String propString = this.prefs.getProperty(Preferences.getFullName(path, key));
        ArrayList<String> list = new ArrayList<String>();
        if (propString == null) {
            return defaultValue;
        }
        int len = propString.length();
        int start = 0;
        while (true) {
            int delimIndex;
            int valueLen;
            if ((valueLen = (delimIndex = propString.indexOf(10, start)) != -1 ? delimIndex - start : len - start) > 0) {
                list.add(propString.substring(start, start + valueLen));
            }
            if (delimIndex == -1) break;
            start = delimIndex + 1;
        }
        return list.toArray(new String[0]);
    }

    private void setProperty(String key, String value) {
        this.prefs.setProperty(key, value);
        this.originalPrefs.setProperty(key, value);
    }

    public void setProperty(String path, String key, String value) {
        this.checkForFileChange();
        this.setProperty(Preferences.getFullName(path, key), value);
    }

    public void setBoolean(String path, String key, boolean value) {
        this.setProperty(path, key, new Boolean(value).toString());
    }

    public void setInt(String path, String key, int value) {
        this.setProperty(path, key, Integer.toString(value));
    }

    public void setPropertyArray(String path, String key, String[] value) {
        String propString = "";
        for (int i = 0; i < value.length; ++i) {
            propString = i == 0 ? value[i] : propString + '\n' + value[i];
        }
        this.setProperty(path, key, propString);
    }

    public void removeAllProperties(String path, String key) {
        LinkedList<String> list = new LinkedList<String>();
        String prefix = Preferences.getFullName(path, key);
        for (String string : this.prefs.keySet()) {
            if (!string.startsWith(prefix)) continue;
            list.add(string);
        }
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            this.removeProperty((String)it.next());
        }
    }

    private void removeProperty(String key) {
        this.prefs.remove(key);
        this.originalPrefs.remove(key);
    }

    public void removeProperty(String path, String key) {
        this.checkForFileChange();
        this.removeProperty(Preferences.getFullName(path, key));
    }

    public Enumeration propertyNames() {
        return this.prefs.propertyNames();
    }

    public void list(PrintStream out) {
        this.prefs.list(out);
    }

    public void list(PrintWriter out) {
        this.prefs.list(out);
    }

    public void store(OutputStream out, String header) throws IOException {
        this.originalPrefs.setSortedKeys(true);
        this.originalPrefs.store(out, header);
        this.originalPrefs.setSortedKeys(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store(String outputFileName, String header) throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(outputFileName);
                this.store(out, header);
                out.flush();
            }
            catch (FileNotFoundException e) {
                this.mLog.warn("FileNotFoundException occurred while storing preferences  in " + outputFileName + " with header: " + header, e);
                throw e;
            }
            catch (IOException e) {
                this.mLog.warn("FileNotFoundException occurred while storing preferences  in " + outputFileName + " with header: " + header, e);
                throw e;
            }
            Object var6_4 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void store() throws FileNotFoundException, IOException {
        this.store(this.fileName, preferencesFileHeader);
    }

    public void finalize() throws Throwable {
        this.store();
        this.listeners.clear();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String propertyName) {
        Vector targets;
        Preferences preferences = this;
        synchronized (preferences) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }

    private class SortableProperties
    extends Properties {
        private boolean sortedKeys = false;

        SortableProperties() {
        }

        public synchronized Enumeration keys() {
            if (this.sortedKeys) {
                Enumeration<Object> nonSortedKeys = super.keys();
                TreeSet<Object> sortedKeys = new TreeSet<Object>();
                while (nonSortedKeys.hasMoreElements()) {
                    sortedKeys.add(nonSortedKeys.nextElement());
                }
                Vector v = new Vector(sortedKeys);
                return v.elements();
            }
            return super.keys();
        }

        void setSortedKeys(boolean sorted) {
            this.sortedKeys = sorted;
        }
    }
}

