/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.mgbl.security;

import com.cisco.hfr.mgbl.security.SSLInitializer;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.ORBSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import javax.net.ssl.SSLSocketFactory;

public class SSLORBSocketFactory
implements ORBSocketFactory {
    private static final String IIOP_SSL = "SSL";
    private static HashSet mSSLEnabledHosts = new HashSet();
    private static SSLSocketFactory mSSLSocketFactory = null;
    private static String mImposedHostName = null;
    private static HashMap mHostsMap = new HashMap();
    private static HashSet mImposedHosts = new HashSet();
    private ORB mORB;

    public SSLORBSocketFactory() {
        if (mSSLSocketFactory == null) {
            try {
                mSSLSocketFactory = SSLInitializer.instance().getSocketFactory();
            }
            catch (Exception ex) {
                System.err.println("CWI: Error while initializing SSL libraries.");
            }
        }
    }

    public void setORB(ORB orb) {
        this.mORB = orb;
    }

    public static void setImposedHostName(String hostName) {
        if (hostName == null || !mImposedHosts.contains(hostName)) {
            mImposedHostName = hostName;
        }
    }

    public static final void registerForSSLORB(String hostName) {
        mSSLEnabledHosts.add(hostName.toLowerCase());
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        return new ServerSocket(inetSocketAddress.getPort());
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        Socket socket = null;
        String host = SSLORBSocketFactory.getUserSpecifiedHostName(inetSocketAddress.getHostName().toLowerCase());
        int port = inetSocketAddress.getPort();
        if (mSSLEnabledHosts.contains(host)) {
            if (port == 10001) {
                port = 10002;
            }
            socket = mSSLSocketFactory.createSocket(host, port);
        } else {
            socket = new Socket(host, port);
        }
        return socket;
    }

    private static String getUserSpecifiedHostName(String iorHost) {
        String host = iorHost;
        if (mImposedHostName != null) {
            host = mImposedHostName;
            mHostsMap.put(iorHost, mImposedHostName);
            mImposedHosts.add(mImposedHostName);
        } else {
            host = (String)mHostsMap.get(iorHost);
        }
        if (host != null) {
            return host;
        }
        return iorHost;
    }

    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) throws SocketException {
    }
}

