/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.common.hosts.AbstractHostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DialogHostKeyVerification
extends AbstractHostKeyVerification {
    Component parent;
    private boolean verificationEnabled = true;

    public DialogHostKeyVerification(Component parent) throws InvalidHostFileException {
        this.parent = parent;
    }

    public DialogHostKeyVerification(Component parent, String hostFileName) throws InvalidHostFileException {
        super(hostFileName);
        this.parent = parent;
    }

    public void setVerificationEnabled(boolean enabled) {
        this.verificationEnabled = this.verificationEnabled;
    }

    public void onDeniedHost(final String host) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(DialogHostKeyVerification.this.parent, "Access to '" + host + "' is denied.\n" + "Verify the access granted/denied in the allowed hosts file.", "Remote Host Authentication", 0);
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            throw new TransportProtocolException("Invocation Exception: " + ite.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onHostKeyMismatch(final String host, final String recordedFingerprint, final String actualFingerprint) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] options = DialogHostKeyVerification.this.getOptions();
                        int res = JOptionPane.showOptionDialog(DialogHostKeyVerification.this.parent, "The host '" + host + "' has provided a different host key.\nThe host key" + " fingerprint provided is '" + actualFingerprint + "'.\n" + "The allowed host key fingerprint is " + recordedFingerprint + ".\nDo you want to allow this host?", "Remote host authentication", 1, 3, null, options, options[0]);
                        try {
                            if (options.length == 3 && res == 0) {
                                DialogHostKeyVerification.this.allowHost(host, actualFingerprint, true);
                            } else if (options.length == 2 && res == 0 || options.length == 3 && res == 1) {
                                DialogHostKeyVerification.this.allowHost(host, actualFingerprint, false);
                            }
                        }
                        catch (InvalidHostFileException e) {
                            DialogHostKeyVerification.this.showExceptionMessage(e);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            throw new TransportProtocolException("Invocation Exception: " + ite.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onUnknownHost(final String host, final String fingerprint) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] options = DialogHostKeyVerification.this.getOptions();
                        int res = JOptionPane.showOptionDialog(DialogHostKeyVerification.this.parent, "The host '" + host + "' is unknown. The host key" + " fingerprint is\n'" + fingerprint + "'.\nDo you want to allow this host?", "Remote host authentication", 1, 3, null, options, options[0]);
                        try {
                            if (options.length == 3 && res == 0) {
                                DialogHostKeyVerification.this.allowHost(host, fingerprint, true);
                            } else if (options.length == 2 && res == 0 || options.length == 3 && res == 1) {
                                DialogHostKeyVerification.this.allowHost(host, fingerprint, false);
                            }
                        }
                        catch (InvalidHostFileException e) {
                            DialogHostKeyVerification.this.showExceptionMessage(e);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            throw new TransportProtocolException("Invocation Exception: " + ite.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    private String[] getOptions() {
        String[] stringArray;
        if (this.isHostFileWriteable()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Always";
            stringArray2[1] = "Yes";
            stringArray = stringArray2;
            stringArray2[2] = "No";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Yes";
            stringArray = stringArray3;
            stringArray3[1] = "No";
        }
        return stringArray;
    }

    private void showExceptionMessage(Exception e) {
        JOptionPane.showMessageDialog(this.parent, "An unexpected error occured!\n\n" + e.getMessage(), "Host Verification", 0);
    }
}

