/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.AboutAction;
import com.sshtools.common.ui.ExitAction;
import com.sshtools.common.ui.NewWindowAction;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsApplicationFrame
extends JFrame
implements SshToolsApplicationContainer {
    public static final String PREF_LAST_FRAME_GEOMETRY = "application.lastFrameGeometry";
    protected Log log = LogFactory.getLog(SshToolsApplicationFrame.class);
    protected StandardAction exitAction;
    protected StandardAction aboutAction;
    protected StandardAction newWindowAction;
    protected JSeparator toolSeparator;
    private SshToolsApplicationPanel panel;
    private SshToolsApplication application;
    private boolean showAboutBox = true;
    private boolean showExitAction = true;
    private boolean showNewWindowAction = true;
    private boolean showMenu = true;

    public void showAboutBox(boolean showAboutBox) {
        this.showAboutBox = showAboutBox;
    }

    public void showExitAction(boolean showExitAction) {
        this.showExitAction = showExitAction;
    }

    public void showNewWindowAction(boolean showNewWindowAction) {
        this.showNewWindowAction = showNewWindowAction;
    }

    public void init(final SshToolsApplication application, SshToolsApplicationPanel panel) throws SshToolsApplicationException {
        this.panel = panel;
        this.application = application;
        if (application != null) {
            this.setTitle(ConfigurationLoader.getVersionString(application.getApplicationName(), application.getApplicationVersion()));
        }
        this.setDefaultCloseOperation(0);
        panel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        if (this.showExitAction && application != null) {
            this.exitAction = new ExitAction(application, this);
            panel.registerAction(this.exitAction);
        }
        if (this.showNewWindowAction && application != null) {
            this.newWindowAction = new NewWindowAction(application);
            panel.registerAction(this.newWindowAction);
        }
        panel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 99));
        if (this.showAboutBox && application != null) {
            this.aboutAction = new AboutAction(this, application);
            panel.registerAction(this.aboutAction);
        }
        this.getApplicationPanel().rebuildActionComponents();
        JPanel p = new JPanel(new BorderLayout());
        if (panel.getJMenuBar() != null) {
            this.setJMenuBar(panel.getJMenuBar());
        }
        if (panel.getToolBar() != null) {
            JPanel t = new JPanel(new BorderLayout());
            t.add((Component)panel.getToolBar(), "North");
            this.toolSeparator = new JSeparator(0);
            t.add((Component)this.toolSeparator, "South");
            this.toolSeparator.setVisible(panel.getToolBar().isVisible());
            final SshToolsApplicationPanel pnl = panel;
            panel.getToolBar().addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent evt) {
                    SshToolsApplicationFrame.this.log.debug("Tool separator is now " + pnl.getToolBar().isVisible());
                    SshToolsApplicationFrame.this.toolSeparator.setVisible(pnl.getToolBar().isVisible());
                }
            });
            p.add((Component)t, "North");
        }
        p.add((Component)panel, "Center");
        if (panel.getStatusBar() != null) {
            p.add((Component)panel.getStatusBar(), "South");
        }
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(p);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                if (application != null) {
                    application.closeContainer(SshToolsApplicationFrame.this);
                } else {
                    int confirm = JOptionPane.showOptionDialog(SshToolsApplicationFrame.this, "Close " + SshToolsApplicationFrame.this.getTitle() + "?", "Close Operation", 0, 3, null, null, null);
                    if (confirm == 0) {
                        SshToolsApplicationFrame.this.hide();
                    }
                }
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        boolean found = false;
        if (application != null && application.getContainerCount() != 0) {
            for (int i = 0; i < application.getContainerCount() && !found; ++i) {
                SshToolsApplicationContainer c = application.getContainerAt(i);
                if (!(c instanceof SshToolsApplicationFrame)) continue;
                SshToolsApplicationFrame f = (SshToolsApplicationFrame)c;
                this.setSize(f.getSize());
                Point newLocation = new Point(f.getX(), f.getY());
                newLocation.x += 48;
                newLocation.y += 48;
                if ((double)newLocation.x > screenSize.getWidth() - 64.0) {
                    newLocation.x = 0;
                }
                if ((double)newLocation.y > screenSize.getHeight() - 64.0) {
                    newLocation.y = 0;
                }
                this.setLocation(newLocation);
                found = true;
            }
        }
        if (!found) {
            if (PreferencesStore.preferenceExists(PREF_LAST_FRAME_GEOMETRY)) {
                this.setBounds(PreferencesStore.getRectangle(PREF_LAST_FRAME_GEOMETRY, this.getBounds()));
            } else {
                this.pack();
                UIUtil.positionComponent(0, this);
            }
        }
    }

    public void setContainerTitle(String title) {
        this.setTitle(title);
    }

    public SshToolsApplication getApplication() {
        return this.application;
    }

    public void setContainerVisible(boolean visible) {
        this.setVisible(visible);
    }

    public boolean isContainerVisible() {
        return this.isVisible();
    }

    public SshToolsApplicationPanel getApplicationPanel() {
        return this.panel;
    }

    public void closeContainer() {
        if (this.application != null && this.application.getContainerCount() == 1) {
            PreferencesStore.putRectangle(PREF_LAST_FRAME_GEOMETRY, this.getBounds());
        }
        this.dispose();
        this.getApplicationPanel().deregisterAction(this.newWindowAction);
        this.getApplicationPanel().deregisterAction(this.exitAction);
        this.getApplicationPanel().deregisterAction(this.aboutAction);
        this.getApplicationPanel().rebuildActionComponents();
    }
}

