/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.KBIPasswordAuthenticationServer;
import com.sshtools.daemon.authentication.PasswordAuthenticationServer;
import com.sshtools.daemon.authentication.PublicKeyAuthenticationServer;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationServerFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";

    protected SshAuthenticationServerFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationServer newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationServer)((Class)auths.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshAuthenticationServerFactory.class);
        auths = new HashMap();
        log.info("Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationServer.class);
        auths.put(AUTH_PK, PublicKeyAuthenticationServer.class);
        auths.put(AUTH_KBI, KBIPasswordAuthenticationServer.class);
    }
}

