/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.scp;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.util.StringPattern;
import com.sshtools.daemon.util.StringUtil;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScpServer
extends NativeProcessProvider
implements Runnable {
    private static Log log = LogFactory.getLog(ScpServer.class);
    private static int BUFFER_SIZE = 16384;
    private InputStream in;
    private InputStream err;
    private OutputStream out;
    private String destination;
    private PipedOutputStream pipeIn;
    private PipedOutputStream pipeErr;
    private PipedInputStream pipeOut;
    private SshThread scpServerThread;
    private int verbosity = 0;
    private int exitCode;
    private boolean directory;
    private boolean recursive;
    private boolean from;
    private boolean to;
    private NativeFileSystemProvider nfs;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private String currentDirectory;
    private boolean preserveAttributes;

    public ScpServer() {
        this.nfs = NativeFileSystemProvider.getInstance();
    }

    public boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, String modes) {
        return false;
    }

    public boolean createProcess(String command, Map environment) throws IOException {
        log.info("Creating ScpServer");
        if (this.nfs == null) {
            throw new IOException("NativeFileSystem was not instantiated. Please check logs");
        }
        this.scp(command.substring(4));
        return true;
    }

    public String getDefaultTerminalProvider() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public InputStream getStderrInputStream() {
        return this.err;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public void kill() {
        log.info("Killing ScpServer");
        try {
            if (this.pipeIn != null) {
                this.pipeIn.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (this.pipeOut != null) {
                this.pipeOut.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (this.pipeErr != null) {
                this.pipeErr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        log.debug("Starting ScpServer thread");
        this.scpServerThread = SshThread.getCurrentThread().cloneThread(this, "ScpServer");
        this.scpServerThread.start();
    }

    public boolean stillActive() {
        return false;
    }

    public boolean supportsPseudoTerminal(String term) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExitCode() {
        try {
            ScpServer scpServer = this;
            synchronized (scpServer) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug("Returning exit code of " + this.exitCode);
        return this.exitCode;
    }

    private void scp(String args) throws IOException {
        log.debug("Parsing ScpServer options " + args);
        String[] a = StringUtil.current().allParts(args, " ");
        this.destination = null;
        this.directory = false;
        this.from = false;
        this.to = false;
        this.recursive = false;
        this.verbosity = 0;
        boolean remote = false;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].startsWith("-")) {
                String s = a[i].substring(1);
                block9: for (int j = 0; j < s.length(); ++j) {
                    char ch = s.charAt(j);
                    switch (ch) {
                        case 't': {
                            this.to = true;
                            continue block9;
                        }
                        case 'd': {
                            this.directory = true;
                            continue block9;
                        }
                        case 'f': {
                            this.from = true;
                            continue block9;
                        }
                        case 'r': {
                            this.recursive = true;
                            continue block9;
                        }
                        case 'v': {
                            ++this.verbosity;
                            continue block9;
                        }
                        case 'p': {
                            this.preserveAttributes = true;
                            continue block9;
                        }
                        default: {
                            log.warn("Unsupported argument, allowing to continue.");
                        }
                    }
                }
                continue;
            }
            if (this.destination == null) {
                this.destination = a[i];
                continue;
            }
            throw new IOException("More than one destination supplied " + a[i]);
        }
        if (!this.to && !this.from) {
            throw new IOException("Must supply either -t or -f.");
        }
        if (this.destination == null) {
            throw new IOException("Destination not supplied.");
        }
        log.debug("Destination is " + this.destination);
        log.debug("Recursive is " + this.recursive);
        log.debug("Directory is " + this.directory);
        log.debug("Verbosity is " + this.verbosity);
        log.debug("From is " + this.from);
        log.debug("To is " + this.to);
        log.debug("Preserve Attributes " + this.preserveAttributes);
        log.debug("Creating pipes");
        this.pipeIn = new PipedOutputStream();
        this.pipeErr = new PipedOutputStream();
        this.pipeOut = new PipedInputStream();
        this.in = new PipedInputStream(this.pipeIn);
        this.err = new PipedInputStream(this.pipeErr);
        this.out = new PipedOutputStream(this.pipeOut);
    }

    private void writeOk() throws IOException {
        log.debug("Sending client ok command");
        this.pipeIn.write(0);
        this.pipeIn.flush();
    }

    private void writeCommand(String cmd) throws IOException {
        log.debug("Sending command '" + cmd + "'");
        this.pipeIn.write(cmd.getBytes());
        if (!cmd.endsWith("\n")) {
            this.pipeIn.write("\n".getBytes());
        }
        this.pipeIn.flush();
    }

    private void writeError(String msg) throws IOException {
        this.writeError(msg, false);
    }

    private void writeError(String msg, boolean serious) throws IOException {
        log.debug("Sending error message '" + msg + "' to client (serious=" + serious + ")");
        this.pipeIn.write(serious ? 2 : 1);
        this.pipeIn.write(msg.getBytes());
        if (!msg.endsWith("\n")) {
            this.pipeIn.write(10);
        }
        this.pipeIn.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block22: {
            log.debug("Running ScpServer thread");
            try {
                if (this.from) {
                    log.info("From mode");
                    try {
                        block21: {
                            this.waitForResponse();
                            StringPattern sp = new StringPattern(this.destination);
                            if (sp.hasWildcard()) {
                                log.debug("Path contains wildcard");
                                String base = this.destination;
                                String dir = ".";
                                int idx = base.lastIndexOf(47);
                                if (idx != -1) {
                                    if (idx > 0) {
                                        dir = base.substring(0, idx);
                                    }
                                    base = base.substring(idx + 1);
                                }
                                log.debug("Looking for matches in " + dir + " for " + base);
                                sp = new StringPattern(base);
                                byte[] handle = null;
                                try {
                                    handle = this.nfs.openDirectory(dir);
                                    SftpFile[] files = this.nfs.readDirectory(handle);
                                    for (int i = 0; i < files.length; ++i) {
                                        log.debug("Testing for match against " + files[i].getFilename());
                                        if (sp.matches(files[i].getFilename())) {
                                            log.debug("Matched");
                                            this.writeFileToRemote(dir + "/" + files[i].getFilename());
                                            continue;
                                        }
                                        log.debug("No match");
                                    }
                                    Object var9_13 = null;
                                    if (handle == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    Object var9_14 = null;
                                    if (handle == null) throw throwable;
                                    try {
                                        this.nfs.closeFile(handle);
                                        throw throwable;
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {}
                                catch (Exception e) {}
                                this.nfs.closeFile(handle);
                            } else {
                                log.debug("No wildcards");
                                this.writeFileToRemote(this.destination);
                            }
                        }
                        log.debug("File transfers complete");
                        break block22;
                    }
                    catch (FileNotFoundException fnfe) {
                        log.error(fnfe);
                        this.writeError(fnfe.getMessage(), true);
                        throw new IOException(fnfe.getMessage());
                    }
                    catch (PermissionDeniedException pde) {
                        log.error(pde);
                        this.writeError(pde.getMessage(), true);
                        throw new IOException(pde.getMessage());
                    }
                    catch (InvalidHandleException ihe) {
                        log.error(ihe);
                        this.writeError(ihe.getMessage(), true);
                        throw new IOException(ihe.getMessage());
                    }
                    catch (IOException ioe) {
                        log.error(ioe);
                        this.writeError(ioe.getMessage(), true);
                        throw new IOException(ioe.getMessage());
                    }
                }
                log.info("To mode");
                this.readFromRemote(this.destination);
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error(t);
                this.exitCode = 1;
            }
        }
        log.debug("ScpServer stopped, notify block on waitForExitCode().");
        ScpServer scpServer = this;
        synchronized (scpServer) {
            this.notify();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeDirToRemote(String path) throws IOException {
        FileAttributes attr = this.nfs.getFileAttributes(path);
        if (attr.isDirectory() && !this.recursive) {
            this.writeError("File " + path + " is a directory, use recursive mode");
            return false;
        }
        String basename = path;
        int idx = path.lastIndexOf(47);
        if (idx != -1) {
            basename = path.substring(idx + 1);
        }
        this.writeCommand("D" + attr.getMaskString() + " 0 " + basename + "\n");
        this.waitForResponse();
        byte[] handle = null;
        handle = this.nfs.openDirectory(path);
        SftpFile[] list = this.nfs.readDirectory(handle);
        for (int i = 0; i < list.length; ++i) {
            this.writeFileToRemote(path + "/" + list[i].getFilename());
        }
        this.writeCommand("E");
        Object var9_10 = null;
        if (handle == null) return true;
        try {
            this.nfs.closeFile(handle);
            return true;
        }
        catch (Exception e) {
            log.error(e);
        }
        return true;
        {
            catch (InvalidHandleException ihe) {
                throw new IOException(ihe.getMessage());
            }
            catch (PermissionDeniedException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (handle == null) throw throwable;
            try {
                this.nfs.closeFile(handle);
                throw throwable;
            }
            catch (Exception e) {
                log.error(e);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeFileToRemote(String path) throws IOException, PermissionDeniedException, InvalidHandleException {
        block16: {
            attr = this.nfs.getFileAttributes(path);
            if (attr.isDirectory()) {
                if (!this.writeDirToRemote(path)) {
                    return;
                }
            } else {
                if (attr.isFile()) {
                    basename = path;
                    idx = basename.lastIndexOf(47);
                    if (idx != -1) {
                        basename = path.substring(idx + 1);
                    }
                    this.writeCommand("C" + attr.getMaskString() + " " + attr.getSize() + " " + basename + "\n");
                    this.waitForResponse();
                    ScpServer.log.debug("Opening file " + path);
                    handle = null;
                    try {
                        handle = this.nfs.openFile(path, new UnsignedInteger32(1L), attr);
                        ScpServer.log.debug("Sending file");
                        for (count = 0; count < attr.getSize().intValue(); count += buf.length) {
                            try {
                                buf = this.nfs.readFile(handle, new UnsignedInteger64(String.valueOf(count)), new UnsignedInteger32(ScpServer.BUFFER_SIZE));
                                ScpServer.log.debug("Writing block of " + buf.length + " bytes");
                                this.pipeIn.write(buf);
                                continue;
                            }
                            catch (EOFException eofe) {
                                ScpServer.log.debug("End of file - finishing transfer");
                                break;
                            }
                        }
                        this.pipeIn.flush();
                        if (count < attr.getSize().intValue()) {
                            throw new IOException("File transfer terminated abnormally.");
                        }
                        ScpServer.log.info("File transfer complete.");
                        this.writeOk();
                        var9_9 = null;
                        ** if (handle == null) goto lbl-1000
                    }
                    catch (Throwable var8_13) {
                        var9_10 = null;
                        if (handle != null) {
                            try {
                                this.nfs.closeFile(handle);
                            }
                            catch (Exception e) {
                                ScpServer.log.error(e);
                            }
                        }
                        throw var8_13;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.nfs.closeFile(handle);
                        }
                        catch (Exception e) {
                            ScpServer.log.error(e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block16;
                    }
                }
                throw new IOException(path + " not valid for SCP.");
            }
        }
        this.waitForResponse();
    }

    private void waitForResponse() throws IOException {
        log.debug("Waiting for response");
        int r = this.pipeOut.read();
        if (r == 0) {
            log.debug("Got Ok");
            return;
        }
        if (r == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        String msg = this.readString();
        log.debug("Got error '" + msg + "'");
        if (r == 2) {
            log.debug("This is a serious error");
            throw new IOException(msg);
        }
        throw new IOException("SCP returned an unexpected error: " + msg);
    }

    /*
     * Unable to fully structure code
     */
    private void readFromRemote(String path) throws IOException {
        cmdParts = new String[3];
        this.writeOk();
        block25: while (true) {
            ScpServer.log.debug("Waiting for command");
            try {
                cmd = this.readString();
            }
            catch (EOFException e) {
                return;
            }
            ScpServer.log.debug("Got command '" + cmd + "'");
            cmdChar = cmd.charAt(0);
            switch (cmdChar) {
                case 'E': {
                    this.writeOk();
                    return;
                }
                case 'T': {
                    ScpServer.log.error("SCP time not currently supported");
                    this.writeError("WARNING: This server does not currently support the SCP time command");
                    continue block25;
                }
                case 'C': 
                case 'D': {
                    this.parseCommand(cmd, cmdParts);
                    attr = null;
                    try {
                        ScpServer.log.debug("Getting attributes for current destination (" + path + ")");
                        attr = this.nfs.getFileAttributes(path);
                    }
                    catch (FileNotFoundException fnfe) {
                        ScpServer.log.debug("Current destination not found");
                    }
                    targetPath = path;
                    name = cmdParts[2];
                    if (attr != null && attr.isDirectory()) {
                        ScpServer.log.debug("Target is a directory");
                        targetPath = targetPath + '/' + name;
                    }
                    targetAttr = null;
                    try {
                        ScpServer.log.debug("Getting attributes for target destination (" + targetPath + ")");
                        targetAttr = this.nfs.getFileAttributes(targetPath);
                    }
                    catch (FileNotFoundException fnfe) {
                        ScpServer.log.debug("Target destination not found");
                    }
                    if (cmdChar == 'D') {
                        ScpServer.log.debug("Got directory request");
                        if (targetAttr != null) {
                            if (!targetAttr.isDirectory()) {
                                msg = "Invalid target " + name + ", must be a directory";
                                this.writeError(msg);
                                throw new IOException(msg);
                            }
                        } else {
                            try {
                                ScpServer.log.debug("Creating directory " + targetPath);
                                if (!this.nfs.makeDirectory(targetPath)) {
                                    msg = "Could not create directory: " + name;
                                    this.writeError(msg);
                                    throw new IOException(msg);
                                }
                                ScpServer.log.debug("Setting permissions on directory");
                                attr.setPermissionsFromMaskString(cmdParts[0]);
                            }
                            catch (FileNotFoundException e1) {
                                this.writeError("File not found");
                                throw new IOException("File not found");
                            }
                            catch (PermissionDeniedException e1) {
                                this.writeError("Permission denied");
                                throw new IOException("Permission denied");
                            }
                        }
                        this.readFromRemote(targetPath);
                        continue block25;
                    }
                    ScpServer.log.debug("Opening file for writing");
                    handle = null;
                    try {
                        handle = this.nfs.openFile(targetPath, new UnsignedInteger32(26L), attr);
                        ScpServer.log.debug("NFS file opened");
                        this.writeOk();
                        ScpServer.log.debug("Reading from client");
                        count = 0;
                        length = Long.parseLong(cmdParts[1]);
                        while ((long)count < length) {
                            read = this.pipeOut.read(this.buffer, 0, (int)(length - (long)count < (long)this.buffer.length ? length - (long)count : (long)this.buffer.length));
                            if (read == -1) {
                                throw new EOFException("ScpServer received an unexpected EOF during file transfer");
                            }
                            ScpServer.log.debug("Got block of " + read);
                            this.nfs.writeFile(handle, new UnsignedInteger64(String.valueOf(count)), this.buffer, 0, read);
                            count += read;
                        }
                        ScpServer.log.debug("File transfer complete");
                        var15_22 = null;
                        ** if (handle == null) goto lbl-1000
                    }
                    catch (Throwable var14_24) {
                        var15_22 = null;
                        if (handle != null) {
                            try {
                                ScpServer.log.debug("Closing handle");
                                this.nfs.closeFile(handle);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var14_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ScpServer.log.debug("Closing handle");
                            this.nfs.closeFile(handle);
                        }
                        catch (Exception e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** GOTO lbl114
                        catch (InvalidHandleException ihe) {
                            this.writeError("Invalid handle.");
                            throw new IOException("Invalid handle.");
                        }
                        catch (FileNotFoundException e) {
                            this.writeError("File not found");
                            throw new IOException("File not found");
                        }
                        catch (PermissionDeniedException e) {
                            this.writeError("Permission denied");
                            throw new IOException("Permission denied");
                        }
                    }
lbl114:
                    // 2 sources

                    this.waitForResponse();
                    if (this.preserveAttributes) {
                        attr.setPermissionsFromMaskString(cmdParts[0]);
                        ScpServer.log.debug("Setting permissions on directory to " + attr.getPermissionsString());
                        try {
                            this.nfs.setFileAttributes(targetPath, attr);
                        }
                        catch (Exception e) {
                            this.writeError("Failed to set file permissions.");
                            continue block25;
                        }
                    }
                    this.writeOk();
                    continue block25;
                }
            }
            break;
        }
        this.writeError("Unexpected cmd: " + cmd);
        throw new IOException("SCP unexpected cmd: " + cmd);
    }

    private void parseCommand(String cmd, String[] cmdParts) throws IOException {
        int l = cmd.indexOf(32);
        int r = cmd.indexOf(32, l + 1);
        if (l == -1 || r == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        cmdParts[0] = cmd.substring(1, l);
        cmdParts[1] = cmd.substring(l + 1, r);
        cmdParts[2] = cmd.substring(r + 1);
    }

    private String readString() throws IOException {
        int ch;
        int i = 0;
        while ((ch = this.pipeOut.read()) != 10 && ch >= 0) {
            this.buffer[i++] = (byte)ch;
        }
        if (ch == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        if (this.buffer[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (this.buffer[0] == 2 || this.buffer[0] == 1) {
            String msg = new String(this.buffer, 1, i - 1);
            if (this.buffer[0] == 2) {
                throw new IOException(msg);
            }
            throw new IOException("SCP returned an unexpected error: " + msg);
        }
        return new String(this.buffer, 0, i);
    }
}

