/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.windows;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.windows.WindowsAuthenticationInfo;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowsAuthentication
extends NativeAuthenticationProvider {
    private static Log log = LogFactory.getLog(WindowsAuthentication.class);

    public String getHomeDirectory(String username) throws IOException {
        String dir = null;
        if (Thread.currentThread() instanceof SshThread) {
            dir = (String)SshThread.getCurrentThread().getProperty("user.home");
        }
        if (dir == null) {
            SshThread thread;
            dir = this.getNativeHomeDirectory(this.getDomain(), username);
            if (dir == null && Thread.currentThread() instanceof SshThread) {
                thread = SshThread.getCurrentThread();
                if (!thread.containsProperty("Win32UserAuthInfo")) {
                    int handle = this.createToken(username, this.getDomain());
                    dir = this.getNativeProfileDirectory(handle);
                    this.closeHandle(handle);
                } else {
                    WindowsAuthenticationInfo info = (WindowsAuthenticationInfo)thread.getProperty("Win32UserAuthInfo");
                    dir = this.getNativeProfileDirectory(info.getLogonToken());
                }
                if (dir == null) {
                    dir = ((PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class)).getSetting("DefaultHomeDir");
                }
            }
            if (Thread.currentThread() instanceof SshThread) {
                thread = SshThread.getCurrentThread();
                thread.setProperty("user.home", dir);
            }
        }
        return dir;
    }

    public void logoffUser() throws IOException {
        SshThread thread = SshThread.getCurrentThread();
        log.info("Logging off user " + thread.getUsername() + " from session " + thread.getSessionIdString());
        this.nativeLogoffUser((WindowsAuthenticationInfo)thread.getProperty("Win32UserAuthInfo"));
    }

    public boolean logonUser(String username, String password) throws IOException {
        WindowsAuthenticationInfo tokens = this.nativeLogonUser(username, password, this.getDomain());
        if (tokens != null) {
            log.debug("Authenticated handle is " + String.valueOf(tokens.getLogonToken()));
            if (!(Thread.currentThread() instanceof SshThread)) {
                log.error("Calling process is not an instance of SshThread, cannot set token handle");
                return false;
            }
            ((SshThread)Thread.currentThread()).setProperty("Win32UserAuthInfo", tokens);
            return true;
        }
        log.error("nativeLogonUser returned a null handle!");
        return false;
    }

    public boolean changePassword(String username, String oldpassword, String newpassword) {
        return false;
    }

    public boolean logonUser(String username) throws IOException {
        WindowsAuthenticationInfo tokens = this.nativeLogonUserWOPassword(username, this.getDomain());
        if (tokens != null) {
            log.debug("Authenticated handle is " + String.valueOf(tokens.getLogonToken()));
            if (!(Thread.currentThread() instanceof SshThread)) {
                log.error("Calling process is not an instance of SshThread, cannot set token handle");
                return false;
            }
            ((SshThread)Thread.currentThread()).setProperty("Win32UserAuthInfo", tokens);
            return true;
        }
        log.error("nativeLogonUser returned a null handle!");
        return false;
    }

    protected String getDomain() throws IOException {
        String domain = ".";
        PlatformConfiguration platform = (PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class);
        if (platform.containsSetting("AuthenticateOnDomain") && (domain = platform.getSetting("AuthenticateOnDomain")).trim().length() == 0) {
            domain = ".";
        }
        return domain;
    }

    private native String getNativeHomeDirectory(String var1, String var2);

    public native String getNativeProfileDirectory(int var1);

    private native WindowsAuthenticationInfo nativeLogonUser(String var1, String var2, String var3);

    private native WindowsAuthenticationInfo nativeLogonUserWOPassword(String var1, String var2);

    private native void nativeLogoffUser(WindowsAuthenticationInfo var1);

    private native int createToken(String var1, String var2);

    private native void closeHandle(int var1);

    static {
        System.loadLibrary("sshtools-daemon-win32");
    }
}

