/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SshMsgUserAuthFailure
extends SshMessage {
    protected static final int SSH_MSG_USERAUTH_FAILURE = 51;
    private List auths;
    private boolean partialSuccess;

    public SshMsgUserAuthFailure() {
        super(51);
    }

    public SshMsgUserAuthFailure(String auths, boolean partialSuccess) throws InvalidMessageException {
        super(51);
        this.loadListFromDelimString(auths);
        this.partialSuccess = partialSuccess;
    }

    public List getAvailableAuthentications() {
        return this.auths;
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_FAILURE";
    }

    public boolean getPartialSuccess() {
        return this.partialSuccess;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            String authMethods = null;
            Iterator it = this.auths.iterator();
            while (it.hasNext()) {
                authMethods = (authMethods == null ? "" : authMethods + ",") + (String)it.next();
            }
            baw.writeString(authMethods);
            baw.write(this.partialSuccess ? 1 : 0);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            String auths = bar.readString();
            this.partialSuccess = bar.read() != 0;
            this.loadListFromDelimString(auths);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    private void loadListFromDelimString(String list) {
        StringTokenizer tok = new StringTokenizer(list, ",");
        this.auths = new ArrayList();
        while (tok.hasMoreElements()) {
            this.auths.add(tok.nextElement());
        }
    }
}

