/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(ChannelInputStream.class);
    int[] filter;
    byte[] msgdata;
    int currentPos = 0;
    private SshMessageStore messageStore;
    private Integer type = null;
    private int interrupt = 5000;
    private boolean isBlocking = false;
    private Object lock = new Object();
    private Thread blockingThread = null;

    public ChannelInputStream(SshMessageStore messageStore, Integer type) {
        this.messageStore = messageStore;
        this.filter = new int[1];
        this.type = type;
        this.filter[0] = type != null ? 95 : 94;
    }

    public ChannelInputStream(SshMessageStore messageStore) {
        this(messageStore, null);
    }

    public int available() {
        int available = 0;
        if (this.msgdata != null) {
            available = this.msgdata.length - this.currentPos;
            if (log.isDebugEnabled() && available > 0) {
                log.debug(String.valueOf(available) + " bytes of channel data available");
            }
            int n = available = available >= 0 ? available : 0;
        }
        if (available == 0) {
            try {
                if (this.type != null) {
                    SshMsgChannelExtendedData msg = (SshMsgChannelExtendedData)this.messageStore.peekMessage(this.filter);
                    available = msg.getChannelData().length;
                } else {
                    SshMsgChannelData msg = (SshMsgChannelData)this.messageStore.peekMessage(this.filter);
                    available = msg.getChannelData().length;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.valueOf(available) + " bytes of channel data available");
                }
            }
            catch (MessageStoreEOFException mse) {
                log.debug("No bytes available since the MessageStore is EOF");
                available = -1;
            }
            catch (MessageNotAvailableException mna) {
                available = 0;
            }
            catch (InterruptedException ex) {
                log.info("peekMessage was interrupted, no data available!");
                available = 0;
            }
        }
        return available;
    }

    public void close() throws IOException {
        log.info("Closing ChannelInputStream");
        this.messageStore.close();
    }

    public boolean isClosed() {
        return this.messageStore.isClosed();
    }

    public void setBlockInterrupt(int interrupt) {
        this.interrupt = interrupt == 0 ? Integer.MAX_VALUE : interrupt;
    }

    public void interrupt() {
        this.messageStore.breakWaiting();
    }

    public int read() throws IOException {
        try {
            this.block();
            return this.msgdata[this.currentPos++] & 0xFF;
        }
        catch (MessageStoreEOFException mse) {
            return -1;
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("The thread was interrupted whilst waiting for channel data");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.block();
            int actual = this.available();
            if (actual > len) {
                actual = len;
            }
            if (actual > 0) {
                System.arraycopy(this.msgdata, this.currentPos, b, off, actual);
                this.currentPos += actual;
            }
            return actual;
        }
        catch (MessageStoreEOFException mse) {
            return -1;
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException("The thread was interrupted whilst waiting for channel data");
        }
    }

    private void block() throws MessageStoreEOFException, InterruptedException, IOException {
        if (this.msgdata == null) {
            this.collectNextMessage();
        }
        if (this.currentPos >= this.msgdata.length) {
            this.collectNextMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBlockingOperation() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBlocking) {
                throw new IOException("Cannot read from InputStream! " + this.blockingThread == null ? "**NULL THREAD**" : this.blockingThread.getName() + " is currently performing a blocking operation");
            }
            log.debug("Starting blocking operation");
            this.blockingThread = Thread.currentThread();
            this.isBlocking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBlockingOperation() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            log.debug("Completed blocking operation");
            this.blockingThread = null;
            this.isBlocking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectNextMessage() throws MessageStoreEOFException, InterruptedException, IOException {
        this.startBlockingOperation();
        try {
            if (this.type != null) {
                SshMsgChannelExtendedData msg = null;
                while (msg == null && (!this.isClosed() || this.messageStore.hasMessages())) {
                    try {
                        log.debug("Waiting for extended channel data");
                        msg = (SshMsgChannelExtendedData)this.messageStore.getMessage(this.filter, this.interrupt);
                    }
                    catch (MessageNotAvailableException ex) {}
                }
                if (msg == null) throw new MessageStoreEOFException();
                this.msgdata = msg.getChannelData();
                this.currentPos = 0;
            } else {
                SshMsgChannelData msg = null;
                while (msg == null && (!this.isClosed() || this.messageStore.hasMessages())) {
                    try {
                        log.debug("Waiting for channel data");
                        msg = (SshMsgChannelData)this.messageStore.getMessage(this.filter, this.interrupt);
                    }
                    catch (MessageNotAvailableException ex1) {
                        log.debug("Message not available");
                        throw new SocketTimeoutException("Read timed out");
                    }
                }
                if (msg == null) throw new MessageStoreEOFException();
                this.msgdata = msg.getChannelData();
                this.currentPos = 0;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.stopBlockingOperation();
            throw throwable;
        }
        this.stopBlockingOperation();
    }
}

