/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.cipher.BlowfishCbc;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.cipher.TripleDesCbc;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCipherFactory {
    private static HashMap ciphers;
    private static String defaultCipher;
    private static Log log;
    private static ArrayList supported;

    protected SshCipherFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCipher() {
        return defaultCipher;
    }

    public static List getSupportedCiphers() {
        return supported;
    }

    public static SshCipher newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        log.info("Creating new " + algorithmName + " cipher instance");
        try {
            return (SshCipher)((Class)ciphers.get(algorithmName)).newInstance();
        }
        catch (Throwable t) {
            throw new AlgorithmNotSupportedException(algorithmName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshCipherFactory.class);
        ciphers = new HashMap();
        log.info("Loading supported cipher algorithms");
        ciphers.put("3des-cbc", TripleDesCbc.class);
        ciphers.put("blowfish-cbc", BlowfishCbc.class);
        defaultCipher = "blowfish-cbc";
        try {
            Enumeration<URL> enumer = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.cipher");
            Properties properties = new Properties();
            while (enumer != null && enumer.hasMoreElements()) {
                URL url = enumer.nextElement();
                InputStream in = url.openStream();
                properties.load(in);
                IOUtil.closeStream(in);
                int num = 1;
                String name = "";
                while (properties.getProperty("cipher.name." + String.valueOf(num)) != null) {
                    try {
                        name = properties.getProperty("cipher.name." + String.valueOf(num));
                        Class<?> cls = ConfigurationLoader.getExtensionClassLoader().loadClass(properties.getProperty("cipher.class." + String.valueOf(num)));
                        cls.newInstance();
                        ciphers.put(name, cls);
                        log.info("Installed " + name + " cipher");
                    }
                    catch (Throwable ex) {
                        log.info("Could not install cipher class for " + name, ex);
                    }
                    ++num;
                }
            }
        }
        catch (Throwable t) {
            log.info("Failed to load ciphers", t);
        }
        supported = new ArrayList(ciphers.keySet());
    }
}

