/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.tunnel.PortForwardingPane;
import com.sshtools.tunnel.TunnelingPropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActiveTunnelsSessionPanel
extends SshToolsApplicationSessionPanel {
    private TunnelingPropertiesPanel settings = new TunnelingPropertiesPanel();
    private PortForwardingPane pf = new PortForwardingPane(this);
    private ToggleActiveChannelsAction toggleActiveAction;
    private EditTunnelsAction editTunnelsAction;
    private NewTunnelAction newTunnelAction;
    private RemoveAction removeAction;
    private ResourceIcon icon = new ResourceIcon(ActiveTunnelsSessionPanel.class, "forward.png");
    private SshToolsConnectionTab[] tabs = new SshToolsConnectionTab[]{this.settings};
    protected StartAction startAction = new StartAction();
    protected StopAction stopAction = new StopAction();
    protected StopImmediatelyAction stopImmediatelyAction = new StopImmediatelyAction();

    public ActiveTunnelsSessionPanel() {
        super(new BorderLayout());
    }

    public String getId() {
        return "tunneling";
    }

    public boolean requiresConfiguration() {
        return false;
    }

    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        this.add((Component)this.pf, "Center");
        this.initActions();
        this.deregisterAction(this.getAction("Options"));
        this.setActionVisible("New Window", false);
        this.setActionVisible("About", false);
        this.pf.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if ((evt.getModifiers() & 4) > 0) {
                    ActiveTunnelsSessionPanel.this.setAvailableActions();
                    ActiveTunnelsSessionPanel.this.getContextMenu().show(((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.table, evt.getX(), evt.getY());
                }
                ActiveTunnelsSessionPanel.this.setAvailableActions();
            }

            public void mouseReleased(MouseEvent evt) {
                ActiveTunnelsSessionPanel.this.setAvailableActions();
            }
        });
        this.setAvailableActions();
    }

    protected void initActions() {
        int i = 1;
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Tunnel", "Tunnel", 116, 30));
        this.editTunnelsAction = new EditTunnelsAction();
        this.newTunnelAction = new NewTunnelAction();
        this.removeAction = new RemoveAction();
        this.toggleActiveAction = new ToggleActiveChannelsAction();
        this.pf.table.getInputMap(i).put(KeyStroke.getKeyStroke(69, 8, false), "Edit");
        this.pf.table.getActionMap().put("Edit", this.editTunnelsAction);
        this.pf.table.getInputMap(i).put(KeyStroke.getKeyStroke(83, 8, false), "Stop");
        this.pf.table.getActionMap().put("Stop", this.stopAction);
        this.pf.table.getInputMap(i).put(KeyStroke.getKeyStroke(84, 8, false), "Start");
        this.pf.table.getActionMap().put("Start", this.startAction);
        this.pf.table.getInputMap(i).put(KeyStroke.getKeyStroke(78, 8, false), "New Tunnel");
        this.pf.table.getActionMap().put("New Tunnel", this.newTunnelAction);
        this.pf.table.getInputMap(i).put(KeyStroke.getKeyStroke(82, 8, false), "Remove Tunnel");
        this.pf.table.getActionMap().put("Remove Tunnel", this.removeAction);
        this.pf.table.getInputMap(i).put(KeyStroke.getKeyStroke(67, 8, false), "Close Tunnel");
        this.pf.table.getActionMap().put("Close Tunnel", this.removeAction);
        this.registerAction(this.newTunnelAction);
        this.registerAction(this.editTunnelsAction);
        this.registerAction(this.startAction);
        this.registerAction(this.stopAction);
        this.registerAction(this.removeAction);
        this.registerAction(this.toggleActiveAction);
        this.registerAction(this.stopImmediatelyAction);
    }

    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.tabs;
    }

    public void addEventListener(ChannelEventListener eventListener) {
    }

    public void setAvailableActions() {
        if (this.pf.table.getSelectedRowCount() == 0 || this.pf.table.getRowCount() == 0) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(false);
            this.stopImmediatelyAction.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.editTunnelsAction.setEnabled(false);
        } else if (this.pf.table.getSelectedRowCount() > 1) {
            for (int i = 0; i < this.pf.table.getSelectedRowCount(); ++i) {
                if (this.pf.model.getForwardingConfigurationAt(i).isForwarding()) {
                    this.stopAction.setEnabled(true);
                    this.stopImmediatelyAction.setEnabled(true);
                    continue;
                }
                this.startAction.setEnabled(true);
            }
        } else {
            this.startAction.setEnabled(!this.pf.isSelectedTunnelStarted());
            this.stopAction.setEnabled(this.pf.isSelectedTunnelStarted());
            this.stopImmediatelyAction.setEnabled(this.pf.isSelectedTunnelStarted());
            this.removeAction.setEnabled(!this.pf.isSelectedTunnelStarted());
            this.editTunnelsAction.setEnabled(!this.pf.isSelectedTunnelStarted());
        }
    }

    public void close() {
    }

    public ResourceIcon getIcon() {
        return this.icon;
    }

    public boolean canClose() {
        return true;
    }

    public boolean onOpenSession() throws IOException {
        ForwardingClient fwd = this.manager.getForwardingClient();
        this.pf.setClient(fwd);
        return true;
    }

    private void saveProfile() {
        this.pf.applyForwardingToProfile(this.getCurrentConnectionProfile());
        this.manager.applyProfileChanges(this.getCurrentConnectionProfile());
    }

    class EditTunnelsAction
    extends StandardAction {
        public EditTunnelsAction() {
            this.putValue("Name", "Edit Tunnel");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "properties.png"));
            this.putValue("ShortDescription", "Edit Tunnel");
            this.putValue("LongDescription", "Edit secure tunneling settings");
            this.putValue("MnemonicKey", new Integer(116));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
            this.putValue("ActionCommandKey", "edit-tunnel-command");
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "Tunnel");
            this.putValue("menuItemGroup", new Integer(150));
            this.putValue("menuItemWeight", new Integer(10));
            this.putValue("onToolBar", new Boolean(true));
            this.putValue("toolBarGroup", new Integer(15));
            this.putValue("toolBarWeight", new Integer(10));
            this.putValue("hideToolbarText", new Boolean(true));
            this.putValue("onContextMenu", new Boolean(true));
            this.putValue("contextMenuGroup", new Integer(20));
            this.putValue("contextMenuWeight", new Integer(10));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 8));
        }

        public void actionPerformed(ActionEvent evt) {
            ActiveTunnelsSessionPanel.this.pf.editPortForward();
            ActiveTunnelsSessionPanel.this.saveProfile();
        }
    }

    class NewTunnelAction
    extends StandardAction {
        public NewTunnelAction() {
            this.putValue("Name", "New Tunnel");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "add.png"));
            this.putValue("ShortDescription", "New Tunnel");
            this.putValue("LongDescription", "Create a new secure tunnel");
            this.putValue("MnemonicKey", new Integer(110));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
            this.putValue("ActionCommandKey", "new-tunnel-command");
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "Tunnel");
            this.putValue("menuItemGroup", new Integer(50));
            this.putValue("menuItemWeight", new Integer(10));
            this.putValue("onToolBar", new Boolean(true));
            this.putValue("toolBarGroup", new Integer(5));
            this.putValue("toolBarWeight", new Integer(5));
            this.putValue("hideToolbarText", new Boolean(false));
            this.putValue("onContextMenu", new Boolean(true));
            this.putValue("contextMenuGroup", new Integer(5));
            this.putValue("contextMenuWeight", new Integer(5));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 8));
        }

        public void actionPerformed(ActionEvent evt) {
            ActiveTunnelsSessionPanel.this.pf.addPortForward();
            ActiveTunnelsSessionPanel.this.saveProfile();
        }
    }

    class RemoveAction
    extends StandardAction {
        RemoveAction() {
            this.putValue("Name", "Delete Tunnel");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "remove.png"));
            this.putValue("ShortDescription", "Delete tunnel");
            this.putValue("LongDescription", "Delete a tunnel");
            this.putValue("MnemonicKey", new Integer(114));
            this.putValue("ActionCommandKey", "delete");
            this.putValue("onToolBar", new Boolean(true));
            this.putValue("toolBarGroup", new Integer(15));
            this.putValue("toolBarWeight", new Integer(10));
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "Tunnel");
            this.putValue("menuItemGroup", new Integer(150));
            this.putValue("menuItemWeight", new Integer(20));
            this.putValue("onContextMenu", new Boolean(true));
            this.putValue("contextMenuGroup", new Integer(20));
            this.putValue("contextMenuWeight", new Integer(20));
            this.putValue("hideToolbarText", new Boolean(true));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 8));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            int response = JOptionPane.showConfirmDialog(ActiveTunnelsSessionPanel.this, "Are you sure you wish to delete this tunnel?", "Confirm Delete", 1, 3);
            if (response != 0) {
                return;
            }
            int r = ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.table.getSelectedRow();
            ForwardingConfiguration conf = ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.model.getForwardingConfigurationAt(r);
            try {
                try {
                    if (conf instanceof ForwardingClient.ClientForwardingListener) {
                        ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.client.removeLocalForwarding(conf.getName());
                    } else {
                        ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.client.removeRemoteForwarding(conf.getName());
                    }
                    ActiveTunnelsSessionPanel.this.saveProfile();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(ActiveTunnelsSessionPanel.this, e.getMessage(), "Error", 0);
                    Object var7_6 = null;
                    ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.model.refresh();
                    ActiveTunnelsSessionPanel.this.setAvailableActions();
                }
                Object var7_5 = null;
                ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.model.refresh();
                ActiveTunnelsSessionPanel.this.setAvailableActions();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((ActiveTunnelsSessionPanel)ActiveTunnelsSessionPanel.this).pf.model.refresh();
                ActiveTunnelsSessionPanel.this.setAvailableActions();
                throw throwable;
            }
        }
    }

    class StartAction
    extends StandardAction {
        StartAction() {
            this.putValue("Name", "Start");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "start.png"));
            this.putValue("ShortDescription", "Start Tunnel");
            this.putValue("LongDescription", "Start tunneling on the selected port");
            this.putValue("MnemonicKey", new Integer(115));
            this.putValue("ActionCommandKey", "start");
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(45));
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "Tunnel");
            this.putValue("menuItemGroup", new Integer(100));
            this.putValue("menuItemWeight", new Integer(10));
            this.putValue("onToolBar", new Boolean(true));
            this.putValue("toolBarGroup", new Integer(10));
            this.putValue("toolBarWeight", new Integer(45));
            this.putValue("onContextMenu", new Boolean(true));
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(5));
            this.putValue("hideToolbarText", new Boolean(true));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 8));
        }

        public void actionPerformed(ActionEvent evt) {
            ActiveTunnelsSessionPanel.this.pf.startForwarding();
        }
    }

    class StopAction
    extends StandardAction {
        StopAction() {
            this.putValue("Name", "Stop");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "stop.png"));
            this.putValue("ShortDescription", "Stop Tunnel");
            this.putValue("LongDescription", "Stop tunneling on the selected port");
            this.putValue("MnemonicKey", new Integer(116));
            this.putValue("ActionCommandKey", "stop");
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(45));
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "Tunnel");
            this.putValue("menuItemGroup", new Integer(100));
            this.putValue("menuItemWeight", new Integer(10));
            this.putValue("onToolBar", new Boolean(false));
            this.putValue("toolBarGroup", new Integer(10));
            this.putValue("toolBarWeight", new Integer(45));
            this.putValue("onContextMenu", new Boolean(true));
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(10));
            this.putValue("hideToolbarText", new Boolean(true));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
        }

        public void actionPerformed(ActionEvent evt) {
            int response = JOptionPane.showConfirmDialog(ActiveTunnelsSessionPanel.this, "This option will prevent any further tunnel(s) from being created for the selected protocol(s)\n\nAre you sure you want to proceed?", "Confirm Stop Tunnel", 1, 3);
            if (response == 0) {
                ActiveTunnelsSessionPanel.this.pf.stopForwarding();
            }
        }
    }

    class StopImmediatelyAction
    extends StandardAction {
        StopImmediatelyAction() {
            this.putValue("Name", "Close Tunnel");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "stop.png"));
            this.putValue("ShortDescription", "Close Tunnel");
            this.putValue("LongDescription", "Stops tunneling immediately on the selected port");
            this.putValue("MnemonicKey", new Integer(99));
            this.putValue("ActionCommandKey", "stop-now");
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(50));
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "Tunnel");
            this.putValue("menuItemGroup", new Integer(100));
            this.putValue("menuItemWeight", new Integer(15));
            this.putValue("onToolBar", new Boolean(true));
            this.putValue("toolBarGroup", new Integer(10));
            this.putValue("toolBarWeight", new Integer(50));
            this.putValue("onContextMenu", new Boolean(true));
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(15));
            this.putValue("hideToolbarText", new Boolean(true));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 8));
        }

        public void actionPerformed(ActionEvent evt) {
            int response = JOptionPane.showConfirmDialog(ActiveTunnelsSessionPanel.this, "This will immediately disconnect the selected tunnel(s).\n\nAre you sure you want to proceed?", "Confirm Close Tunnel", 1, 3);
            if (response == 0) {
                ActiveTunnelsSessionPanel.this.pf.closeForwardingChannel();
            }
        }
    }

    class ToggleActiveChannelsAction
    extends StandardAction {
        public ToggleActiveChannelsAction() {
            this.putValue("Name", "Show Connections");
            this.putValue("SmallIcon", new ResourceIcon(ActiveTunnelsSessionPanel.class, "drilldown.png"));
            this.putValue("ShortDescription", "Toggle Display");
            this.putValue("LongDescription", "Toggles the active channel display");
            this.putValue("MnemonicKey", new Integer(97));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
            this.putValue("ActionCommandKey", "toggle-active-command");
            this.putValue("onMenuBar", new Boolean(true));
            this.putValue("menuName", "View");
            this.putValue("menuItemGroup", new Integer(40));
            this.putValue("menuItemWeight", new Integer(10));
            this.putValue("onToolBar", new Boolean(true));
            this.putValue("toolBarGroup", new Integer(25));
            this.putValue("toolBarWeight", new Integer(5));
            this.putValue("onContextMenu", new Boolean(false));
            this.putValue("hideToolbarText", new Boolean(false));
            this.putValue("contextMenuGroup", new Integer(5));
            this.putValue("contextMenuWeight", new Integer(5));
            this.putValue("isToggleButton", new Boolean(true));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 8));
        }

        public void actionPerformed(ActionEvent evt) {
            if (String.valueOf(this.getValue("Name")).equals("Show Connections")) {
                this.putValue("Name", "Hide Connections");
            } else {
                this.putValue("Name", "Show Connections");
            }
            ActiveTunnelsSessionPanel.this.pf.toggleActiveChannelDisplay();
        }
    }
}

