/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import de.mud.jta.HostUnreachableException;
import de.mud.jta.ICliSessionDelegatee;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelnetWrapper
extends TelnetProtocolHandler
implements ICliSessionDelegatee {
    private Log log = LogFactory.getLog(TelnetWrapper.class);
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    private boolean mIsTimeoutAcceptable = false;

    public void connect(String host, int port) throws IOException {
        this.log.debug("Connect(" + host + "," + port + ")");
        try {
            this.socket = new Socket(host, port);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.log.debug("The input stream is " + this.in.getClass().getName());
            this.reset();
        }
        catch (Exception e) {
            this.log.debug("Error connecting" + e);
            this.disconnect();
            throw (IOException)e;
        }
    }

    public void login(String username, String password) throws IOException {
    }

    public void setReadTimeout(int millisecs) {
        try {
            this.socket.setSoTimeout(millisecs);
        }
        catch (SocketException se) {
            this.log.error("Unable to set socket timeout", se);
        }
    }

    public void disconnect() throws IOException {
        this.log.debug("TelnetWrapper: disconnect()");
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void notifyEndOfRecord() {
    }

    public static String pbt(byte[] b) {
        StringBuffer sb = new StringBuffer();
        if (b == null) {
            sb.append("NULL");
        } else if (b.length == 0) {
            sb.append("<empty table>");
        } else {
            sb.append("\n" + new String(b));
        }
        return sb.toString();
    }

    public int read(byte[] b) throws IOException {
        int n = this.negotiate(b);
        if (n > 0) {
            return n;
        }
        while (n <= 0) {
            do {
                if ((n = this.negotiate(b)) <= 0) continue;
                return n;
            } while (n == 0);
            boolean validSocketTimeout = false;
            try {
                n = this.in.read(b);
            }
            catch (SocketTimeoutException ste) {
                if (!this.mIsTimeoutAcceptable) {
                    throw ste;
                }
                this.log.debug("SocketTimeOutException: " + ste);
                validSocketTimeout = true;
            }
            if (n < 0) {
                if (!validSocketTimeout) {
                    this.log.error("read() returned -1 - connection closed by foreign host");
                    throw new HostUnreachableException("Connection closed by foreign host.", "Please verify device connectivity and configuration.");
                }
                return n;
            }
            this.inputfeed(b, n);
            n = this.negotiate(b);
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.out.flush();
    }

    public String getTerminalType() {
        return "";
    }

    public Dimension getWindowSize() {
        return new Dimension(80, 24);
    }

    public void setLocalEcho(boolean echo) {
        this.log.debug("local echo " + (echo ? "on" : "off"));
    }

    public void setTimeoutAcceptable(boolean isTimeoutAcceptable) {
        this.mIsTimeoutAcceptable = isTimeoutAcceptable;
    }

    public void send(byte[] bytes) throws IOException {
        this.transpose(bytes);
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

