/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IOhChannelType;
import cerent.cms.model.OhCircuitType;
import cerent.util.AbstractEnumBehavior;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.HashMap;

public class OhChannelType
extends AbstractEnumBehavior
implements IOhChannelType,
Comparable {
    protected static AbstractEnumBehavior.EnumRange Range = new AbstractEnumBehavior.EnumRange(OhChannelType.class);
    protected static OhChannelType[] OhChannelTypes = new OhChannelType[Range.getNumTypes()];
    private static HashMap ohChannelTypeMap = new HashMap();
    public static final OhChannelType SDCC_OBJ = new OhChannelType(0, "DCC1(D1-D3)");
    public static final OhChannelType LDCC_TUNNEL1_OBJ = new OhChannelType(1, "DCC2(D4-D6)");
    public static final OhChannelType LDCC_TUNNEL2_OBJ = new OhChannelType(2, "DCC3(D7-D9)");
    public static final OhChannelType LDCC_TUNNEL3_OBJ = new OhChannelType(3, "DCC4(D10-D12)");
    public static final OhChannelType LDCC_OBJ = new OhChannelType(4, "DCC(D4-D12)");
    public static final OhChannelType LOW_OBJ = new OhChannelType(5, "LOW");
    public static final OhChannelType EOW_OBJ = new OhChannelType(6, "EOW");
    public static final OhChannelType UDC_F1_OBJ = new OhChannelType(7, "UDC(F1)");
    public static final OhChannelType UDC_MS_OBJ = new OhChannelType(8, "UDC(D4-D12)");
    public static OhChannelType SDCC_IPTUNNEL_OBJ = new OhChannelType(9, "IPT(D1-D3)");
    public static final OhChannelType GCC_OBJ = new OhChannelType(10, "GCC");
    public static final OhChannelType ETHOSC_OBJ = new OhChannelType(11, "ETHOSC");
    private final String name;
    public static final OhChannelType[] DCC_CHANNEL_TYPES;
    public static final OhChannelType[] LDCC_CHANNEL_TYPES;
    public static OhChannelType[] IPTUNNEL_CHANNEL_TYPES;

    public OhChannelType() {
        this.name = "";
    }

    private OhChannelType(int n, String string) {
        super(OhChannelTypes, n);
        this.name = string;
        OhChannelType.OhChannelTypes[n] = this;
    }

    public int getIndex() {
        return this.getEnum();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static OhChannelType getOhChannelTypeObj(int n) {
        return (OhChannelType)ohChannelTypeMap.get(new Integer(n));
    }

    public int getCorrespondingBlsrExtByte() {
        int n = this.getEnum();
        switch (n) {
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
        }
        return -1;
    }

    public static OhChannelType getOhChannelTypeForBlsrExtByte(int n) {
        switch (n) {
            case 2: {
                return EOW_OBJ;
            }
            case 3: {
                return UDC_F1_OBJ;
            }
        }
        return null;
    }

    public OhCircuitType getCorrespondingCircuitType() {
        int n = this.getEnum();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                return OhCircuitType.SDCC_TUNNEL_CIRCUIT_OBJ;
            }
            case 4: {
                return OhCircuitType.LDCC_TUNNEL_CIRCUIT_OBJ;
            }
            case 5: {
                return OhCircuitType.LOW_CIRCUIT_OBJ;
            }
            case 6: {
                return OhCircuitType.EOW_CIRCUIT_OBJ;
            }
            case 7: {
                return OhCircuitType.F1_UDC_CIRCUIT_OBJ;
            }
            case 8: {
                return OhCircuitType.MS_UDC_CIRCUIT_OBJ;
            }
            case 9: {
                return OhCircuitType.SDCC_IPTUNNEL_CIRCUIT_OBJ;
            }
        }
        throw new IllegalArgumentException("The channel type " + n + " is unsupported.");
    }

    public OhChannelType[] getMutualExclusiveChannelTypes() {
        int n = this.getEnum();
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                return new OhChannelType[]{this};
            }
            case 0: {
                return new OhChannelType[]{this, GCC_OBJ, SDCC_IPTUNNEL_OBJ};
            }
            case 10: {
                return new OhChannelType[]{this, SDCC_OBJ, SDCC_IPTUNNEL_OBJ};
            }
            case 4: 
            case 8: {
                return new OhChannelType[]{UDC_MS_OBJ, LDCC_OBJ, LDCC_TUNNEL1_OBJ, LDCC_TUNNEL2_OBJ, LDCC_TUNNEL3_OBJ};
            }
            case 1: 
            case 2: 
            case 3: {
                return new OhChannelType[]{this, UDC_MS_OBJ, LDCC_OBJ};
            }
            case 9: {
                return new OhChannelType[]{this, GCC_OBJ, SDCC_OBJ};
            }
        }
        throw new IllegalArgumentException("The channel type " + n + " is unsupported.");
    }

    public boolean isOwChannelType() {
        int n = this.getEnum();
        return n == 5 || n == 6;
    }

    public boolean usingLDCC() {
        int n = this.getEnum();
        return n == 8 || n == 4 || n == 1 || n == 2 || n == 3;
    }

    public static Collection getAllOhChannelTypes() {
        return ohChannelTypeMap.values();
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        return this.getIndex() - ((OhChannelType)object).getIndex();
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return OhChannelTypes[this.getIndex()];
    }

    static {
        ohChannelTypeMap.put(new Integer(0), SDCC_OBJ);
        ohChannelTypeMap.put(new Integer(1), LDCC_TUNNEL1_OBJ);
        ohChannelTypeMap.put(new Integer(2), LDCC_TUNNEL2_OBJ);
        ohChannelTypeMap.put(new Integer(3), LDCC_TUNNEL3_OBJ);
        ohChannelTypeMap.put(new Integer(4), LDCC_OBJ);
        ohChannelTypeMap.put(new Integer(5), LOW_OBJ);
        ohChannelTypeMap.put(new Integer(6), EOW_OBJ);
        ohChannelTypeMap.put(new Integer(7), UDC_F1_OBJ);
        ohChannelTypeMap.put(new Integer(8), UDC_MS_OBJ);
        ohChannelTypeMap.put(new Integer(9), SDCC_IPTUNNEL_OBJ);
        ohChannelTypeMap.put(new Integer(10), GCC_OBJ);
        ohChannelTypeMap.put(new Integer(11), ETHOSC_OBJ);
        DCC_CHANNEL_TYPES = new OhChannelType[]{SDCC_OBJ, LDCC_TUNNEL1_OBJ, LDCC_TUNNEL2_OBJ, LDCC_TUNNEL3_OBJ};
        LDCC_CHANNEL_TYPES = new OhChannelType[]{LDCC_TUNNEL1_OBJ, LDCC_TUNNEL2_OBJ, LDCC_TUNNEL3_OBJ};
        IPTUNNEL_CHANNEL_TYPES = new OhChannelType[]{SDCC_IPTUNNEL_OBJ};
    }
}

