/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IOhCircuitType;
import cerent.cms.model.OhChannelType;
import java.util.TreeMap;

public class OhCircuitType
implements IOhCircuitType {
    private static TreeMap ohCktTypeMap = new TreeMap();
    public static OhCircuitType F1_UDC_CIRCUIT_OBJ = new OhCircuitType(0, "User Data - F1", "UDC");
    public static OhCircuitType MS_UDC_CIRCUIT_OBJ = new OhCircuitType(1, "User Data - D4-D12", "DCC");
    public static OhCircuitType LOW_CIRCUIT_OBJ = new OhCircuitType(2, "Local Orderwire", "LOW");
    public static OhCircuitType EOW_CIRCUIT_OBJ = new OhCircuitType(3, "Express Orderwire", "EOW");
    public static OhCircuitType SDCC_TUNNEL_CIRCUIT_OBJ = new OhCircuitType(4, "DCC Tunnel - D1-D3", "DCCT");
    public static OhCircuitType LDCC_TUNNEL_CIRCUIT_OBJ = new OhCircuitType(5, "DCC Tunnel - D4-D12", "DCCT");
    public static OhCircuitType SDCC_IPTUNNEL_CIRCUIT_OBJ = new OhCircuitType(6, "IP Tunnel - D1-D3", "IPT");
    private int index;
    private String longName;
    private String shortName;
    public static final OhCircuitType[] NON_DCC_TUNNEL_CIRCUIT_TYPES;

    private OhCircuitType(int n, String string, String string2) {
        this.index = n;
        this.longName = string;
        this.shortName = string2;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.getLongName();
    }

    public int getCorrespondingAicPortEqType() {
        switch (this.index) {
            case 0: {
                return 98;
            }
            case 1: {
                return 99;
            }
            case 2: 
            case 3: {
                return 44;
            }
        }
        throw new IllegalArgumentException("The circuit type " + this.index + " is unsupported.");
    }

    public boolean isIpTunnelType() {
        return this.index == 6;
    }

    public OhChannelType getCorrespondingChannelType() {
        switch (this.index) {
            case 0: {
                return OhChannelType.UDC_F1_OBJ;
            }
            case 1: {
                return OhChannelType.UDC_MS_OBJ;
            }
            case 2: {
                return OhChannelType.LOW_OBJ;
            }
            case 3: {
                return OhChannelType.EOW_OBJ;
            }
            case 4: {
                return OhChannelType.SDCC_OBJ;
            }
            case 5: {
                return OhChannelType.LDCC_OBJ;
            }
            case 6: {
                return OhChannelType.SDCC_IPTUNNEL_OBJ;
            }
        }
        throw new IllegalArgumentException("The circuit type " + this.index + " is unsupported.");
    }

    public boolean isOwCircuitType() {
        return this.index == 2 || this.index == 3;
    }

    public boolean isDccTunnelType() {
        return this.index == 4 || this.index == 5;
    }

    public boolean isF1UdcType() {
        return this.index == 0;
    }

    public boolean usingWholeLDCC() {
        return this.index == 5 || this.index == 1;
    }

    public static OhCircuitType getOhCktTypeObj(int n) {
        return (OhCircuitType)ohCktTypeMap.get(new Integer(n));
    }

    public static final OhCircuitType[] getAllOhCktTypes() {
        return ohCktTypeMap.values().toArray(new OhCircuitType[0]);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object object) {
        return this.index == ((OhCircuitType)object).getIndex();
    }

    static {
        ohCktTypeMap.put(new Integer(0), F1_UDC_CIRCUIT_OBJ);
        ohCktTypeMap.put(new Integer(1), MS_UDC_CIRCUIT_OBJ);
        ohCktTypeMap.put(new Integer(2), LOW_CIRCUIT_OBJ);
        ohCktTypeMap.put(new Integer(3), EOW_CIRCUIT_OBJ);
        ohCktTypeMap.put(new Integer(4), SDCC_TUNNEL_CIRCUIT_OBJ);
        ohCktTypeMap.put(new Integer(5), LDCC_TUNNEL_CIRCUIT_OBJ);
        ohCktTypeMap.put(new Integer(6), SDCC_IPTUNNEL_CIRCUIT_OBJ);
        NON_DCC_TUNNEL_CIRCUIT_TYPES = new OhCircuitType[]{F1_UDC_CIRCUIT_OBJ, MS_UDC_CIRCUIT_OBJ, LOW_CIRCUIT_OBJ, EOW_CIRCUIT_OBJ};
    }
}

