/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IPathStateInfo;
import cerent.util.ComparisonUtil;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.io.Serializable;

public class PathStateInfo
implements IPathStateInfo,
Comparable,
Serializable {
    private IHoNum hoNum;
    private ILoNum loNum;
    private int pathState;

    public PathStateInfo(IHoNum iHoNum, ILoNum iLoNum, int n) {
        this.hoNum = iHoNum;
        this.loNum = iLoNum;
        this.pathState = n;
    }

    public PathStateInfo() {
        this.hoNum = null;
        this.loNum = null;
        this.pathState = 0;
    }

    @Override
    public IHoNum getHoNum() {
        return this.hoNum;
    }

    @Override
    public ILoNum getLoNum() {
        return this.loNum;
    }

    @Override
    public int getPathState() {
        return this.pathState;
    }

    public String getPathStateString() {
        switch (this.pathState) {
            case 0: {
                return "UNAVAILABLE";
            }
            case 1: {
                return "AVAILABLE";
            }
            case 2: {
                return "USED";
            }
            case 3: {
                return "NOT_SELECTABLE";
            }
        }
        return "UNKNOWN";
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof PathStateInfo) {
            PathStateInfo pathStateInfo = (PathStateInfo)object;
            short s = this.getHoNum().getHoNum();
            short s2 = pathStateInfo.getHoNum().getHoNum();
            n = ComparisonUtil.compare((int)s, (int)s2);
        }
        return n;
    }
}

