/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.helper;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPpmModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.util.KDebug;
import cerent.util.TDMTerminology;
import java.util.List;

public class PortHelper {
    private static final String RPR_EAST = "RPR East";
    private static final String RPR_WEST = "RPR West";
    private static final KDebug db = new KDebug("PortHelper");

    private PortHelper() {
    }

    public static String getPortNumString(INodeModel iNodeModel, int n) {
        String string;
        block5: {
            string = "";
            if (iNodeModel == null || n == 0) {
                return string;
            }
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel != null) {
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    if (iEntityModel instanceof IPortModel) {
                        string = PortHelper.getPortNumString((IPortModel)iEntityModel);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block5;
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return string;
    }

    public static String getPortNumString(IPortModel iPortModel) {
        return PortHelper.getPortNumString(iPortModel, '-');
    }

    public static String getPortNumString(IPortModel iPortModel, char c) {
        if (Feature.provides(iPortModel.getNodeModel(), Feature.EXP_PORT_NUM)) {
            return PortHelper.getConcatenatedString(iPortModel.getPortNum(), c);
        }
        return Integer.toString(iPortModel.getPort());
    }

    public static String getConcatenatedString(int[] nArray) {
        return PortHelper.getConcatenatedString(nArray, '-');
    }

    public static String getConcatenatedString(int[] nArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getPortTypeString(IEntityModel iEntityModel) {
        return PortHelper.getPortTypeString(iEntityModel.getNodeModel(), iEntityModel.getModuleModel(), iEntityModel.getEqType());
    }

    public static String getPortTypeString(INodeModel iNodeModel, int n) {
        return PortHelper.getPortTypeString(iNodeModel, null, n);
    }

    private static String getPortTypeString(INodeModel iNodeModel, IModuleModel iModuleModel, int n) {
        String string = EqTypeHelper.eqTypeToName(iNodeModel.getTDMTerminology(), n);
        int n2 = string.indexOf("_VT_MAPPED");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((n2 = string.indexOf("_PORT")) > 0) {
            string = string.substring(0, n2);
        }
        if (n == 166 || n == 104) {
            n2 = string.indexOf("_");
            if (n2 > 0) {
                string = string.substring(n2 + 1, string.length());
            }
        } else if (n == 165 || n == 105) {
            string = iModuleModel != null && iModuleModel.inRPRMode() ? "RPR" : "POS";
        } else if (n == 230) {
            string = "ETHER";
        } else if (n == 231) {
            string = "POS";
        }
        return string;
    }

    public static String getPortNumAndTypeString(IPortModel iPortModel, boolean bl, boolean bl2) {
        int n;
        String string;
        INodeModel iNodeModel = iPortModel.getNodeModel();
        String string2 = string = PortHelper.getPortNumString(iPortModel);
        IModuleModel iModuleModel = iPortModel.getModuleModel();
        if (Feature.provides(iNodeModel, Feature.EXP_PORT_NUM) && iPortModel.isMutable()) {
            Object object;
            String string3;
            block18: {
                n = iPortModel.getEqType();
                string3 = PortHelper.getPortTypeString(iNodeModel, n);
                if (iPortModel.getModuleModel().getEqType() == 293 || (iPortModel.getModuleModel().getEqType() == 300 || iPortModel.getModuleModel().getEqType() == 301 || iPortModel.getModuleModel().getEqType() == 356 || iPortModel.getModuleModel().getEqType() == 358) && string3.equals("Trunk")) {
                    try {
                        Object object2;
                        object = null;
                        if (iPortModel instanceof IDwdmPortModel) {
                            object = iPortModel.getInterfaceModel();
                        } else if (iPortModel.getParent() instanceof IPpmModel && (object2 = iPortModel.getParent().getDescendantsOfEqType(123)).size() > 0) {
                            object = ((IDwdmPortModel)object2.get(0)).getInterfaceModel();
                        }
                        if (object != null && object instanceof IDwdmTrkLineModel && (object2 = (IDwdmTrkLineModel)object).isClient()) {
                            string3 = "Client";
                        }
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (db.on()) {
                            KDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (db.on()) {
                            KDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (!db.on()) break block18;
                        KDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                }
            }
            object = iPortModel.getPortNum();
            if (!(bl2 || n != 34 && n != 68 && n != 69)) {
                string2 = PortHelper.getExpPortType(iPortModel.getModuleModel().getEqType(), (int[])object, n, iNodeModel);
            } else if (Feature.provides(iNodeModel, Feature.RPR_802_17) && (n == 105 || n == 165) && iPortModel.inRPRMode()) {
                string2 = Feature.provides(iNodeModel, Feature.POS_ON_MLMR) && iPortModel.getModuleModel().getEqType() == 285 ? (object[0] == iModuleModel.getRPREastPort() ? RPR_EAST : RPR_WEST) : (object[0] == false ? RPR_EAST : RPR_WEST);
            } else {
                String string4 = bl ? (iPortModel.isPortNumUnique() ? string : string3 + "-" + string) : (string2 = string + " (" + string3 + ")");
            }
        }
        if (iPortModel.getEqType() == 342) {
            n = iPortModel.getPortNum()[0];
            string2 = "MSISC_A_" + n;
            if (n > 3) {
                string2 = "MSISC_B_" + (n -= 3);
            }
        }
        return string2;
    }

    private static String getExpPortType(int n, int[] nArray, int n2, INodeModel iNodeModel) {
        String string = null;
        String string2 = PortHelper.getPortTypeString(iNodeModel, n2);
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        if (n == 234 || n == 233) {
            if (nArray.length == 1 && (n2 == 68 || n2 == 34)) {
                string = tDMTerminology.getDs1PortStringTerm(nArray[0] - 1, n);
            } else if (nArray.length == 1 && n2 == 69) {
                string = tDMTerminology.getDs3PortStringTerm(nArray[0] - 1, n);
            } else {
                db.println("Unexpected port number for DS1 port on WBE-84!");
            }
        }
        return string != null ? string2 + string : string2;
    }

    public static String getTDMPortTypeString(INodeModel iNodeModel, int n) {
        String string = null;
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        switch (n) {
            case 28: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(0);
                break;
            }
            case 29: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(1);
                break;
            }
            case 30: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(2);
                break;
            }
            case 61: {
                string = tDMTerminology.getLinkPhysicalTypeTerm(3);
                break;
            }
            default: {
                string = PortHelper.getPortTypeString(iNodeModel, n);
            }
        }
        return string;
    }

    public static String getFormattedPortAlias(IPortModel iPortModel) {
        IEntityModel iEntityModel;
        String string = PortHelper.doGetFormattedPortAlias(iPortModel);
        if (string.length() == 0 && ((iPortModel.getEqType() == 186 || iPortModel.getEqType() == 355) && iPortModel.getModuleModel().getEqType() == 273 || (iPortModel.getEqType() == 34 || iPortModel.getEqType() == 68 || iPortModel.getEqType() == 32 || iPortModel.getEqType() == 69) && iPortModel.getModuleModel().getEqType() == 272) && (iEntityModel = iPortModel.getParent()).getEqType() == 150) {
            List list = iEntityModel.getChildren();
            for (IEntityModel iEntityModel2 : list) {
                if (iEntityModel2.getEntityIndex() == iPortModel.getEntityIndex() || !(iEntityModel2 instanceof IPortModel)) continue;
                string = PortHelper.doGetFormattedPortAlias((IPortModel)iEntityModel2);
                break;
            }
        }
        return string;
    }

    private static String doGetFormattedPortAlias(IPortModel iPortModel) {
        String string;
        block5: {
            string = null;
            try {
                String string2;
                IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
                if (iInterfaceModel != null && (string2 = iInterfaceModel.getAlias()).length() > 0) {
                    string = " \"" + string2 + "\"";
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (db.on()) {
                    KDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!db.on()) break block5;
                KDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return string == null ? "" : string;
    }
}

