/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IMetrics;
import cerent.util.KDebug;
import cerent.util.LogLevel;
import java.util.LinkedList;

public class Metrics
implements IMetrics {
    private String name;
    private long startTimestamp;
    private long cumulativeTime;
    private boolean cumulative;
    private KDebug db;
    private LogLevel logLevel;
    public static int instanceCount = 0;
    private LinkedList snapshots = null;

    public Metrics(String string, KDebug kDebug) {
        this.name = string;
        this.db = kDebug;
        ++instanceCount;
        this.snapshots = new LinkedList();
        this.cumulativeTime = 0L;
        this.startTimestamp = System.currentTimeMillis();
    }

    public Metrics(String string, KDebug kDebug, LogLevel logLevel) {
        this(string, kDebug);
        this.logLevel = logLevel;
    }

    public Metrics(String string, KDebug kDebug, LogLevel logLevel, boolean bl) {
        this(string, kDebug, logLevel);
        this.cumulative = bl;
    }

    @Override
    public void lap(String string) {
        if (this.isLoggingEnabled()) {
            Snapshot snapshot = new Snapshot(string);
            this.snapshots.addLast(snapshot);
            this.db.finest("lap: " + snapshot);
        }
    }

    @Override
    public void stop() {
        if (this.isLoggingEnabled()) {
            long l = System.currentTimeMillis();
            long l2 = l - this.startTimestamp;
            this.cumulativeTime += l2;
            if (!this.cumulative) {
                this.db.println("Metrics: method => " + this.name + ", time => " + l2);
            }
            long l3 = this.startTimestamp;
            for (Snapshot snapshot : this.snapshots) {
                long l4 = snapshot.timestamp - l3;
                l3 = snapshot.timestamp;
                this.db.println("Metrics: method => " + this.name + ", laptime => " + l4 + "ms, " + snapshot.name);
            }
            if (this.cumulative) {
                this.resetStartTime();
            }
        }
    }

    protected void resetStartTime() {
        this.startTimestamp = System.currentTimeMillis();
    }

    protected long getCumulativeTime() {
        return this.cumulativeTime;
    }

    private boolean isLoggingEnabled() {
        return !(!this.db.on() && !IMetrics.allDb.on() || this.db.getLogLevel().intValue() > this.logLevel.intValue() && IMetrics.allDb.getLogLevel().intValue() > this.logLevel.intValue());
    }

    public class Snapshot {
        String name;
        long timestamp;

        public Snapshot(String string) {
            this.name = string;
            this.timestamp = System.currentTimeMillis();
        }

        public String toString() {
            return this.name + "::" + this.timestamp;
        }
    }
}

