/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.KDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.gui.row.RowTableModel;
import java.awt.Component;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableModelAdapter
extends AbstractTableModel {
    JTable fTable;
    TableModel fTableModel;
    private static final KDebug db = new KDebug("TableModelAdapter");
    private Vector fColumnMapVector = null;
    private String fDefaultString = "&nbsp;";
    private String fFalseString = "False";
    private String fTrueString = "True";
    private TableColumnModel fTableColumnModel = null;
    private TableColumn fTableColumn = null;
    private int fixedColumns = 0;
    private RowTableModel rtm;
    private TableModel gtm;

    public String getDefaultString() {
        return this.fDefaultString;
    }

    public void setDefaultString(String string) {
        this.fDefaultString = string;
    }

    public String getFalseString() {
        return this.fFalseString;
    }

    public void setFalseString(String string) {
        this.fFalseString = string;
    }

    public String getTrueString() {
        return this.fTrueString;
    }

    public void setTrueString(String string) {
        this.fFalseString = string;
    }

    public TableModelAdapter(TableModel tableModel, JTable jTable) {
        int n;
        this.fTableModel = tableModel;
        this.fColumnMapVector = new Vector();
        if (this.fTableModel instanceof IFixedColumnsTableModel) {
            this.fixedColumns = ((IFixedColumnsTableModel)((Object)this.fTableModel)).getFixedColumnCount();
            for (n = 0; n < this.fixedColumns; ++n) {
                this.fColumnMapVector.add(new Integer(n));
            }
        }
        this.fTable = jTable;
        this.fTableColumnModel = this.fTable.getColumnModel();
        n = this.fTable.getColumnCount();
        if (this.fixedColumns > 0) {
            n += this.fixedColumns;
            for (int i = this.fixedColumns; i < n; ++i) {
                this.fTableColumn = this.fTableColumnModel.getColumn(i - this.fixedColumns);
                int n2 = this.fTableColumn.getModelIndex();
                Integer n3 = new Integer(n2);
                this.fColumnMapVector.add(n3);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4 = this.fTable.convertColumnIndexToModel(i);
                Integer n5 = new Integer(n4);
                this.fColumnMapVector.add(n5);
            }
        }
        if (this.fTable.getModel() instanceof RowTableModel) {
            this.rtm = (RowTableModel)this.fTable.getModel();
        } else if (this.fTable.getModel() instanceof TableModel) {
            this.gtm = this.fTable.getModel();
        }
    }

    private int modelIndexForTableIndex(int n) {
        Object e = this.fColumnMapVector.elementAt(n);
        Integer n2 = (Integer)e;
        int n3 = n2;
        return n3;
    }

    @Override
    public int getColumnCount() {
        return this.fTable.getColumnCount() + this.fixedColumns;
    }

    @Override
    public int getRowCount() {
        return this.fTableModel.getRowCount();
    }

    @Override
    public String getColumnName(int n) {
        int n2 = this.modelIndexForTableIndex(n);
        return this.fTableModel.getColumnName(n2);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = null;
        int n3 = this.modelIndexForTableIndex(n2);
        Object object = this.fTableModel.getValueAt(n, n3);
        if (object != null) {
            if (this.rtm != null || this.gtm != null) {
                Component component;
                if (this.rtm != null) {
                    component = this.rtm.getTableCellRendererComponent(this.fTable, object, false, false, n, n2);
                } else if (this.fixedColumns == 0) {
                    component = this.fTable.getCellRenderer(n, n2).getTableCellRendererComponent(this.fTable, object, false, false, n, n2);
                } else {
                    if (db.on()) {
                        db.print(n + ", " + n2 + " [" + n3 + "] -> ");
                    }
                    if (n2 < this.fixedColumns) {
                        component = null;
                    } else {
                        int n4 = n2 - this.fixedColumns;
                        component = this.fTable.getCellRenderer(n, n4).getTableCellRendererComponent(this.fTable, object, false, false, n, n4);
                        if (db.on() && component instanceof JLabel) {
                            string = this.getLabelString((JLabel)component);
                            db.println(string);
                        }
                    }
                }
                if (component != null) {
                    string = component instanceof JLabel ? this.getLabelString((JLabel)component) : (component instanceof JTextArea ? ((JTextArea)component).getText() : (component instanceof JCheckBox ? (((JCheckBox)component).isSelected() ? this.fTrueString : this.fFalseString) : component.toString()));
                }
            }
            if (string == null) {
                string = object.toString();
            }
        }
        if (string == null) {
            string = this.fDefaultString;
        } else {
            String string2 = string;
            if (string2.trim().length() == 0) {
                string = this.fDefaultString;
            }
            if (string.length() == 0) {
                string = this.fDefaultString;
            }
        }
        return string;
    }

    public String getLabelString(JLabel jLabel) {
        Icon icon;
        String string = jLabel.getText();
        if ((string == null || string.length() == 0) && (icon = jLabel.getIcon()) != null && icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            string = imageIcon.getDescription();
        }
        return string;
    }

    public Class getColumnClass(int n) {
        return this.fTableModel.getValueAt(0, n).getClass();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

