/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.Preferences;
import cerent.util.gui.WindowsShortcutFileSystemView;
import java.awt.Container;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class UFileChooser
extends JFileChooser {
    private static final String JAVA = "java";
    private static final String VERSION_1_4 = "1.4";
    private static final boolean wrapFileSystemView = File.separator.equals("\\") && UFileChooser.runningJava14x();

    private static boolean runningJava14x() {
        Preferences preferences = Preferences.instance();
        String string = preferences.getProperty(JAVA, "specification.version", null);
        if (string == null) {
            string = VERSION_1_4;
        }
        return string.startsWith(VERSION_1_4);
    }

    private static FileSystemView wrapFileSystemView(FileSystemView fileSystemView) {
        if (fileSystemView == null) {
            fileSystemView = FileSystemView.getFileSystemView();
        }
        if (wrapFileSystemView) {
            fileSystemView = new WindowsShortcutFileSystemView(fileSystemView);
        }
        return fileSystemView;
    }

    public UFileChooser() {
        super(UFileChooser.wrapFileSystemView(null));
    }

    public UFileChooser(File file) {
        super(file, UFileChooser.wrapFileSystemView(null));
    }

    public UFileChooser(File file, FileSystemView fileSystemView) {
        super(file, UFileChooser.wrapFileSystemView(fileSystemView));
    }

    public UFileChooser(FileSystemView fileSystemView) {
        super(UFileChooser.wrapFileSystemView(fileSystemView));
    }

    public UFileChooser(String string) {
        super(string, UFileChooser.wrapFileSystemView(null));
    }

    public UFileChooser(String string, FileSystemView fileSystemView) {
        super(string, UFileChooser.wrapFileSystemView(fileSystemView));
    }

    public void dispose() {
        try {
            JDialog jDialog;
            Container container = this.getTopLevelAncestor();
            if (container instanceof JDialog && (jDialog = (JDialog)container) != null) {
                jDialog.getContentPane().removeAll();
                jDialog.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (wrapFileSystemView && WindowsShortcutFileSystemView.isDirLink(file)) {
            file = WindowsShortcutFileSystemView.getLinkTarget(file);
        }
        super.setCurrentDirectory(file);
    }
}

