/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.orb;

import cerent.util.orb.IIorRewriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class IorRewriter
implements IIorRewriter {
    public String rewriteIor(String string, String string2) throws IOException {
        IOR iOR = this.stringToIor(string);
        for (int i = 0; i < iOR.profiles.length; ++i) {
            TaggedProfile taggedProfile;
            iOR.profiles[i] = taggedProfile = this.patchProfile(iOR.profiles[i], string2);
        }
        return this.iorToString(iOR);
    }

    private IOR stringToIor(String string) {
        String string2 = string.toLowerCase();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = string2.length();
        int n2 = (n - 4) / 2;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Odd number of characters within object reference");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = Character.digit(string2.charAt(i * 2 + 4), 16);
            int n4 = Character.digit(string2.charAt(i * 2 + 5), 16);
            byteArrayOutputStream.write(n3 * 16 + n4);
        }
        CDRInputStream cDRInputStream = new CDRInputStream(null, byteArrayOutputStream.toByteArray());
        cDRInputStream.openEncapsulatedArray();
        IOR iOR = IORHelper.read((InputStream)cDRInputStream);
        cDRInputStream.close();
        return iOR;
    }

    private String iorToString(IOR iOR) {
        CDROutputStream cDROutputStream = new CDROutputStream();
        cDROutputStream.beginEncapsulatedArray();
        IORHelper.write((OutputStream)cDROutputStream, (IOR)iOR);
        byte[] byArray = cDROutputStream.getBufferCopy();
        cDROutputStream.close();
        StringBuffer stringBuffer = new StringBuffer("IOR:");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Character.forDigit(byArray[i] >> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[i] & 0xF, 16));
        }
        return stringBuffer.toString();
    }

    private TaggedProfile patchProfile(TaggedProfile taggedProfile, String string) throws IOException {
        if (taggedProfile.tag == 0) {
            IIOPProfile iIOPProfile = new IIOPProfile(taggedProfile.profile_data);
            int n = iIOPProfile.getAddress().getPort();
            iIOPProfile.patchPrimaryAddress(string, n);
            TaggedProfileHolder taggedProfileHolder = new TaggedProfileHolder();
            iIOPProfile.marshal(taggedProfileHolder, null);
            return taggedProfileHolder.value;
        }
        return taggedProfile;
    }
}

