/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.orb;

import cerent.util.orb.IOngORB;
import java.util.Properties;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;

public class OngORB {
    private static final String DEFAULT_CLASS_NAME = "cerent.util.orb.CtcJacORB";
    private static IOngORB orb;
    private static String orbClassName;

    public static synchronized IOngORB init(String[] stringArray, Properties properties) {
        if (orb == null) {
            if (orbClassName == null) {
                orbClassName = OngORB.isOrbClassPropertySet() ? OngORB.getOrbClassName() : DEFAULT_CLASS_NAME;
            }
            orb = OngORB.getOrbInstance(orbClassName, stringArray, properties);
        }
        return orb;
    }

    public static synchronized IOngORB instance() {
        if (orb == null) {
            orb = OngORB.init(null, null);
        }
        return orb;
    }

    private OngORB() {
    }

    private static boolean isOrbClassPropertySet() {
        boolean bl = true;
        try {
            String string = System.getProperty("ong.orb.class");
            if (string == null || string.equals("")) {
                bl = false;
            }
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    private static String getOrbClassName() {
        return System.getProperty("ong.orb.class");
    }

    private static IOngORB getOrbInstance(String string, String[] stringArray, Properties properties) {
        try {
            Class<?> clazz = Class.forName(orbClassName);
            orb = (IOngORB)clazz.newInstance();
            orb.initialize(stringArray, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new INITIALIZE("Cannot locate the class -- " + orbClassName, 0, CompletionStatus.COMPLETED_NO);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new INITIALIZE("Cannot load the class -- " + orbClassName, 0, CompletionStatus.COMPLETED_NO);
        }
        catch (InstantiationException instantiationException) {
            throw new INITIALIZE("Cannot initialize(), threw an exception " + orbClassName, 0, CompletionStatus.COMPLETED_NO);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new INITIALIZE("Cannot initialize(), no access " + orbClassName, 0, CompletionStatus.COMPLETED_NO);
        }
        return orb;
    }
}

