/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.threadpool;

import cerent.util.KDebug;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadPool;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ThreadWorker
implements IThreadWorker,
Runnable {
    private KDebug db;
    private Thread myThread = null;
    IThreadPool parent;
    HeartBeat heartBeat;
    boolean debugBool = false;
    boolean killed = false;
    int myIndex = 0;
    private int runCount;
    private IActionClient actionClient;
    private int maxRunCount = 0;

    public ThreadWorker(IThreadPool iThreadPool, int n, KDebug kDebug) {
        this.parent = iThreadPool;
        this.db = kDebug;
        this.heartBeat = new HeartBeat();
        this.myIndex = n;
        this.myThread = new Thread((Runnable)this, "CTC ThreadWorker " + this.myIndex);
        this.myThread.start();
    }

    @Override
    public int getMyIndex() {
        return this.myIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextClient(Object object) throws Exception {
        if (object instanceof IActionClient && ThreadPool.instance().registerAC(this, (IActionClient)object)) {
            this.actionClient = (IActionClient)object;
            boolean bl = false;
            do {
                this.heartBeat.start();
                try {
                    this.actionClient.doAction();
                }
                catch (Exception exception) {
                    this.db.println(this.toString() + " Caught Exception" + exception);
                    if (!this.db.isFinerEnabled()) continue;
                    KDebug.printStackTrace((Throwable)exception);
                }
                finally {
                    this.heartBeat.stop();
                    bl = ThreadPool.instance().unregisterAC(this, this.actionClient);
                }
            } while (!this.killed && !bl);
        }
    }

    @Override
    public void run() {
        while (!this.killed) {
            this.actionClient = null;
            try {
                IActionClient iActionClient = this.parent.dequeueClient();
                if (this.killed) continue;
                this.nextClient(iActionClient);
            }
            catch (InterruptedException interruptedException) {
                this.db.println(this.toString() + " got interrupted");
                break;
            }
            catch (Exception exception) {
                this.db.println(this.toString() + " Caught Exception" + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        this.actionClient = null;
        this.db.severe(this.toString() + (this.killed ? " killed" : " interrupted"));
    }

    public String toString() {
        String string = "CTC ThreadWorker " + this.myIndex + " " + (this.actionClient == null ? "IDLE" : ((Object)this.actionClient).toString()) + " runCount=" + this.runCount;
        return string;
    }

    @Override
    public void killThread() {
        this.killed = true;
    }

    public void interrupt() {
        this.myThread.interrupt();
    }

    void setRunCount(int n) {
        this.runCount = n;
    }

    int getRunCount() {
        return this.runCount;
    }

    private class HeartBeat
    implements ActionListener {
        boolean gotReply = false;
        Timer timer = new Timer(600000, this);

        private HeartBeat() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.gotReply) {
                ThreadWorker.this.db.severe(ThreadWorker.this.toString() + " HeartBeat::action client timed out");
            }
            this.gotReply = false;
            this.timer.stop();
        }

        public void start() {
            this.gotReply = false;
            this.timer.start();
        }

        public void stop() {
            this.gotReply = true;
            this.timer.stop();
        }

        private void dispose() {
            this.timer.stop();
        }
    }
}

