/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import com.cisco.crs.model.PlimPortId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CLILmpIdAction
extends CLIAction {
    private static String cmdSeqGetId = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Exec>show mpls lmp interface _Parameter_ _Parameter2_</Exec></CLI></Request>";
    private KDebug db;

    public CLILmpIdAction(ITTYSession iTTYSession, KDebug kDebug) {
        this(iTTYSession.getHostname(), kDebug);
    }

    public CLILmpIdAction(String string, KDebug kDebug) {
        super(string);
        this.db = kDebug;
        this.cliCmd = new CLICmdRsp[1];
    }

    public int get(PlimPortId.PlimType plimType, String string) {
        Object object;
        Document document;
        block15: {
            this.cliCmd[0] = new CLICmdRsp(cmdSeqGetId.replace("_Parameter_", plimType.toString()).replace("_Parameter2_", string), true);
            try {
                if (super.performAction(this.cliCmd[0])) {
                    if (this.db.on()) {
                        this.db.println("failed to send XML command");
                    }
                    return -1;
                }
            }
            catch (IOException iOException) {
                return -1;
            }
            catch (TTYException tTYException) {
                return -1;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = null;
            try {
                object = documentBuilderFactory.newDocumentBuilder();
                document = ((DocumentBuilder)object).parse(new ByteArrayInputStream(this.cliCmd[0].getResponse().getBytes()));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (this.db.on) {
                    this.db.println("ParseConfigurationException while parsing Lmp ID");
                }
            }
            catch (SAXException sAXException) {
                if (this.db.on) {
                    this.db.println("SAXException while parsing Lmp ID");
                }
            }
            catch (IOException iOException) {
                if (!this.db.on) break block15;
                this.db.println("IOException while parsing Lmp ID");
            }
        }
        if (document == null) {
            if (this.db.on) {
                this.db.println("Error while parsing Lmp ID: dom==null");
            }
            return -1;
        }
        object = document.getDocumentElement();
        NodeList nodeList = object.getElementsByTagName("Exec");
        if (nodeList == null || nodeList.getLength() == 0) {
            if (this.db.on) {
                this.db.println("Error while parsing Lmp ID: <Exec> not found");
            }
            return -1;
        }
        String string2 = ((Element)nodeList.item(0)).getTextContent();
        String string3 = string2.substring(string2.indexOf("Dec =") + 5);
        string3 = string3.substring(0, string3.indexOf("\n")).trim();
        return Integer.parseInt(string3);
    }
}

