/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CLIShowVersionAction
extends CLIAction {
    private static String COMMAND = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Exec>show version</Exec></CLI></Request>";
    private KDebug db;

    public CLIShowVersionAction(ITTYSession iTTYSession, KDebug kDebug) {
        this(iTTYSession.getHostname(), kDebug);
    }

    public CLIShowVersionAction(String string, KDebug kDebug) {
        super(string);
        this.db = kDebug;
        this.cliCmd = new CLICmdRsp[1];
    }

    public PlatformInfo get() {
        this.cliCmd[0] = new CLICmdRsp(COMMAND, true);
        try {
            if (super.performAction(this.cliCmd[0])) {
                if (this.db.on()) {
                    this.db.println("failed to send XML command");
                }
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (TTYException tTYException) {
            return null;
        }
        return this.parseResponse();
    }

    private PlatformInfo parseResponse() {
        Object object;
        Object object2;
        Document document;
        block14: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = null;
            try {
                object2 = documentBuilderFactory.newDocumentBuilder();
                object = this.cliCmd[0].getResponse();
                if (object == null) {
                    if (this.db.on) {
                        this.db.println("response == null");
                    }
                    return null;
                }
                document = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (this.db.on) {
                    this.db.println("ParseConfigurationException while parsing ARP");
                }
            }
            catch (SAXException sAXException) {
                if (this.db.on) {
                    this.db.println("SAXException while parsing ARP");
                }
            }
            catch (IOException iOException) {
                if (!this.db.on) break block14;
                this.db.println("IOException while parsing ARP");
            }
        }
        if (document == null) {
            if (this.db.on) {
                this.db.println("Error while parsing ARP: dom==null");
            }
            return null;
        }
        object2 = document.getDocumentElement();
        object = object2.getElementsByTagName("Exec");
        if (object == null || object.getLength() == 0) {
            if (this.db.on) {
                this.db.println("Error while parsing ARP: <Exec> not found");
            }
            return null;
        }
        String string = ((Element)object.item(0)).getTextContent();
        String string2 = "";
        String string3 = "";
        int n = string.indexOf("cisco CRS");
        if (n != -1) {
            string2 = "crs";
        }
        if ((n = string.indexOf(" Version ")) != -1) {
            int n2 = " Version ".length();
            string3 = string.substring(n + n2, n + n2 + 5);
            string3 = "0" + string3.substring(0, 3) + string3.substring(4, 5);
        }
        PlatformInfo platformInfo = new PlatformInfo(string2, string3);
        return platformInfo;
    }

    public static class PlatformInfo {
        private String neType;
        private String swVersion;

        PlatformInfo(String string, String string2) {
            this.neType = string;
            this.swVersion = string2;
        }

        public String getNeType() {
            return this.neType;
        }

        public String getVersion() {
            return this.swVersion;
        }

        public String toString() {
            return "Ne Type=" + this.neType + ", S/W Version=" + this.swVersion;
        }
    }
}

