/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.IFvDebug;
import cerent.util.view.fv.ILinkDefine;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.OpticalPatchCord;
import ilog.views.IlvGrapher;
import ilog.views.IlvLinkImage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.omg.CORBA.UserException;

public abstract class ViewCircuitPathElement {
    public static final boolean CIRCUIT_SELECTED = true;
    public static final boolean CIRCUIT_NOT_SELECTED = false;
    protected IViewLink link;
    protected IFvInterfaceModel inInt;
    protected IFvInterfaceModel outInt;
    protected IFvInterfaceModel trkConnectedInt;
    protected IFvCardModel trkConnectedCard;
    private String noSelectedToolTipStr;
    private boolean isActiveLink;
    protected IFvNodeModel node;
    protected IFvPortModel portIn;
    protected IFvCardModel cardIn;
    protected IFvCardModel cardOut;
    protected IFvPortModel portOut;
    protected HashMap<String, String> tableCell;
    protected int wavelength;
    private static IFvDebug db = FunctDebug.instance().addChild("ViewCircuitPathElement", "Once for All the circuit");
    private ViewDomainGrapher workingSideGrapher;
    protected int sequenceInNetwork;

    private ViewCircuitPathElement() {
    }

    public ViewCircuitPathElement(IFvNodeModel iFvNodeModel) {
        this.node = iFvNodeModel;
    }

    public ViewCircuitPathElement(IViewLink iViewLink, IFvNodeModel iFvNodeModel, boolean bl, ViewDomainGrapher viewDomainGrapher) {
        this(iFvNodeModel);
        this.isActiveLink = bl;
        this.link = iViewLink;
        this.workingSideGrapher = viewDomainGrapher;
    }

    public ViewCircuitPathElement(IViewLink iViewLink, Integer n, Integer n2, IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2, IFvNodeModel iFvNodeModel, boolean bl, ViewDomainGrapher viewDomainGrapher) {
        block19: {
            this(iViewLink, iFvNodeModel, bl, viewDomainGrapher);
            this.inInt = iFvInterfaceModel;
            this.outInt = iFvInterfaceModel2;
            try {
                int n3;
                OpticalPatchCord[] opticalPatchCordArray;
                if (n != null) {
                    this.portIn = (IFvPortModel)iFvNodeModel.getEntityModelByIndex(n);
                    this.cardIn = this.portIn.getCardModel();
                    if (!this.cardIn.isPassiveModule()) {
                        this.inInt = this.portIn.getIFvInterfaceModel();
                    }
                }
                if (n2 != null) {
                    this.portOut = (IFvPortModel)iFvNodeModel.getEntityModelByIndex(n2);
                    this.cardOut = this.portOut.getCardModel();
                    if (!this.cardOut.isPassiveModule()) {
                        this.outInt = this.portOut.getIFvInterfaceModel();
                    }
                }
                if (this.inInt instanceof IFvDwdmTrkLineModel) {
                    try {
                        opticalPatchCordArray = ((IFvCardModel)this.inInt.getModuleModel()).getAllOpticalPatchCords();
                        for (n3 = 0; n3 < opticalPatchCordArray.length; ++n3) {
                            if (n == opticalPatchCordArray[n3].from && n2 != opticalPatchCordArray[n3].to) {
                                this.trkConnectedCard = ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].to)).getCardModel();
                                if (this.outInt != null && !this.trkConnectedCard.isPassiveModule()) {
                                    this.trkConnectedInt = ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].to)).getIFvInterfaceModel();
                                    continue;
                                }
                                this.trkConnectedInt = null;
                                continue;
                            }
                            if (n != opticalPatchCordArray[n3].to || n2 == opticalPatchCordArray[n3].from) continue;
                            this.trkConnectedCard = ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].from)).getCardModel();
                            this.trkConnectedInt = this.outInt != null && !this.trkConnectedCard.isPassiveModule() ? ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].from)).getIFvInterfaceModel() : null;
                        }
                    }
                    catch (FeatureUnsupported featureUnsupported) {
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        // empty catch block
                    }
                }
                if (!(this.outInt instanceof IFvDwdmTrkLineModel)) break block19;
                try {
                    opticalPatchCordArray = ((IFvCardModel)this.outInt.getModuleModel()).getAllOpticalPatchCords();
                    for (n3 = 0; n3 < opticalPatchCordArray.length; ++n3) {
                        if (n2 == opticalPatchCordArray[n3].from && n != opticalPatchCordArray[n3].to) {
                            this.trkConnectedCard = ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].to)).getCardModel();
                            if (this.inInt != null && !this.trkConnectedCard.isPassiveModule()) {
                                this.trkConnectedInt = ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].to)).getIFvInterfaceModel();
                                continue;
                            }
                            this.trkConnectedInt = null;
                            continue;
                        }
                        if (n2 != opticalPatchCordArray[n3].to || n == opticalPatchCordArray[n3].from) continue;
                        this.trkConnectedCard = ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].from)).getCardModel();
                        this.trkConnectedInt = this.inInt != null && !this.trkConnectedCard.isPassiveModule() ? ((IFvPortModel)iFvNodeModel.getEntityModelByIndex(opticalPatchCordArray[n3].from)).getIFvInterfaceModel() : null;
                    }
                }
                catch (FeatureUnsupported featureUnsupported) {
                    FunctDebug.printStackTrace(featureUnsupported);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    FunctDebug.printStackTrace(abstractCmsNoSuchEntityException);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace(noSuchInterface);
            }
        }
    }

    public IFvNodeModel getNode() {
        return this.node;
    }

    public IFvPortModel getPortIn() {
        return this.portIn;
    }

    public IFvPortModel getPortOut() {
        return this.portOut;
    }

    public HashMap<String, String> getTableCell() {
        return this.tableCell;
    }

    private void setCardInCiruit(boolean bl) throws AbstractCmsNoSuchEntityException {
        if (this.inInt != null) {
            this.inInt.getThePortModel().getCardModel().setInFVCircuit(bl);
        }
        if (this.outInt != null) {
            this.outInt.getThePortModel().getCardModel().setInFVCircuit(bl);
        }
        if (this.trkConnectedCard != null) {
            this.trkConnectedCard.setInFVCircuit(bl);
        }
    }

    public List<IFvCardModel> getCardInCiruit() throws AbstractCmsNoSuchEntityException {
        ArrayList<IFvCardModel> arrayList = new ArrayList<IFvCardModel>();
        if (this.inInt != null) {
            arrayList.add(this.inInt.getThePortModel().getCardModel());
        }
        if (this.outInt != null) {
            arrayList.add(this.outInt.getThePortModel().getCardModel());
        }
        if (this.trkConnectedCard != null) {
            arrayList.add(this.trkConnectedCard);
        }
        return arrayList;
    }

    protected boolean isActive(IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2, IlvGrapher ilvGrapher) {
        return true;
    }

    public IViewLink getLink() {
        return this.link;
    }

    public void storeCurrentToolTip(String string) {
        this.noSelectedToolTipStr = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.link != null) {
            ViewInternalLink viewInternalLink = this.link.getLinkModel();
            if (viewInternalLink != null) {
                stringBuilder.append("link: " + viewInternalLink + "; ");
            } else {
                stringBuilder.append("pure link; ");
                if (this.portOut != null) {
                    stringBuilder.append("[" + Integer.toHexString(this.portOut.getIndex()) + " -> ");
                }
                if (this.portIn != null) {
                    stringBuilder.append(Integer.toHexString(this.portIn.getIndex()) + "]; ");
                }
            }
        } else {
            stringBuilder.append("sidePort: ");
        }
        if (this.portIn != null) {
            stringBuilder.append("out : " + this.portIn.getPortString() + "; ");
        }
        if (this.portIn != null) {
            stringBuilder.append("in : " + this.portIn.getPortString() + "; ");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof ViewCircuitPathElement) {
            ViewCircuitPathElement viewCircuitPathElement = (ViewCircuitPathElement)object;
            boolean bl3 = this.link != null ? this.link.equals(viewCircuitPathElement.link) : (bl = viewCircuitPathElement.link == null);
            bl &= this.inInt != null ? this.inInt.equals(viewCircuitPathElement.inInt) : viewCircuitPathElement.inInt == null;
            bl &= this.outInt != null ? this.outInt.equals(viewCircuitPathElement.outInt) : viewCircuitPathElement.outInt == null;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.link == null ? 0 : this.link.hashCode();
        n = 13 * n + (this.inInt == null ? 0 : this.inInt.hashCode());
        n = 13 * n + (this.outInt == null ? 0 : this.outInt.hashCode());
        return n;
    }

    private boolean isActive() {
        if (this.workingSideGrapher == null) {
            return true;
        }
        return this.isActive(this.inInt, this.outInt, this.link.getLinkOwner()) && this.workingSideGrapher.isSideDomainInActivePath();
    }

    public IFvInterfaceModel getPsmInterface() {
        IFvInterfaceModel iFvInterfaceModel = null;
        IFvInterfaceModel iFvInterfaceModel2 = null;
        try {
            if (this.outInt != null) {
                if (this.outInt.getModuleModel() instanceof IFvPSMModuleModel) {
                    iFvInterfaceModel = this.outInt;
                }
            } else if (this.inInt != null) {
                if (this.inInt.getModuleModel() instanceof IFvPSMModuleModel) {
                    iFvInterfaceModel = this.inInt;
                }
            } else {
                return null;
            }
            if (iFvInterfaceModel != null) {
                iFvInterfaceModel2 = ((IFvPortModel)iFvInterfaceModel.getModuleModel().getChildren().get(0)).getIFvInterfaceModel();
            }
            return iFvInterfaceModel2;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
    }

    public boolean isActiveLink() {
        return this.isActiveLink;
    }

    public void setDebugInfo(boolean bl) {
        Color color = ILinkDefine.SELECT_INTER_LNK_COLOR;
        int n = 8;
        String string = "";
        if (bl) {
            color = this.isActive() ? ILinkDefine.SELECT_INTER_LNK_COLOR : ILinkDefine.SELECT_INTER_STB_LNK_COLOR;
            this.storeCurrentToolTip(((IlvLinkImage)this.link).getToolTipText());
            string = this.link.setPowerInformation(this.inInt, this.outInt, this.trkConnectedInt, this.wavelength);
            n = 8;
        } else {
            color = new Color(0);
            string = this.noSelectedToolTipStr;
            n = 2;
            this.setBalloonVisible(false);
        }
        ((IlvLinkImage)this.link).setToolTipText(string);
        ((IlvLinkImage)this.link).setForeground(color);
        ((IlvLinkImage)this.link).setLineWidth((float)n);
        this.link.setBalloonUnderCircuit(bl);
        try {
            this.setCardInCiruit(bl);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            FunctDebug.printStackTrace(abstractCmsNoSuchEntityException);
        }
    }

    public static String getPowerTooltipStr(IFvInterfaceModel iFvInterfaceModel, StringBuffer stringBuffer, int n) {
        String string = ViewCircuitPathElement.getPower(iFvInterfaceModel, n);
        if (string.equals("-100000.0")) {
            string = "N/A";
        }
        stringBuffer.append(ViewCircuitPathElement.getPortName(iFvInterfaceModel, iFvInterfaceModel) + string + "</B>");
        return string;
    }

    public static String getPower(IFvInterfaceModel iFvInterfaceModel, int n) {
        String string = "N/A";
        if (iFvInterfaceModel instanceof IFvOpticsLineModel) {
            try {
                int n2 = ((IFvOpticsLineModel)iFvInterfaceModel).getPerChannelPower(new int[]{iFvInterfaceModel.getIndex()}, n)[0].getPerChannelPower();
                string = ViewCircuitPathElement.convertPwrToString(n2);
                try {
                    if (db.on()) {
                        db.println("The interface [" + iFvInterfaceModel.getIndex() + "] " + iFvInterfaceModel.getThePortModel().getPortString() + " has the power = " + string);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("The interface " + iFvInterfaceModel.getIndex() + " has the power = " + string);
                }
            }
            catch (UserException userException) {
                return "N/A";
            }
        }
        return string;
    }

    public static String getPortName(IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2) {
        String string = "Trunk = <B>";
        if (iFvInterfaceModel2 instanceof IFvOpticsLineModel) {
            try {
                string = ((IFvOpticsLineModel)iFvInterfaceModel2).getOptPortTypeString() + " = <B>";
            }
            catch (WrongInterfaceType wrongInterfaceType) {
            }
            catch (NoSuchInterface noSuchInterface) {
            }
            catch (RuntimeException runtimeException) {}
        } else if (iFvInterfaceModel instanceof IFvDwdmTrkLineModel) {
            try {
                string = iFvInterfaceModel.getThePortModel().getEqLabel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                FunctDebug.printStackTrace(abstractCmsNoSuchEntityException);
            }
        }
        return string;
    }

    public static String convertPwrToString(int n) {
        return String.valueOf((double)n / 10.0);
    }

    public abstract void setBalloonVisible(boolean var1);

    public void setLambda(int n) {
        this.wavelength = n;
    }

    public void addNetworkSequence(int n) {
        this.sequenceInNetwork = n;
    }

    public int getSequenceInNetwork() {
        return this.sequenceInNetwork;
    }

    public void printDebug(IFvDebug iFvDebug) {
        if (iFvDebug == null) {
            return;
        }
        iFvDebug.println("in network position [" + this.sequenceInNetwork + "] " + this.toString());
    }
}

