/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.print.IlvManagerPrintableDocument;
import ilog.views.print.IlvManagerPrintingController;
import ilog.views.print.IlvPrintAreaInteractor;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.util.image.PNGImageEncoder;
import ilog.views.util.print.IlvPrintableDocument;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ViewPrintingHelper {
    private IlvManagerView managerView;
    private IlvManagerPrintingController printingController;

    public ViewPrintingHelper(Component component) {
        this.managerView = component instanceof IlvJScrollManagerView ? ((IlvJScrollManagerView)component).getView() : (component instanceof IlvManagerView ? (IlvManagerView)component : null);
        if (this.managerView != null) {
            this.printingController = new IlvManagerPrintingController(this.managerView);
            ((IlvManagerPrintableDocument)this.printingController.getDocument()).getMinimumZoomLevel();
            ((IlvManagerPrintableDocument)this.printingController.getDocument()).getMaximumZoomLevel();
            ((IlvManagerPrintableDocument)this.printingController.getDocument()).setZoomLevelModificationEnabled(true);
        }
    }

    public void destroy() {
        this.managerView = null;
        this.printingController = null;
    }

    protected IlvManagerPrintingController getController() {
        return this.printingController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> exportToBitmap(File file) throws PrinterException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.printingController == null) {
            return arrayList;
        }
        String string = file.getPath();
        Graphics2D graphics2D = null;
        IlvPrintableDocument ilvPrintableDocument = this.printingController.getDocument();
        int n = ilvPrintableDocument.getNumberOfPages();
        boolean bl = string.endsWith(".jpg");
        for (int i = 0; i < n; ++i) {
            JPEGImageEncoder jPEGImageEncoder;
            BufferedImage bufferedImage = new BufferedImage((int)ilvPrintableDocument.getPageFormat(i).getWidth(), (int)ilvPrintableDocument.getPageFormat(i).getHeight(), bl ? 1 : 2);
            try {
                graphics2D = bufferedImage.createGraphics();
                if (bl) {
                    graphics2D.setColor(this.managerView.getBackground());
                    graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
                ilvPrintableDocument.print((Graphics)graphics2D, ilvPrintableDocument.getPageFormat(i), i);
            }
            finally {
                graphics2D.dispose();
            }
            String string2 = string;
            if (n > 1) {
                int n2 = string2.lastIndexOf(46);
                string2 = n2 > 0 ? string2.substring(0, n2) + i + string2.substring(n2) : string2 + i;
            }
            if (!bl && string2.lastIndexOf(46) < 0) {
                string2 = string2 + ".png";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            arrayList.add(string2);
            if (bl) {
                jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
            } else {
                jPEGImageEncoder = new PNGImageEncoder((OutputStream)fileOutputStream, null);
                jPEGImageEncoder.encode((RenderedImage)bufferedImage);
            }
            ((OutputStream)fileOutputStream).close();
        }
        return arrayList;
    }

    public void print(boolean bl) throws PrinterException {
        this.getController().print(bl);
    }

    public void pageSetup(IlvManagerView ilvManagerView) {
        this.getController().setupDialog(ViewPrintingHelper.getWindow(ilvManagerView), true, true);
    }

    public void printPreview() {
        if (this.printingController == null) {
            return;
        }
        this.getController().printPreview(ViewPrintingHelper.getWindow(this.managerView));
    }

    public void setPrintArea() {
        if (this.printingController == null) {
            return;
        }
        IlvPrintAreaInteractor ilvPrintAreaInteractor = new IlvPrintAreaInteractor(this.getController());
        ilvPrintAreaInteractor.setLineStyle(new float[]{8.0f, 1.0f});
        this.managerView.pushInteractor((IlvManagerViewInteractor)ilvPrintAreaInteractor);
    }

    public void clearPrintArea() {
        ((IlvManagerPrintableDocument)this.getController().getDocument()).setPrintArea(null);
    }

    private static Window getWindow(IlvManagerView ilvManagerView) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)ilvManagerView);
    }
}

