/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.newSwing.framework;

import com.cisco.newSwing.framework.CTCDockableFrame;
import com.cisco.newSwing.framework.ICTCDockableFrame;
import com.cisco.newSwing.framework.ICTCDockingManager;
import com.jidesoft.docking.DefaultDockingManager;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.RootPaneContainer;

public class CTCDockingManager
implements ICTCDockingManager {
    private DefaultDockingManager actualManager;
    private final String defaultPcFileName = "CTCDock.ini";
    private final String defaultUnixFileName = ".ctcdockrc";
    private final String defaultFilePath = System.getProperty("user.home");
    private final String separator = System.getProperty("file.separator");
    private String profileName;
    private HashMap<String, ICTCDockableFrame> allFrame;

    public CTCDockingManager(RootPaneContainer rootPaneContainer, Container container, String string) {
        this.actualManager = new DefaultDockingManager(rootPaneContainer, container);
        this.allFrame = new HashMap();
        this.profileName = string;
    }

    public DefaultDockingManager getActualManager() {
        return this.actualManager;
    }

    @Override
    public void loadLayoutData() {
        this.actualManager.setProfileKey(this.profileName);
        this.actualManager.loadLayoutDataFromFile(this.getDefaultCtcPrefsFileName());
    }

    private String getDefaultCtcPrefsFileName() {
        String string = this.separator.equals("/") ? this.defaultFilePath + this.separator + ".ctcdockrc" : this.defaultFilePath + this.separator + "CTCDock.ini";
        return string;
    }

    @Override
    public void setFrameVisible(ICTCDockableFrame iCTCDockableFrame, boolean bl) {
        if (bl) {
            this.actualManager.showFrame(iCTCDockableFrame.getName());
        } else {
            this.actualManager.hideFrame(iCTCDockableFrame.getName());
        }
    }

    @Override
    public void setFrameVisible(String string, boolean bl) {
        this.setFrameVisible(this.getFrame(string), bl);
    }

    @Override
    public void defaultFramePosition() {
        this.actualManager.resetToDefault();
    }

    @Override
    public void resetFrameToDefaultPosition() {
        this.actualManager.resetToDefault();
    }

    @Override
    public void addFrame(ICTCDockableFrame iCTCDockableFrame) {
        try {
            ((CTCDockableFrame)iCTCDockableFrame).addTomanager(this.actualManager);
            this.allFrame.put(iCTCDockableFrame.getName(), iCTCDockableFrame);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addMainFrame(Component component, String string) {
        this.actualManager.getWorkspace().add(component, (Object)string);
    }

    @Override
    public void initFramework() {
        this.actualManager.beginLoadLayoutData();
        this.actualManager.setOutlineMode(1);
        this.actualManager.setInitSplitPriority(0);
        this.actualManager.setShowWorkspace(true);
        this.actualManager.getWorkspace().setAcceptDockableFrame(true);
        this.loadLayoutData();
    }

    @Override
    public ICTCDockableFrame getFrame(String string) {
        return this.allFrame.get(string);
    }

    @Override
    public void dispose() {
        this.actualManager.saveLayoutDataToFile(this.getDefaultCtcPrefsFileName());
        this.actualManager.dispose();
        for (ICTCDockableFrame iCTCDockableFrame : this.allFrame.values()) {
            iCTCDockableFrame.dispose();
        }
        this.allFrame.clear();
    }
}

