/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSlotPolicy {
    protected final String DSN_GROUP;
    protected final String ETH_GROUP;
    protected final String OCN_GROUP;
    protected final String WDM_GROUP;
    protected final String OADM_GROUP;
    protected final String OSC_GROUP;
    protected final String AMPLI_GROUP;
    protected final String MD_GROUP;
    protected static final String TOP_LEVEL = null;
    protected static final String TOP_LEVEL_F = "TOP_LEVEL";
    protected Map slotMap = new HashMap();
    protected final String DWDM_FAMILY;
    private static final SDebug db = new SDebug("AbstractSlotPolicy");

    public AbstractSlotPolicy(NodeModelDelegate nodeModelDelegate) {
        TDMTerminology tDMTerminology = nodeModelDelegate.getTDMTerminology();
        this.DSN_GROUP = tDMTerminology.getTermForAddCard(1);
        this.OCN_GROUP = tDMTerminology.getTermForAddCard(0);
        this.ETH_GROUP = tDMTerminology.getTermForAddCard(2);
        this.WDM_GROUP = tDMTerminology.getTermForAddCard(3);
        this.OADM_GROUP = tDMTerminology.getTermForAddCard(4);
        this.OSC_GROUP = tDMTerminology.getTermForAddCard(5);
        this.AMPLI_GROUP = tDMTerminology.getTermForAddCard(6);
        this.MD_GROUP = tDMTerminology.getTermForAddCard(7);
        this.DWDM_FAMILY = tDMTerminology.getTermForAddFamilyCard(0);
        this.initSlotMap();
    }

    protected abstract void initSlotMap();

    public abstract Map getMapOfValidModules(SlotModel var1);

    public abstract List getListOfValidUpgradeType(SlotModel var1, int var2);

    public abstract List getListOfValidChangeType(SlotModel var1, eEqType var2);

    public abstract boolean needDs1Ifs(int var1);

    public boolean needInterfaceTypeBasedDs123Ifs(int n) {
        return false;
    }

    protected void addCardToMap(String string, eEqType eEqType2) {
        if (string != TOP_LEVEL) {
            HashSet<eEqType> hashSet = this.getSetForMenu(string, this.slotMap);
            if (hashSet == null) {
                hashSet = new HashSet<eEqType>();
                this.slotMap.put(string, hashSet);
            }
            hashSet.add(eEqType2);
        } else {
            this.slotMap.put(eEqType2, null);
        }
    }

    protected void addCardToMap(String string, String string2, eEqType eEqType2) {
        HashMap hashMap = this.getMenuFamily(string, this.slotMap);
        if (hashMap == null) {
            if (db.on()) {
                db.println("Error on building menu ( family  " + string + "  not found ) ");
            }
        } else {
            HashSet<eEqType> hashSet = (HashSet<eEqType>)hashMap.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<eEqType>();
                hashMap.put(string2, hashSet);
            }
            hashSet.add(eEqType2);
            this.slotMap.put(string, hashMap);
        }
    }

    protected void addCard(String string, String string2, eEqType eEqType2, Map map) {
        HashMap hashMap = this.getMenuFamily(string, map);
        if (hashMap == null) {
            if (db.on()) {
                db.println("Error on building menu ( family  " + string + "  not found ) ");
            }
        } else {
            HashSet<eEqType> hashSet = (HashSet<eEqType>)hashMap.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<eEqType>();
                hashMap.put(string2, hashSet);
            }
            hashSet.add(eEqType2);
            map.put(string, hashMap);
        }
    }

    protected HashMap getMenuFamily(String string, Map map) {
        HashMap hashMap = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string2 = (String)k;
            Object v = map.get(string2);
            if (!string2.equals(string)) continue;
            hashMap = (HashMap)v;
        }
        return hashMap;
    }

    protected HashMap getFamily(String string, Map map) {
        HashMap hashMap = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string2 = (String)k;
            Object v = map.get(string2);
            if (!string2.equals(string)) continue;
            hashMap = (HashMap)v;
        }
        return hashMap;
    }

    protected void ShowMap(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof String) {
                String string = (String)k;
                Object v = map.get(string);
                if (!db.on()) continue;
                db.println("KEY = " + string + "   value = " + v);
                continue;
            }
            if (!db.on()) continue;
            db.println("KEY = " + k);
        }
    }

    protected void addMenuToMap(String string, String string2) {
        HashMap hashMap = this.getMenuFamily(string, this.slotMap);
        if (hashMap == null) {
            HashMap hashMap2 = new HashMap();
            hashMap2.put(string2, new HashSet());
            this.slotMap.put(string, hashMap2);
        }
    }

    protected void addFamily(String string, String string2, Map map) {
        HashMap hashMap = this.getFamily(string, map);
        if (hashMap == null) {
            HashMap hashMap2 = new HashMap();
            hashMap2.put(string2, new HashSet());
            map.put(string, hashMap2);
        }
    }

    protected Set getSetForMenu(String string, Map map) {
        Set set = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) continue;
            String string2 = (String)k;
            Object v = map.get(string2);
            if (!string2.equals(string)) continue;
            set = (Set)v;
        }
        return set;
    }

    protected String getFamilyMenu(String string, Map map) {
        String string2 = null;
        Object var4_4 = null;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            Object v;
            Object k = iterator.next();
            if (!(k instanceof String) || !((v = map.get(string3 = (String)k)) instanceof HashMap)) continue;
            Map map2 = (Map)v;
            Iterator iterator2 = map2.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k2 = iterator2.next();
                if (!(k2 instanceof String)) continue;
                String string4 = (String)k2;
                Object v2 = map.get(string4);
                if (!string4.equals(string)) continue;
                var4_4 = k2;
                string2 = string3;
            }
            if (var4_4 == null) continue;
            map2.remove(var4_4);
            var4_4 = null;
        }
        return string2;
    }

    protected boolean isLowSpeedSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 14: 
            case 16: 
            case 17: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected boolean isLowSpeedProtectSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 3: 
            case 15: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected boolean isHighSpeedSlot(int n) {
        boolean bl = false;
        switch (n) {
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected boolean hasEqType(SlotModel slotModel, eEqType eEqType2) {
        boolean bl = false;
        List list = slotModel.getNodeModel().getChassis().getDescendantsOfClassType(1);
        EntityModel entityModel = (EntityModel)list.get(0);
        return entityModel != null && entityModel.getDescendantsOfType(eEqType2).size() != 0;
    }

    protected boolean hasOc48As(SlotModel slotModel) {
        boolean bl = false;
        List list = slotModel.getNodeModel().getChassis().getDescendantsOfClassType(1);
        EntityModel entityModel = (EntityModel)list.get(0);
        Iterator iterator = entityModel.getDescendantsOfType(eEqType.OC48_LINE_CARD).iterator();
        while (iterator.hasNext()) {
            ModuleModel moduleModel = (ModuleModel)iterator.next();
            if (!this.isLowSpeedSlot(moduleModel.getSlot()) && !this.isLowSpeedProtectSlot(moduleModel.getSlot())) continue;
            bl = true;
        }
        return bl;
    }

    protected void addToChangeTypeList(Map map, eEqType eEqType2, eEqType eEqType3, List list) {
        if (eEqType2 != eEqType3 && this.eqTypeInMap(map, eEqType2)) {
            list.add(eEqType2);
        }
    }

    protected boolean eqTypeInMap(Map map, eEqType eEqType2) {
        boolean bl = false;
        Iterator iterator = map.values().iterator();
        while (!bl && iterator.hasNext()) {
            Object object;
            Object v = iterator.next();
            if (v instanceof HashMap) {
                object = (Map)v;
                Iterator iterator2 = object.values().iterator();
                while (iterator2.hasNext()) {
                    Object v2 = iterator2.next();
                    Set set = (Set)v2;
                    if (set == null || !set.contains(eEqType2)) continue;
                    bl = true;
                }
                continue;
            }
            object = (Set)v;
            if (object == null || !object.contains(eEqType2)) continue;
            bl = true;
        }
        return bl;
    }

    protected Map deepCopyMap(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (map.get(k) != null) {
                Object v = map.get(k);
                if (v instanceof HashMap) {
                    hashMap.put(k, ((HashMap)v).clone());
                    continue;
                }
                hashMap.put(k, new HashSet((Set)map.get(k)));
                continue;
            }
            hashMap.put(k, null);
        }
        return hashMap;
    }
}

