/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitId;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoLanAccess;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTerm;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.OhTerms;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public abstract class AbstractTermConnectionModel
extends Model
implements ITermConnectionModel {
    protected NodeModelDelegate nmd;
    protected OhConnectionModelsDelegate ocmd;
    protected EntityTableModel entityTable;
    protected ElementModelsDelegate elementModels;
    protected ObservableManager observableManager;
    protected HashSet terms;
    protected boolean initialized = false;
    private HashMap portToTermMap;
    static /* synthetic */ Class class$cerent$cms$model$AbstractTermConnectionModel;

    protected AbstractTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$AbstractTermConnectionModel == null ? (class$cerent$cms$model$AbstractTermConnectionModel = AbstractTermConnectionModel.class$("cerent.cms.model.AbstractTermConnectionModel")) : class$cerent$cms$model$AbstractTermConnectionModel));
        this.nmd = nodeModelDelegate;
        this.ocmd = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        this.index = 0;
        this.entityTable = EntityTableModel.getInstance(nodeModelDelegate);
        this.elementModels = ElementModelsDelegate.getInstance(nodeModelDelegate);
        this.terms = new HashSet();
        this.portToTermMap = new HashMap();
    }

    public void init() {
        super.init0();
        Observable[] observableArray = new Observable[]{this.ocmd.getOhTerms()};
        this.observableManager = new ObservableManager(this, true, observableArray);
        this.observableManager.setPassing(true);
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public String getTitle() {
        return "Create " + this.getTypeName() + " Termination";
    }

    protected abstract String getTypeName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOhTermModel getTermModel(int n) {
        if (this.db.on()) {
            this.db.println("Get TermModel for index " + n);
        }
        HashSet hashSet = this.getTerms();
        synchronized (hashSet) {
            Iterator iterator = this.getTerms().iterator();
            while (iterator.hasNext()) {
                try {
                    IOhTermModel iOhTermModel = (IOhTermModel)iterator.next();
                    if (iOhTermModel.getOpticalPortIndex() != n) continue;
                    if (this.db.on()) {
                        this.db.println("Found TermModel = " + iOhTermModel);
                    }
                    return iOhTermModel;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        return null;
    }

    public void addTermObserver(int n, Observer observer) throws NoSuchTerm {
        if (this.db.on()) {
            this.db.println("Called addTermObserver for index " + n + ": from " + observer);
        }
        IOhTermModel iOhTermModel = this.getTermModel(n);
        if (this.db.on()) {
            this.db.println("Found corresponding TermModel = " + iOhTermModel);
        }
        if (iOhTermModel == null) {
            throw new NoSuchTerm("No " + this.getTypeName() + " at port index = " + n);
        }
        this.portToTermMap.put(new Integer(n), iOhTermModel);
        iOhTermModel.addObserver(observer);
    }

    public void deleteTermObserver(int n, Observer observer) {
        if (this.db.on()) {
            this.db.println("Called deleteTermObserver for index " + n + ": from " + observer);
        }
        Integer n2 = new Integer(n);
        IOhTermModel iOhTermModel = (IOhTermModel)this.portToTermMap.get(n2);
        if (this.db.on()) {
            this.db.println("Find corresponding TermModel = " + iOhTermModel);
        }
        if (iOhTermModel != null) {
            iOhTermModel.deleteObserver(observer);
            this.portToTermMap.remove(n2);
        }
    }

    protected Set excludeUcpTerms(Set set) {
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (this.nmd.getUcpNodeModel().getUcpInterfaces().isUcpPortIndex(entityModel.getIndex())) continue;
            hashSet.add(entityModel);
        }
        return hashSet;
    }

    protected Set dwdmTrunkPorts(Set set) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            hashSet.add(dwdmPortModel);
        }
        return hashSet;
    }

    protected Set nonOTNPorts(Set set) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getDwdmLineModel();
            try {
                if (dwdmTrkLineModel.getOTNStatus()) continue;
                hashSet.add(dwdmPortModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return hashSet;
    }

    protected Set otnEnabledPorts(Set set) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
            if (dwdmPortModel.isClientPort()) continue;
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getDwdmLineModel();
            try {
                if (!dwdmTrkLineModel.getOTNStatus()) continue;
                hashSet.add(dwdmPortModel);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return hashSet;
    }

    protected Set dwdmPayloadPorts(Set set, int n) {
        HashSet<DwdmPortModel> hashSet = new HashSet<DwdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                DwdmPortModel dwdmPortModel = (DwdmPortModel)iterator.next();
                AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)dwdmPortModel.getInterfaceModel();
                if (abstractDwdmLineModel.getPayloadType() != n) continue;
                hashSet.add(dwdmPortModel);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return hashSet;
    }

    protected Set dwdmEtherPorts(Set set) {
        return this.dwdmPayloadPorts(set, 2);
    }

    protected Set dwdmUnframedPorts(Set set) {
        return this.dwdmPayloadPorts(set, 4);
    }

    public abstract IEntityModel[] getTermCandidates();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnectionModel[] getTermModels() {
        IConnectionModel[] iConnectionModelArray;
        HashSet hashSet = this.getTerms();
        synchronized (hashSet) {
            if (this.db.on()) {
                this.db.println("dcc/gccterms: " + this.getTerms().size() + "(size), " + this.getTerms());
            }
            iConnectionModelArray = this.getTerms().toArray(new IConnectionModel[0]);
        }
        return iConnectionModelArray;
    }

    protected abstract OhChannelType getChannelType(Object var1);

    public void createTermination(IEntityModel iEntityModel, boolean bl) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections {
        this.createTermination(iEntityModel, new Object[]{new Boolean(bl), Boolean.FALSE});
    }

    public void createTermination(IEntityModel iEntityModel, Object object) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections {
        OhTermModel ohTermModel = (OhTermModel)this.ocmd.createOverheadTerm(new CircuitId(-1, -1), new OhTerm(new OhChannel(iEntityModel.getEntityIndex(), this.getChannelType(object).getIndex()), -1));
        ohTermModel.setOspfEnable(this.getOspfEnable(object));
        ohTermModel.setFarEndIsForeign(this.getFarEndIsForeign(object));
        this.addModels();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    protected boolean getOspfEnable(Object object) {
        try {
            return (Boolean)((Object[])object)[0];
        }
        catch (ClassCastException classCastException) {
            if (this.db.on()) {
                this.db.println("getOspfEnable: got unexpected argument");
            }
            return false;
        }
    }

    protected boolean getFarEndIsForeign(Object object) {
        try {
            return (Boolean)((Object[])object)[1];
        }
        catch (ClassCastException classCastException) {
            if (this.db.on()) {
                this.db.println("getFarEndIsForeign: got unexpected argument");
            }
            return false;
        }
    }

    public void deleteTermination(IOhTermModel iOhTermModel) throws Busy, NoLanAccess {
        if (iOhTermModel != null) {
            iOhTermModel.localDestroy();
            this.deleteModel(iOhTermModel);
        }
    }

    public IEntityModel getPortModelByLineIndex(int n) throws AbstractCmsNoSuchEntityException {
        return this.entityTable.getEntityModelByIndex(n);
    }

    public abstract boolean entityExistsInTerminations(IEntityModel var1);

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.info("update: src = " + observable + ", evt = " + object);
        }
        if (observable instanceof OhTerms && object == ModelUpdateType.ADDED) {
            this.addModels();
            this.setChanged();
            this.notifyObservers(object);
        } else if (observable instanceof IOhTermModel && object == ModelUpdateType.DELETED) {
            this.deleteModel((IOhTermModel)observable);
        }
    }

    protected final void initialize() {
        if (!this.initialized) {
            this.addModels();
            this.initialized = true;
            if (this.db.on()) {
                this.db.println("initialized: " + this);
            }
        }
    }

    protected abstract boolean termQualifies(OhTermModel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addModels() {
        if (this.db.on()) {
            this.db.fine("add Models");
        }
        HashSet hashSet = new HashSet(this.ocmd.getOhTerms().getSdccTermModels());
        Object object = this.terms;
        synchronized (object) {
            hashSet.removeAll(this.terms);
        }
        if (this.db.on()) {
            this.db.fine("find " + hashSet.size() + " new " + this.getTypeName() + " terms");
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            OhTermModel ohTermModel = (OhTermModel)object.next();
            if (!this.termQualifies(ohTermModel)) continue;
            HashSet hashSet2 = this.terms;
            synchronized (hashSet2) {
                this.observableManager.addObservable((Observable)((Object)ohTermModel));
                this.terms.add(ohTermModel);
            }
            if (!this.db.on()) continue;
            this.db.println("Add new model - " + ohTermModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteModel(IOhTermModel iOhTermModel) {
        if (this.db.on()) {
            this.db.fine("deleteModel - " + iOhTermModel);
        }
        HashSet hashSet = this.terms;
        synchronized (hashSet) {
            this.observableManager.removeObservable((Observable)((Object)((OhTermModel)iOhTermModel)));
            this.terms.remove(iOhTermModel);
        }
    }

    protected boolean isGccTerm(OhTermModel ohTermModel) {
        DwdmTrkLineModel dwdmTrkLineModel;
        DwdmPortModel dwdmPortModel;
        boolean bl = false;
        IEntityModel iEntityModel = ohTermModel.getOpticalPortModel();
        if (iEntityModel instanceof DwdmPortModel && !(dwdmPortModel = (DwdmPortModel)iEntityModel).isClientPort() && (dwdmTrkLineModel = (DwdmTrkLineModel)dwdmPortModel.getDwdmLineModel()) != null) {
            try {
                if (dwdmTrkLineModel.getOTNStatus()) {
                    bl = true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return bl;
    }

    protected boolean isOscTerm(OhTermModel ohTermModel) {
        IEntityModel iEntityModel = ohTermModel.getOpticalPortModel().getParent();
        if (iEntityModel == null) {
            return false;
        }
        return iEntityModel.getEqType() == 128 || iEntityModel.getEqType() == 127;
    }

    protected HashSet getTerms() {
        this.initialize();
        return this.terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): " + this);
        }
        HashSet hashSet = this.terms;
        synchronized (hashSet) {
            Iterator iterator = this.terms.iterator();
            while (iterator.hasNext()) {
                OhTermModel ohTermModel = (OhTermModel)iterator.next();
                this.observableManager.removeObservable((Observable)((Object)ohTermModel));
                iterator.remove();
            }
        }
        this.initialized = false;
        super.dispose();
    }

    protected Set getNonTransparentTermDwdmEntities() {
        Set set = this.elementModels.getNonProtectDwdmEntities();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                IEntityModel iEntityModel = (IEntityModel)iterator.next();
                if (!(iEntityModel instanceof DwdmPortModel) || ((DwdmPortModel)iEntityModel).getDwdmLineModel().getTermMode() != 0) continue;
                iterator.remove();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                this.db.println("NoSuchInterface Exception " + (Object)((Object)noSuchInterface));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                this.db.println("WrongInterfaceType Exception " + (Object)((Object)wrongInterfaceType));
            }
        }
        return set;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

