/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.SonetTopology.StsTopologyUpgrade;
import cerent.cms.idl.SonetTopology.eTopologyUpgradeState;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConnectionConversionModel;
import cerent.cms.model.HoConnectionModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.NodeModelDelegate;
import org.omg.CORBA.UserException;

public class HoConnectionConversionModel
extends ConnectionConversionModel {
    private StsTopologyUpgrade stsTopologyUpgradeRef;
    private Convert convert = null;
    private Destroy destroy = null;
    private SetState setState = null;
    private HoConnectionModel cm;

    public HoConnectionConversionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public HoConnectionConversionModel(NodeModelDelegate nodeModelDelegate, HoConnectionModel hoConnectionModel, StsTopologyUpgrade stsTopologyUpgrade, int n, int n2, int n3, int n4, ICircuitId iCircuitId, ICircuitId[] iCircuitIdArray, IConnCreateAttrs iConnCreateAttrs, IConnCreateAttrs iConnCreateAttrs2, int n5, IPathDefModel[] iPathDefModelArray, IPathDefModel[] iPathDefModelArray2, boolean bl, boolean bl2) {
        super(nodeModelDelegate, n, n2, n3, n4, iCircuitId, iCircuitIdArray, iConnCreateAttrs, iConnCreateAttrs2, n5, iPathDefModelArray, iPathDefModelArray2, bl, bl2);
        this.stsTopologyUpgradeRef = stsTopologyUpgrade;
        this.convert = new Convert(nodeModelDelegate, "HoConnectionConversionModel.convert");
        this.destroy = new Destroy(nodeModelDelegate, "HoConnectionConversionModel.destroy");
        this.setState = new SetState(nodeModelDelegate, "HoConnectionConversionModel.setState");
        this.cm = hoConnectionModel;
        if (this.db.on()) {
            this.db.println("New HoConnConvModel created, old conn type => " + n4 + ", new conn type => " + n3 + ", state => " + n5);
        }
    }

    public void convert() {
        block4: {
            Object[] objectArray = new Object[1];
            try {
                if (this.db.on()) {
                    this.db.println("convert: converting connection");
                }
                this.convert.set(objectArray);
                if (this.db.on()) {
                    this.db.println("convert: conversion succeeded");
                }
            }
            catch (UserException userException) {
                if (!this.db.on) break block4;
                this.db.print("HoConnectionConversionModel failed to convert connection with index " + this.getIndex());
            }
        }
    }

    public void setState(int n) {
        block3: {
            try {
                Object[] objectArray = new Object[]{eTopologyUpgradeState.from_int(n)};
                this.setState.set(objectArray);
                super.setState(n);
                if (this.db.on()) {
                    this.db.println("setState: new state => " + n);
                }
            }
            catch (UserException userException) {
                if (!this.db.on()) break block3;
                this.db.print("HoConnectionConversionModel failed to setState with index " + this.getIndex());
            }
        }
    }

    public void destroy() {
        block4: {
            try {
                if (this.db.on()) {
                    this.db.println("destroy: destroying HO Conn Conv Model");
                }
                this.destroy.set();
                if (this.db.on()) {
                    this.db.println("destroy: HO Conn Conv Model destroyed");
                }
            }
            catch (UserException userException) {
                if (!this.db.on) break block4;
                this.db.println("HoConnectionConversionModel failed to destroy connection with index " + this.getIndex());
            }
        }
    }

    public void dispose() {
        this.convert.dispose();
        this.destroy.dispose();
        this.setState.dispose();
        super.dispose();
    }

    private class SetState
    extends CachedValue {
        public SetState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            eTopologyUpgradeState eTopologyUpgradeState2 = (eTopologyUpgradeState)objectArray[0];
            if (HoConnectionConversionModel.this.db.on()) {
                HoConnectionConversionModel.this.db.println("setValue: CORBA setState call attempted");
            }
            HoConnectionConversionModel.this.stsTopologyUpgradeRef.setTopologyUpgradeState(eTopologyUpgradeState2);
            if (HoConnectionConversionModel.this.db.on()) {
                HoConnectionConversionModel.this.db.println("setValue: CORBA setState call completed");
            }
        }
    }

    private class Destroy
    extends CachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            System.out.println("setValue: CORBA destroy call attempted");
            HoConnectionConversionModel.this.stsTopologyUpgradeRef.destroy();
            System.out.println("setValue: CORBA destroy call completed");
        }

        protected void setValue(Object object) throws UserException {
            if (HoConnectionConversionModel.this.db.on()) {
                HoConnectionConversionModel.this.db.println("setValue: CORBA destroy call attempted");
            }
            HoConnectionConversionModel.this.stsTopologyUpgradeRef.destroy();
            if (HoConnectionConversionModel.this.db.on()) {
                HoConnectionConversionModel.this.db.println("setValue: CORBA destroy call completed");
            }
        }
    }

    private class Convert
    extends CachedValue {
        public Convert(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            System.out.println("setValue: CORBA convert call attempted");
            HoConnectionConversionModel.this.stsTopologyUpgradeRef.convert();
            System.out.println("setValue: CORBA convert call completed");
        }

        protected void setValue(Object object) throws UserException {
            if (HoConnectionConversionModel.this.db.on()) {
                HoConnectionConversionModel.this.db.println("setValue: CORBA convert call attempted");
            }
            HoConnectionConversionModel.this.stsTopologyUpgradeRef.convert();
            HoConnectionConversionModel.this.cm.markDirty();
            if (HoConnectionConversionModel.this.db.on()) {
                HoConnectionConversionModel.this.db.println("setValue: CORBA convert call completed");
            }
        }
    }
}

