/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdate;
import cerent.cms.model.ModelUpdateType;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class ModelObserver
extends CmsObservable
implements Observer {
    private static ModelSingletonCollection modelObservers;
    private INodeModel nmd;
    private SDebug db;

    public static synchronized ModelObserver getInstance(INodeModel iNodeModel) throws CTCUserException {
        ModelObserver modelObserver;
        if (modelObservers == null) {
            modelObservers = ModelSingletonCollection.getMSCInstanceByName("ModelObserver");
        }
        if ((modelObserver = (ModelObserver)modelObservers.get(iNodeModel)) == null) {
            modelObserver = new ModelObserver(iNodeModel);
            modelObservers.add(iNodeModel, modelObserver);
        }
        return modelObserver;
    }

    public void update(Observable observable, Object object) {
        if (!(observable instanceof Model)) {
            this.db.severe("ERROR: Expected a Model as Observable");
            return;
        }
        if (object instanceof Integer) {
            int n = -1;
            if (observable instanceof Model) {
                n = ((Model)((Object)observable)).getIndex();
            }
            if (object == ModelUpdateType.DELETED) {
                try {
                    if (((Model)((Object)observable)).isDeleted()) {
                        object = ModelUpdateType.CHANGED;
                    } else {
                        this.unregister((Model)((Object)observable));
                    }
                }
                catch (Exception exception) {
                    this.unregister((Model)((Object)observable));
                }
            }
            if (this.db.on()) {
                this.db.fine("Received an update From=" + observable.getClass().getName() + ", Type=" + (Integer)object + ", Index=" + n);
            }
            this.setChanged();
            this.notifyObservers(new ModelUpdate((IModel)((Model)((Object)observable)), (Integer)object));
            this.clearChanged();
        } else if (object instanceof Collection) {
            if (this.db.on()) {
                this.db.info("Received a collection update From=" + observable + ", Type= " + object.getClass().getName());
                SDebug.printStackTrace((Throwable)new Exception("Collection update in ModelObserver!"));
            }
        } else {
            this.db.info("ERROR: Received an update From=" + observable + ", Type= UNKNOWN " + object);
        }
    }

    public void modelGettingInited(Model model) {
        this.register(model);
    }

    private void register(Model model) {
        model.addObserver(this);
    }

    private void unregister(Model model) {
        model.deleteObserver(this);
    }

    private ModelObserver(INodeModel iNodeModel) throws CTCUserException {
        if (iNodeModel == null) {
            throw new CTCUserException("INodeModel is NULL");
        }
        this.nmd = iNodeModel;
        this.db = ((Model)iNodeModel).getDebug().getChildDebug("ModelObserver");
    }
}

