/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.OhCircuitEnd;
import java.util.HashSet;
import java.util.Set;

public class OhCircuitInfo
implements IOhCircuitInfo {
    protected IOhCircuitEnd srcPoint;
    protected IOhCircuitEnd[] destPoints;
    protected int circuitType;
    protected String circuitName;

    public OhCircuitInfo() {
    }

    public OhCircuitInfo(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd[] iOhCircuitEndArray, int n, String string) {
        this.srcPoint = iOhCircuitEnd;
        this.destPoints = iOhCircuitEndArray;
        this.circuitType = n;
        this.circuitName = string;
    }

    public OhCircuitInfo(IOhCircuitInfo iOhCircuitInfo) {
        this.srcPoint = new OhCircuitEnd(iOhCircuitInfo.getSrcPoint());
        this.destPoints = new OhCircuitEnd[iOhCircuitInfo.getDestPoints().length];
        for (int i = 0; i < iOhCircuitInfo.getDestPoints().length; ++i) {
            this.destPoints[i] = new OhCircuitEnd(iOhCircuitInfo.getDestPoints()[i]);
        }
        this.circuitType = iOhCircuitInfo.getCircuitType();
        this.circuitName = iOhCircuitInfo.getCircuitName();
    }

    public IOhCircuitEnd getSrcPoint() {
        return this.srcPoint;
    }

    public void setSrcPoint(IOhCircuitEnd iOhCircuitEnd) {
        this.srcPoint = iOhCircuitEnd;
    }

    public IOhCircuitEnd[] getDestPoints() {
        return this.destPoints;
    }

    public void setDestPoints(IOhCircuitEnd[] iOhCircuitEndArray) {
        this.destPoints = iOhCircuitEndArray;
    }

    public int getCircuitType() {
        return this.circuitType;
    }

    public void setCircuitType(int n) {
        this.circuitType = n;
    }

    public String getCircuitName() {
        return this.circuitName;
    }

    public void setCircuitName(String string) {
        this.circuitName = string;
    }

    public Set getCircuitEndNodes() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(this.getSrcPoint().getNodeId()));
        IOhCircuitEnd[] iOhCircuitEndArray = this.getDestPoints();
        for (int i = 0; i < iOhCircuitEndArray.length; ++i) {
            hashSet.add(new Integer(iOhCircuitEndArray[i].getNodeId()));
        }
        return hashSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Overhead circuit name = " + this.circuitName + "\n" + "         circuit type = " + this.circuitType + "\n" + "         source point = " + this.srcPoint + "\n" + "         destination points = {");
        if (this.destPoints != null) {
            for (int i = 0; i < this.destPoints.length; ++i) {
                stringBuffer.append(this.destPoints[i] + " ");
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

