/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Equipment.ePCMCoding;
import cerent.cms.idl.If.eUdcRate;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.Node.xDuplicateDcc;
import cerent.cms.idl.SonetMedia.sOverheadTerm;
import cerent.cms.idl.SonetTopology.OverheadTermination;
import cerent.cms.idl.SonetTopology.sOverheadTermItem;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xNoLanAccess;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AiciModuleModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTerm;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.NoLanAccess;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermFactory;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.UserException;

public class OhTermModel
extends ConnectionModel
implements IOhTermModel {
    protected ObjIndex objIndex = null;
    protected CircuitId circuitId = null;
    protected OhTerm ohTerm = null;
    private OverheadTermination ohTerminationRef = null;
    private OwPCMCoding owPCMCoding = null;
    private OspfEnable ospfEnable = null;
    private FarEndForeign farEndForeign = null;
    private FarEndIpAddress farEndIpAddress = null;
    protected String description = null;
    private UdcDataRate udcDataRate = null;
    private Destroy destroy = null;
    static /* synthetic */ Class class$cerent$cms$model$OhTermModel;

    public OhTermModel(NodeModelDelegate nodeModelDelegate, sOverheadTermItem sOverheadTermItem2, Connections connections) {
        this(nodeModelDelegate, sOverheadTermItem2.termination, connections);
        this.setAttributes(sOverheadTermItem2);
    }

    public OhTermModel(NodeModelDelegate nodeModelDelegate, OverheadTermination overheadTermination, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(class$cerent$cms$model$OhTermModel == null ? (class$cerent$cms$model$OhTermModel = OhTermModel.class$("cerent.cms.model.OhTermModel")) : class$cerent$cms$model$OhTermModel));
        this.ohTerminationRef = overheadTermination;
        this.objIndex = new ObjIndex(nodeModelDelegate);
        this.circuitId = new CircuitId(nodeModelDelegate);
        this.ohTerm = new OhTerm(nodeModelDelegate);
        this.owPCMCoding = new OwPCMCoding(nodeModelDelegate);
        this.ospfEnable = new OspfEnable(nodeModelDelegate);
        this.farEndForeign = new FarEndForeign(nodeModelDelegate);
        this.farEndIpAddress = new FarEndIpAddress(nodeModelDelegate);
        this.destroy = new Destroy(nodeModelDelegate);
        this.udcDataRate = new UdcDataRate(nodeModelDelegate);
    }

    public OverheadTermination getOhTerminationRef() {
        return this.ohTerminationRef;
    }

    public void init() {
        super.init();
        this.description = null;
        this.objIndex.init();
        this.circuitId.init();
        this.ohTerm.init();
        this.owPCMCoding.init();
        this.ospfEnable.init();
        this.farEndForeign.init();
        this.farEndIpAddress.init();
        this.udcDataRate.init();
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectOverheadTerm;
    }

    protected void updateLocal() {
        this.description = null;
        this.objIndex.update();
        this.circuitId.update();
        this.ohTerm.update();
        this.owPCMCoding.update();
        this.ospfEnable.update();
        this.farEndForeign.update();
        this.farEndIpAddress.update();
        this.udcDataRate.update();
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        this.objIndex.dispose();
        this.circuitId.dispose();
        this.ohTerm.dispose();
        this.owPCMCoding.dispose();
        this.ospfEnable.dispose();
        this.farEndForeign.dispose();
        this.farEndIpAddress.dispose();
        this.udcDataRate.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        this.description = null;
    }

    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getObjIndex", userException);
        }
    }

    public ICircuitId getCircuitId() {
        try {
            return CircuitIdFactory.getICircuitId((sCircuitId)this.circuitId.get());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getCircuitId", userException);
        }
    }

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setCircuitId", userException);
        }
    }

    public IOhTerm getOhTerm() {
        try {
            return OhTermFactory.getIOhTerm((sOverheadTerm)this.ohTerm.get());
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
            return null;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOhTerm", userException);
        }
    }

    public void setOhTerm(IOhTerm iOhTerm) {
        try {
            this.ohTerm.set(OhTermFactory.getOhTerm(iOhTerm));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setOhTerm", userException);
        }
    }

    public int getOwTermPCMCoding() {
        try {
            return ((ePCMCoding)this.owPCMCoding.get()).value();
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperationException(xUnsupportedOperation2.getMessage());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getOwTermPCMCoding", userException);
        }
    }

    public boolean supportOwTermPCMCoding(int n) {
        if (n != 1) {
            return true;
        }
        IEntityModel iEntityModel = this.getAicPortModel();
        return iEntityModel != null && iEntityModel.getParent() instanceof AiciModuleModel;
    }

    public void setOwTermPCMCoding(int n) {
        if (!this.supportOwTermPCMCoding(n)) {
            throw new IllegalArgumentException("Unsupported coding = " + n);
        }
        try {
            this.owPCMCoding.set(ePCMCoding.from_int(n));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperationException(xUnsupportedOperation2.getMessage());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setOwTermPCMCoding", userException);
        }
    }

    public boolean isOspfEnable() {
        try {
            return (Boolean)this.ospfEnable.get();
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperationException(xUnsupportedOperation2.getMessage());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "isOspfEnable", userException);
        }
    }

    public void setOspfEnable(boolean bl) {
        try {
            this.ospfEnable.set(new Boolean(bl));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperationException(xUnsupportedOperation2.getMessage());
        }
        catch (xDuplicateDcc xDuplicateDcc2) {
            throw new UnsupportedOperationException("Duplicate DCC");
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setOspfEnable", userException);
        }
    }

    public void setFarEndIsForeign(boolean bl) {
        try {
            this.farEndForeign.set(new Boolean(bl));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setFarEndIsForeign", userException);
        }
    }

    public boolean isFarEndForeign() {
        try {
            return (Boolean)this.farEndForeign.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "isFarEndForeign", userException);
        }
    }

    public void setFarEndIpAddress(sIpAddr sIpAddr2) throws ConfigError {
        try {
            this.farEndIpAddress.set(sIpAddr2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setFarEndIpAddress", userException);
        }
    }

    public sIpAddr getFarEndIpAddress() {
        try {
            return (sIpAddr)this.farEndIpAddress.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getFarEndIpAddress", userException);
        }
    }

    public void localDestroy() throws Busy, NoLanAccess {
        try {
            this.destroy.set();
            this.parent.remove(this.getIndex());
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xNoLanAccess xNoLanAccess2) {
            throw new NoLanAccess((UserException)xNoLanAccess2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "localDestroy", userException);
        }
    }

    public int getUdcRate() {
        try {
            return ((eUdcRate)this.udcDataRate.get()).value();
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperationException(xUnsupportedOperation2.getMessage());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getUdcRate", userException);
        }
    }

    public void setAttributes(sOverheadTermItem sOverheadTermItem2) {
        this.objIndex.setValueExternally(new Integer(sOverheadTermItem2.objIndex));
        this.circuitId.setValueExternally(sOverheadTermItem2.circuitId);
        this.ohTerm.setValueExternally(sOverheadTermItem2.term);
    }

    public String getName() {
        return ((OhConnectionModelsDelegate)this.nmd.getOhConnectionModels()).getCircuitName(this.getCircuitId());
    }

    protected void printString(SDebug sDebug) {
        sDebug.fine("OhTerm : " + this.getOhTerm());
        sDebug.fine("index: " + this.getIndex());
        sDebug.fine("Circuit Name " + this.getName());
        sDebug.fine("Observers are :");
        this.printObservers();
    }

    public String toString() {
        try {
            if (this.description == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Overhead Termination: NodeId=");
                stringBuffer.append(Integer.toHexString(this.getNodeModel().getNodeId()));
                stringBuffer.append(" OhTerm=");
                stringBuffer.append(this.getOhTerm());
                stringBuffer.append(" CircuitName=");
                stringBuffer.append(this.getName());
                if (this.getCircuitType() == 2 || this.getCircuitType() == 3) {
                    stringBuffer.append(" PCMCoding=");
                    try {
                        stringBuffer.append(this.getOwTermPCMCoding());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        stringBuffer.append("n/a");
                    }
                }
                if (this.getChannelType() == 0 || this.getChannelType() == 4) {
                    stringBuffer.append(" OspfEnable=");
                    stringBuffer.append(this.isOspfEnable());
                }
                this.description = stringBuffer.toString();
            }
            return this.description;
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
            return "DELETED";
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof OhTermModel)) {
            return false;
        }
        OhTermModel ohTermModel = (OhTermModel)object;
        return this.getNodeModel().equals(ohTermModel.getNodeModel()) && this.getIndex() == ohTermModel.getIndex();
    }

    public int getCircuitType() {
        return OhChannelType.getOhChannelTypeObj((int)this.getChannelType()).getCorrespondingCircuitType().getIndex();
    }

    public int getChannelType() {
        return this.getOhTerm().getChannel().getType();
    }

    public int getOpticalPortIndex() {
        return this.getOhTerm().getChannel().getPortIndex();
    }

    public IEntityModel getAicPortModel() {
        try {
            return this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getAicPortIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return null;
        }
    }

    public IEntityModel getOpticalPortModel() {
        try {
            return this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getOpticalPortIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return null;
        }
    }

    public int getAicPortIndex() {
        return this.getOhTerm().getPortIndex();
    }

    public boolean usingEntity(int n) {
        return this.getOpticalPortIndex() == n || this.getAicPortIndex() == n;
    }

    public boolean usingEntity(int n, int n2) {
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel == null || iNodeModel.getNodeId() != n) {
            return false;
        }
        return this.usingEntity(n2);
    }

    public int[] getUsedOpticalPorts() {
        return new int[]{this.getOpticalPortIndex()};
    }

    public int[] getUsedOpticalPorts(OhChannelType ohChannelType) {
        if (this.getChannelType() == ohChannelType.getIndex()) {
            return new int[]{this.getOpticalPortIndex()};
        }
        return null;
    }

    public boolean usedChannel(int n, OhChannelType ohChannelType) {
        return this.getChannelType() == ohChannelType.getIndex() && this.usingEntity(n);
    }

    public boolean inRoll() {
        return false;
    }

    public int getConnectionType() {
        return -1;
    }

    public List getPortModels() {
        IEntityModel iEntityModel;
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        IEntityModel iEntityModel2 = this.getAicPortModel();
        if (iEntityModel2 != null) {
            arrayList.add(iEntityModel2);
        }
        if ((iEntityModel = this.getOpticalPortModel()) != null) {
            arrayList.add(iEntityModel);
        }
        return arrayList;
    }

    public boolean validateNewAdminState(int n) {
        return false;
    }

    public eAdminState getAdminStateEnum() {
        return eAdminState.ADMIN_IS;
    }

    public void setAdminState(eAdminState eAdminState2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UdcDataRate
    extends CachedValue {
        public UdcDataRate(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.udcDataRate");
        }

        protected Object getValue() throws xUnsupportedOperation {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for getting Udc Rate");
            }
            return OhTermModel.this.getOhTerminationRef().getUdcRate();
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.destroy");
        }

        protected void setValue() throws xBusy, xNoLanAccess {
            OhTermModel.this.getOhTerminationRef().destroy();
        }
    }

    private class FarEndIpAddress
    extends CachedValue {
        FarEndIpAddress(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.FarEndIpAddress");
        }

        protected Object getValue() {
            return OhTermModel.this.getOhTerminationRef().getFarEndIpAddress();
        }

        protected Object getValue(Object object) {
            throw new UnsupportedOperationException();
        }

        protected void setValue() {
            throw new UnsupportedOperationException();
        }

        protected void setValue(Object object) throws xConfigError {
            OhTermModel.this.getOhTerminationRef().setFarEndIpAddress((sIpAddr)object);
        }
    }

    private class FarEndForeign
    extends CachedValue {
        FarEndForeign(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.FarEndForeign");
        }

        protected Object getValue() {
            return new Boolean(OhTermModel.this.getOhTerminationRef().isFarEndForeign());
        }

        protected Object getValue(Object object) {
            throw new UnsupportedOperationException();
        }

        protected void setValue() {
            throw new UnsupportedOperationException();
        }

        protected void setValue(Object object) {
            OhTermModel.this.getOhTerminationRef().setFarEndIsForeign((Boolean)object);
        }
    }

    private class OspfEnable
    extends CachedValue {
        public OspfEnable(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.ospfEnable");
        }

        protected Object getValue() throws xUnsupportedOperation {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for getting OspfEnable");
            }
            return new Boolean(OhTermModel.this.getOhTerminationRef().isOspfEnable());
        }

        protected void setValue(Object object) throws xUnsupportedOperation, xDuplicateDcc {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for setting OspfEnable");
            }
            OhTermModel.this.getOhTerminationRef().setOspfEnable((Boolean)object);
        }
    }

    private class OwPCMCoding
    extends CachedValue {
        public OwPCMCoding(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.owPCMCoding");
        }

        protected Object getValue() throws xUnsupportedOperation {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for getting PCM coding");
            }
            return OhTermModel.this.getOhTerminationRef().getOrderwireTermPCMCoding();
        }

        protected void setValue(Object object) throws xUnsupportedOperation {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for setting PCM coding");
            }
            OhTermModel.this.getOhTerminationRef().setOrderwireTermPCMCoding((ePCMCoding)object);
        }
    }

    protected class OhTerm
    extends CachedValue {
        public OhTerm(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.ohTerm");
        }

        protected Object getValue() {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for overhead termination");
            }
            return OhTermModel.this.getOhTerminationRef().term();
        }

        protected void setValue(Object object) {
            throw new IllegalStateException("Should not be called");
        }
    }

    protected class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.circuitId");
        }

        protected Object getValue() {
            if (OhTermModel.this.db.on()) {
                OhTermModel.this.db.finer("Making CORBA call for circuitId");
            }
            return OhTermModel.this.getOhTerminationRef().circuitId();
        }

        protected void setValue(Object object) {
            OhTermModel.this.getOhTerminationRef().circuitId((sCircuitId)object);
        }
    }

    protected class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, "OhTermModel.objIndex");
        }

        protected Object getValue() {
            return new Integer(OhTermModel.this.getOhTerminationRef().objIndex());
        }

        protected void setValue(Object object) {
            throw new IllegalStateException("Should not be called");
        }
    }
}

