/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.PluggableModule;
import cerent.cms.idl.Equipment.PluggableModuleHelper;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.xAlreadyLocked;
import cerent.cms.idl.Equipment.xDuplexLocked;
import cerent.cms.idl.Equipment.xDuplexUnlocked;
import cerent.cms.idl.Equipment.xInvalidState;
import cerent.cms.idl.Equipment.xProtectActive;
import cerent.cms.idl.Equipment.xProtectFailedOrMissing;
import cerent.cms.idl.Equipment.xProtectLocked;
import cerent.cms.idl.Equipment.xProvisionError;
import cerent.cms.idl.Equipment.xWorkingFailedOrMissing;
import cerent.cms.idl.Equipment.xWorkingLocked;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.util.EnumStrings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omg.CORBA.UserException;

public class PimModel
extends PluggableModel
implements IEntityModel {
    private PluggableModule pluggableModuleRef = null;
    private PerformModuleOp performModuleOp;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eModuleOp;

    public PimModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
        this.index = n;
        this.pluggableModuleRef = PluggableModuleHelper.narrow(entity);
        this.performModuleOp = new PerformModuleOp(nodeModelDelegate, "PimModel.performModuleOperation");
    }

    public PluggableModule getPluggableModuleRef() {
        return this.pluggableModuleRef;
    }

    public void reset(eModuleOp eModuleOp2) throws ProtectFailedOrMissing, WorkingFailedOrMissing, AlreadyLocked, ProtectLocked, WorkingLocked, ProtectActive, InvalidState, DuplexLocked, DuplexUnlocked, ProvisionError {
        if (eModuleOp2 == eModuleOp.HARD_RESET) {
            try {
                if (this.db.on()) {
                    this.db.println("reset(): " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eModuleOp == null ? (class$cerent$cms$idl$Equipment$eModuleOp = PimModel.class$("cerent.cms.idl.Equipment.eModuleOp")) : class$cerent$cms$idl$Equipment$eModuleOp))[eModuleOp2.value()] + " for " + Integer.toHexString(this.getEntityIndex()));
                }
                this.performModuleOp.set(eModuleOp2);
            }
            catch (xProtectFailedOrMissing xProtectFailedOrMissing2) {
                throw new ProtectFailedOrMissing((UserException)xProtectFailedOrMissing2);
            }
            catch (xWorkingFailedOrMissing xWorkingFailedOrMissing2) {
                throw new WorkingFailedOrMissing((UserException)xWorkingFailedOrMissing2);
            }
            catch (xAlreadyLocked xAlreadyLocked2) {
                throw new AlreadyLocked((UserException)xAlreadyLocked2);
            }
            catch (xProtectLocked xProtectLocked2) {
                throw new ProtectLocked((UserException)xProtectLocked2);
            }
            catch (xWorkingLocked xWorkingLocked2) {
                throw new WorkingLocked((UserException)xWorkingLocked2);
            }
            catch (xProtectActive xProtectActive2) {
                throw new ProtectActive((UserException)xProtectActive2);
            }
            catch (xInvalidState xInvalidState2) {
                throw new InvalidState((UserException)xInvalidState2);
            }
            catch (xDuplexLocked xDuplexLocked2) {
                throw new DuplexLocked((UserException)xDuplexLocked2);
            }
            catch (xDuplexUnlocked xDuplexUnlocked2) {
                throw new DuplexUnlocked((UserException)xDuplexUnlocked2);
            }
            catch (xProvisionError xProvisionError2) {
                throw new ProvisionError((UserException)xProvisionError2);
            }
            catch (UserException userException) {
                throw this.doUnknown("doCommand", userException);
            }
        } else {
            throw new IllegalArgumentException("Unsupported module operation for PIM, eModuleOp= " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eModuleOp == null ? (class$cerent$cms$idl$Equipment$eModuleOp = PimModel.class$("cerent.cms.idl.Equipment.eModuleOp")) : class$cerent$cms$idl$Equipment$eModuleOp))[eModuleOp2.value()]);
        }
    }

    protected List getTdmPorts() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getDescendantsOfType(eEqType.OC3_PORT));
        arrayList.addAll(this.getDescendantsOfType(eEqType.OC12_PORT));
        arrayList.addAll(this.getDescendantsOfType(eEqType.OC48_PORT));
        return arrayList;
    }

    public boolean isInProtectionGroup() {
        boolean bl = false;
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            TdmPortModel tdmPortModel;
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!(entityModel instanceof TdmPortModel) || !(tdmPortModel = (TdmPortModel)entityModel).hasOpticalProtection()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isSupportingBLSR() {
        boolean bl = false;
        Set set = this.getNodeModelDelegate().getElementModelsDelegate().getBlsrElements();
        BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            for (int i = 0; !bl && i < blsrModelArray.length; ++i) {
                sBlsrProvision sBlsrProvision2 = blsrModelArray[i].getProvision();
                if (entityModel.getEntityIndex() != sBlsrProvision2.eastPort && entityModel.getEntityIndex() != sBlsrProvision2.westPort && entityModel.getEntityIndex() != sBlsrProvision2.eastProtectPort && entityModel.getEntityIndex() != sBlsrProvision2.westProtectPort) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean isSupportingGCC() {
        boolean bl = false;
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!nodeModelDelegate.getGccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isSupportingSDCC() {
        boolean bl = false;
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!nodeModelDelegate.getDccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isSupportingLDCC() {
        boolean bl = false;
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!nodeModelDelegate.getLdccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isTimingSource() {
        return this.isTimingSource(eRef.NE);
    }

    public boolean isEXT_1TimingSource() {
        return this.isTimingSource(eRef.EXT_1);
    }

    public boolean isEXT_2TimingSource() {
        return this.isTimingSource(eRef.EXT_2);
    }

    public boolean isTimingSource(eRef eRef2) {
        boolean bl = false;
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        SynchronizationModel synchronizationModel = nodeModelDelegate.getSynchronizationModel();
        sInfo[] sInfoArray = synchronizationModel.getRefSources(eRef2);
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            for (int i = 0; !bl && i < sInfoArray.length; ++i) {
                if (entityModel.getEntityIndex() != sInfoArray[i].line) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean hasCircuits() {
        boolean bl = false;
        List list = this.getTdmPorts();
        Iterator iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            bl = !entityModel.getConnectionsList().isEmpty();
        }
        return bl;
    }

    public boolean hasOhCircuits() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.getTdmPorts());
        HashSet hashSet2 = new HashSet();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.getNodeModel().getOhConnectionModels();
        ArrayList arrayList = new ArrayList(ohConnectionModelsDelegate.getOhTerms().getConnectionModels());
        arrayList.addAll(ohConnectionModelsDelegate.getOhXcons().getConnectionModels());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            hashSet2.addAll(connectionModel.getPortModels());
        }
        hashSet2.retainAll(hashSet);
        return !hashSet2.isEmpty();
    }

    public PluggableSlotModel[] getPpmSlots() {
        return this.getChildren().toArray(new PluggableSlotModel[0]);
    }

    public List getAvailablePpmSlots() {
        ArrayList<PluggableSlotModel> arrayList = new ArrayList<PluggableSlotModel>();
        PluggableSlotModel[] pluggableSlotModelArray = this.getPpmSlots();
        for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
            PluggableModel pluggableModel;
            if (pluggableSlotModelArray[i].getChildren().isEmpty()) {
                arrayList.add(pluggableSlotModelArray[i]);
                continue;
            }
            PluggableModel pluggableModel2 = (PluggableModel)pluggableSlotModelArray[i].getChildren().get(0);
            if (pluggableModel2.getState() != eEqState.DELETED || (pluggableModel = (PluggableModel)pluggableModel2.getParent().getParent()).getState() == eEqState.DELETED) continue;
            arrayList.add(pluggableSlotModelArray[i]);
        }
        return arrayList;
    }

    public List getAvailablePpmSlotNumbers() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        List list = this.getAvailablePpmSlots();
        for (int i = 0; i < list.size(); ++i) {
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)list.get(i);
            int[] nArray = pluggableSlotModel.getHierarchyNums();
            arrayList.add(nArray);
        }
        return arrayList;
    }

    public boolean isSoftResettable() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PerformModuleOp
    extends NonCachedValue {
        public PerformModuleOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            PimModel.this.getPluggableModuleRef().doCommand((eModuleOp)object);
        }

        public Object outer() {
            return PimModel.this;
        }
    }
}

