/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.idl.Rmon.sAlarmRunTimeInfo;
import cerent.cms.idl.Rmon.xNoSuchAlarm;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class RmonThresholdModel
extends Model {
    private NodeModelDelegate nmd;
    private short alarmIndex;
    private AlarmDelete alarmDelete;
    private AlarmAdminInfo alarmAdminInfo;
    private AlarmRunTimeInfo alarmRunTimeInfo;
    private EventDispatcher dispatcher;
    static /* synthetic */ Class class$cerent$cms$model$RmonThresholdModel;

    public RmonThresholdModel(NodeModelDelegate nodeModelDelegate, short s, sAlarmAdminInfo sAlarmAdminInfo2, sAlarmRunTimeInfo sAlarmRunTimeInfo2) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$RmonThresholdModel == null ? (class$cerent$cms$model$RmonThresholdModel = RmonThresholdModel.class$("cerent.cms.model.RmonThresholdModel")) : class$cerent$cms$model$RmonThresholdModel));
        this.nmd = nodeModelDelegate;
        this.alarmIndex = s;
        this.alarmDelete = new AlarmDelete(this.nmd, "RmonThresholdModel::deleteAlarm");
        this.alarmAdminInfo = new AlarmAdminInfo(this.nmd, "RmonThresholdModel::alarmAdminInfo", sAlarmAdminInfo2);
        this.alarmRunTimeInfo = new AlarmRunTimeInfo(this.nmd, "RmonThresholdModel::alarmRunTimeInfo");
        if (sAlarmRunTimeInfo2 != null) {
            this.alarmRunTimeInfo.setValueExternally(sAlarmRunTimeInfo2);
        }
        this.index = this.alarmIndex;
        this.init();
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("RmonThresholdModel::init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRmonAlarm, (int)this.alarmIndex, (Observer)this);
            if (this.db.on()) {
                this.db.println("RmonThresholdModel now observing alarmIndex:" + this.alarmIndex);
            }
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRmonAlarm, (int)this.alarmIndex, (Observer)this);
            if (this.db.on()) {
                this.db.println("RmonThresholdModel no longer observing alarmIndex:" + this.alarmIndex);
            }
            this.dispatcher = null;
        }
        super.dispose();
    }

    public short getThresholdIndex() {
        if (this.db.on()) {
            this.db.println("RmonThresholdModel::getThresholdIndex()");
        }
        return this.alarmIndex;
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Update received in RmonThresholdModel: " + object);
        }
        if (observable instanceof CmsObservable) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println("Object being deleted.");
                    }
                    RmonThresholdManager.getInstance(this.nmd).removeRmonThreshold(this);
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        this.alarmAdminInfo.update();
        this.alarmRunTimeInfo.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void delete() throws xNoSuchAlarm {
        try {
            this.alarmDelete.set(new Short(this.alarmIndex));
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sAlarmAdminInfo getAlarmAdminInfo() throws xNoSuchAlarm {
        try {
            return (sAlarmAdminInfo)this.alarmAdminInfo.get(new Short(this.alarmIndex));
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sAlarmRunTimeInfo getAlarmRunTimeInfo() throws xNoSuchAlarm {
        try {
            return (sAlarmRunTimeInfo)this.alarmRunTimeInfo.get(new Short(this.alarmIndex));
        }
        catch (xNoSuchAlarm xNoSuchAlarm2) {
            throw xNoSuchAlarm2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        RmonThresholdManager rmonThresholdManager = RmonThresholdManager.getInstance(nodeModelDelegate);
        rmonThresholdManager.getRmonThresholdList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AlarmRunTimeInfo
    extends CachedValue {
        public AlarmRunTimeInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            short s = (Short)object;
            return this.node.getIorRepository().getRmonRef().getAlarmRunTimeInfo(s);
        }

        protected Object cloneValue() {
            sAlarmRunTimeInfo sAlarmRunTimeInfo2 = (sAlarmRunTimeInfo)this.value;
            sAlarmRunTimeInfo sAlarmRunTimeInfo3 = new sAlarmRunTimeInfo(sAlarmRunTimeInfo2.lastTimeSent, sAlarmRunTimeInfo2.lastValue, sAlarmRunTimeInfo2.active);
            return sAlarmRunTimeInfo3;
        }

        public Object outer() {
            return RmonThresholdModel.this;
        }
    }

    class AlarmAdminInfo
    extends CachedValue {
        public AlarmAdminInfo(NodeModelDelegate nodeModelDelegate, String string, Object object) {
            super(nodeModelDelegate, string, object);
        }

        protected Object getValue(Object object) throws UserException {
            short s = (Short)object;
            return this.node.getIorRepository().getRmonRef().getAlarmAdminInfo(s);
        }

        protected Object cloneValue() {
            sAlarmAdminInfo sAlarmAdminInfo2 = (sAlarmAdminInfo)this.value;
            sAlarmAdminInfo sAlarmAdminInfo3 = new sAlarmAdminInfo(sAlarmAdminInfo2.ifIndex, sAlarmAdminInfo2.variable, sAlarmAdminInfo2.alarmType, sAlarmAdminInfo2.sampleType, sAlarmAdminInfo2.interval, sAlarmAdminInfo2.risingThreshold, sAlarmAdminInfo2.fallingThreshold, sAlarmAdminInfo2.alarmOwner);
            return sAlarmAdminInfo3;
        }

        public Object outer() {
            return RmonThresholdModel.this;
        }
    }

    class AlarmDelete
    extends NonCachedValue {
        public AlarmDelete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            short s = (Short)object;
            this.node.getIorRepository().getRmonRef().deleteAlarm(s);
        }

        public Object outer() {
            return RmonThresholdModel.this;
        }
    }
}

