/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Security.ExistingUser;
import cerent.cms.idl.Security.General;
import cerent.cms.idl.Security.NotAuthenticated;
import cerent.cms.idl.Security.UnknownUser;
import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.idl.Security.sActiveUserInfo;
import cerent.cms.idl.Security.sDisableInactiveUserPolicy;
import cerent.cms.idl.Security.sIdleUserTimeout;
import cerent.cms.idl.Security.sLockoutPolicy;
import cerent.cms.idl.Security.sPasswordExpr;
import cerent.cms.idl.Security.sPasswordExprPolicy;
import cerent.cms.idl.Security.sPasswordFlippingPolicy;
import cerent.cms.idl.Security.userInfo;
import cerent.cms.idl.Security.xActiveUserSession;
import cerent.cms.idl.Security.xBadPasswordFlipping;
import cerent.cms.idl.Security.xBadPasswordSimple;
import cerent.cms.idl.Security.xBadPasswordToggling;
import cerent.cms.idl.Security.xDccNotConnected;
import cerent.cms.idl.Security.xInvalidParms;
import cerent.cms.idl.Security.xKeepOneSuperUser;
import cerent.cms.idl.Security.xMaximumUsers;
import cerent.cms.idl.Security.xOperationFailed;
import cerent.cms.idl.Security.xOperationNotSupported;
import cerent.cms.idl.Security.xPortInUse;
import cerent.cms.idl.Security.xUserNotLoggedIn;
import cerent.cms.model.ActiveUserInfoModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.DccNotConnected;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.IUserInfoModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OperationFailed;
import cerent.cms.model.PortInUse;
import cerent.cms.model.SecurityActiveUserSession;
import cerent.cms.model.SecurityBadPassword;
import cerent.cms.model.SecurityBadPasswordFlipping;
import cerent.cms.model.SecurityBadPasswordToggling;
import cerent.cms.model.SecurityExistingUser;
import cerent.cms.model.SecurityKeepOneSuperUser;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityMaximumUsers;
import cerent.cms.model.SecurityNotAuthenticated;
import cerent.cms.model.SecurityNotAuthorized;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.model.SecurityUnknownUser;
import cerent.cms.model.SecurityUserNotLoggedIn;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.UserInfoModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.ShortHolder;
import org.omg.CORBA.UserException;

public class SecurityModel
extends Model
implements ISecurityModel {
    NodeModelDelegate nodeModel;
    Login login;
    Logout logout;
    UserList userList;
    ActiveUserList activeUserList;
    CreateUser createUser;
    DeleteUser deleteUser;
    ClearSecurityIntrusionAlarm clearSecurityIntrusionAlarm;
    UserPassword userPassword;
    UserSecurityLevel userSecurityLevel;
    AdminLockUsername adminLockUsername;
    AdminUnlockUsername adminUnlockUsername;
    LogoutUser logoutUser;
    LockoutPolicy lockoutPolicy;
    PasswordTogglingPolicy passwordTogglingPolicy;
    SingleSessionPerUser singleSessionPerUser;
    IdleUserTimeout idleUserTimeout;
    LegalDisclaimer legalDisclaimer;
    ForcePasswordChange forcePasswordChange;
    RequirePasswordChange requirePasswordChange;
    PasswordFlippingPolicy passwordFlippingPolicy;
    PasswordExprPolicy passwordExprPolicy;
    DisableInactiveUserPolicy disableInactiveUserPolicy;
    UserDisabled userDisabled;
    FrontLANAccess frontLanAccess;
    BackLANAccess backLanAccess;
    LANAccessTimeout lanAccessTimeout;
    SerialPortAccess serialPortAccess;
    TelnetPort telnetPort;
    EnableSsh enableSsh;
    EnforceShellPassword enforceShellPassword;
    PmClearingPrivilege pmClearingPrivilege;
    PasswordCloseToExpiring passwordCloseToExpiring;
    UserForcePasswordChange userForcePasswordChange;
    AlarmOnLostBackLanLink alarmOnLostBackLanLink;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection securityModelSingletons;
    private static String TELNET_PORT_ERROR_MSG;
    private static final Integer NO_WARNING;
    private static final SecurityPolicy DEF_POLICY;
    private static final int STANDARD_SSH_PORT = 22;
    private static final int STANDARD_TELNET_PORT = 23;
    static /* synthetic */ Class class$cerent$cms$model$SecurityModel;

    public static synchronized SecurityModel getInstance(NodeModelDelegate nodeModelDelegate) {
        SecurityModel securityModel;
        if (securityModelSingletons == null) {
            securityModelSingletons = ModelSingletonCollection.getMSCInstanceByName("SecurityModel");
        }
        if ((securityModel = (SecurityModel)securityModelSingletons.get(nodeModelDelegate)) == null) {
            securityModel = new SecurityModel(nodeModelDelegate);
            securityModelSingletons.add(nodeModelDelegate, securityModel);
        }
        return securityModel;
    }

    public final void testTelnetPorts() {
        for (int n = Short.MIN_VALUE; n < Short.MAX_VALUE; n = (int)((short)(n + 1))) {
            try {
                this.setTelnetPort(n);
                this.telnetPort.update();
                int n2 = this.getTelnetPort();
                if (n == n2) continue;
                this.db.println("set(" + n + ") != get(" + n2 + ")");
                continue;
            }
            catch (InvalidParams invalidParams) {
                this.db.println("set(" + n + "): invalid parameter");
                continue;
            }
            catch (PortInUse portInUse) {
                this.db.println("set(" + n + "): port in use");
                continue;
            }
            catch (Exception exception) {
                this.db.println("set(" + n + "): " + exception);
            }
        }
    }

    private SecurityModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$SecurityModel == null ? (class$cerent$cms$model$SecurityModel = SecurityModel.class$("cerent.cms.model.SecurityModel")) : class$cerent$cms$model$SecurityModel));
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
        this.db.addCommand(this, "testTelnetPorts", "Test all possible telnet ports");
        this.login = new Login(nodeModelDelegate, "SecurityModel::login");
        this.logout = new Logout(nodeModelDelegate, "SecurityModel::logout");
        this.userList = new UserList(nodeModelDelegate, "SecurityModel::userList");
        this.activeUserList = new ActiveUserList(nodeModelDelegate, "SecurityModel::activeUserList");
        this.createUser = new CreateUser(nodeModelDelegate, "SecurityModel::createUser");
        this.deleteUser = new DeleteUser(nodeModelDelegate, "SecurityModel::deleteUser");
        this.clearSecurityIntrusionAlarm = new ClearSecurityIntrusionAlarm(nodeModelDelegate, "SecurityModel::clearSecurityIntrusionAlarm");
        this.userPassword = new UserPassword(nodeModelDelegate, "SecurityModel::userPassword");
        this.userSecurityLevel = new UserSecurityLevel(nodeModelDelegate, "SecurityModel::userSecurityLevel");
        this.adminLockUsername = new AdminLockUsername(nodeModelDelegate, "SecurityModel::adminLockUsername");
        this.adminUnlockUsername = new AdminUnlockUsername(nodeModelDelegate, "SecurityModel::adminUnlockUsername");
        this.logoutUser = new LogoutUser(nodeModelDelegate, "SecurityModel::logoutUser");
        this.lockoutPolicy = new LockoutPolicy(nodeModelDelegate, "SecurityModel::lockoutPolicy");
        this.passwordTogglingPolicy = new PasswordTogglingPolicy(nodeModelDelegate, "SecurityModel::passwordTogglingPolicy");
        this.singleSessionPerUser = new SingleSessionPerUser(nodeModelDelegate, "SecurityModel::singleSessionPerUser");
        this.legalDisclaimer = new LegalDisclaimer(nodeModelDelegate, "SecurityModel::legalDisclaimer");
        this.idleUserTimeout = new IdleUserTimeout(nodeModelDelegate, "SecurityModel::idleUserTimeout");
        this.forcePasswordChange = new ForcePasswordChange(nodeModelDelegate, "SecurityModel::forcePasswordChange");
        this.requirePasswordChange = new RequirePasswordChange(nodeModelDelegate, "SecurityModel::requirePasswordChange");
        this.passwordFlippingPolicy = new PasswordFlippingPolicy(nodeModelDelegate, "SecurityModel::passwordFlippingPolicy");
        this.passwordExprPolicy = new PasswordExprPolicy(nodeModelDelegate, "SecurityModel::passwordExprPolicy");
        this.disableInactiveUserPolicy = new DisableInactiveUserPolicy(nodeModelDelegate, "SecurityModel::disableInactiveUserPolicy");
        this.userDisabled = new UserDisabled(nodeModelDelegate, "SecurityModel::userDisabled");
        this.frontLanAccess = new FrontLANAccess(nodeModelDelegate, "SecurityModel::frontLanAccess");
        this.backLanAccess = new BackLANAccess(nodeModelDelegate, "SecurityModel::backLanAccess");
        this.lanAccessTimeout = new LANAccessTimeout(nodeModelDelegate, "SecurityModel::lanAccessTimeout");
        this.serialPortAccess = new SerialPortAccess(nodeModelDelegate, "SecurityModel::serialPortAccess");
        this.telnetPort = new TelnetPort(nodeModelDelegate, "SecurityModel::telnetPort");
        this.enableSsh = new EnableSsh(nodeModelDelegate, "SecurityModel::enableSsh");
        this.enforceShellPassword = new EnforceShellPassword(nodeModelDelegate, "SecurityModel::enforceShellPassword");
        this.pmClearingPrivilege = new PmClearingPrivilege(nodeModelDelegate, "SecurityModel::pmClearingPrivilege");
        this.passwordCloseToExpiring = new PasswordCloseToExpiring(nodeModelDelegate, "SecurityModel::passwordCloseToExpiring");
        this.userForcePasswordChange = new UserForcePasswordChange(nodeModelDelegate, "SecurityModel::userForcePasswordChange");
        this.alarmOnLostBackLanLink = new AlarmOnLostBackLanLink(nodeModelDelegate, "SecurityModel::alarmOnLostBackLanLink");
        this.dispatcher = null;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    private General getSecurityRef() {
        try {
            return this.nodeModel.getIorRepository().getSecurityRef();
        }
        catch (MalformedURLException malformedURLException) {
            throw new CmsCommFailException(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new CmsCommFailException(iOException.getMessage());
        }
    }

    public void init() {
        super.init0();
        if (this.db.on) {
            this.db.println("Enter SecurityModel init()");
        }
        this.userList.init();
        this.activeUserList.init();
        this.lockoutPolicy.init();
        this.passwordTogglingPolicy.init();
        this.singleSessionPerUser.init();
        this.idleUserTimeout.init();
        this.legalDisclaimer.init();
        this.forcePasswordChange.init();
        this.passwordFlippingPolicy.init();
        this.passwordExprPolicy.init();
        this.dispatcher = this.nodeModel.getDispatcher();
        this.disableInactiveUserPolicy.init();
        this.frontLanAccess.init();
        this.backLanAccess.init();
        this.lanAccessTimeout.init();
        this.serialPortAccess.init();
        this.telnetPort.init();
        this.enableSsh.init();
        this.enforceShellPassword.init();
        this.pmClearingPrivilege.init();
        this.alarmOnLostBackLanLink.init();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 0, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 1, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 2, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 3, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 4, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSecurity, 5, (Observer)this);
        }
    }

    public int login(String string, String string2) throws NotAuthenticated {
        if (this.db.on()) {
            this.db.println("login(" + string + ")");
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string3 = inetAddress.getHostAddress();
            IIpAddr iIpAddr = InetUtil.makeIpAddr(string3);
            sIpAddr sIpAddr2 = IpAddrFactory.getIpAddr(iIpAddr);
            if (this.db.on()) {
                this.db.println("logging in from " + string3);
            }
            Object[] objectArray = new Object[]{string, string2, sIpAddr2};
            return (Integer)this.login.get(objectArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new CmsCommFailException(unknownHostException.getMessage());
        }
        catch (NotAuthenticated notAuthenticated) {
            throw notAuthenticated;
        }
        catch (UserException userException) {
            throw new CmsCommFailException(userException.getMessage());
        }
    }

    public void logout() throws UnknownUser {
        if (this.db.on()) {
            this.db.println("logout");
        }
        try {
            this.logout.set();
        }
        catch (UnknownUser unknownUser) {
            throw unknownUser;
        }
        catch (UserException userException) {
            throw new CmsCommFailException(userException.getMessage());
        }
    }

    private ActiveUserInfoModel[] asActiveUserInfoModelArray(ArrayList arrayList) {
        return arrayList.toArray(new ActiveUserInfoModel[arrayList.size()]);
    }

    public ActiveUserInfoModel[] activeUsers() {
        try {
            return this.asActiveUserInfoModelArray((ArrayList)this.activeUserList.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IActiveUserInfoModel[] getActiveUsers() {
        try {
            return this.asActiveUserInfoModelArray((ArrayList)this.activeUserList.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private UserInfoModel[] asUserInfoModelArray(ArrayList arrayList) {
        return arrayList.toArray(new UserInfoModel[arrayList.size()]);
    }

    public UserInfoModel[] users() {
        try {
            return this.asUserInfoModelArray((ArrayList)this.userList.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IUserInfoModel[] getUsers() {
        try {
            return this.asUserInfoModelArray((ArrayList)this.userList.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void createUser(String string, String string2, int n) throws SecurityNotAuthorized, SecurityExistingUser, SecurityMaximumUsers, SecurityBadPassword {
        try {
            this.createUser(string, string2, eSecurityLevel.from_int(n));
        }
        catch (ExistingUser existingUser) {
            throw new SecurityExistingUser((UserException)existingUser);
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw new SecurityBadPassword((UserException)xBadPasswordSimple2);
        }
    }

    public void createUser(String string, String string2, eSecurityLevel eSecurityLevel2) throws ExistingUser, xBadPasswordSimple, SecurityMaximumUsers {
        try {
            Object[] objectArray = new Object[]{string, string2, eSecurityLevel2};
            this.createUser.set(objectArray);
        }
        catch (ExistingUser existingUser) {
            throw existingUser;
        }
        catch (xMaximumUsers xMaximumUsers2) {
            throw new SecurityMaximumUsers("Maximum number of users already exists");
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw xBadPasswordSimple2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deleteUser(String string) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityActiveUserSession, SecurityKeepOneSuperUser {
        try {
            this.deleteUser.set(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void clearSecurityViolationAlarm() {
        try {
            this.clearSecurityIntrusionAlarm.set();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserPassword(String string, String string2) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityBadPassword, SecurityBadPasswordToggling, SecurityBadPasswordFlipping, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, string2};
            this.userPassword.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw new SecurityBadPassword((UserException)xBadPasswordSimple2);
        }
        catch (xBadPasswordToggling xBadPasswordToggling2) {
            throw new SecurityBadPasswordToggling((UserException)xBadPasswordToggling2);
        }
        catch (xBadPasswordFlipping xBadPasswordFlipping2) {
            throw new SecurityBadPasswordFlipping((UserException)xBadPasswordFlipping2);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserSecurityLevel(String string, int n) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityKeepOneSuperUser, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, eSecurityLevel.from_int(n)};
            this.userSecurityLevel.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void changePassword(String string, String string2, String string3) throws SecurityNotAuthorized, SecurityUnknownUser, SecurityBadPassword, SecurityBadPasswordToggling, SecurityBadPasswordFlipping, SecurityNotAuthenticated {
        try {
            Object[] objectArray = new Object[]{string, string2, string3};
            this.userPassword.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xBadPasswordSimple xBadPasswordSimple2) {
            throw new SecurityBadPassword((UserException)xBadPasswordSimple2);
        }
        catch (xBadPasswordToggling xBadPasswordToggling2) {
            throw new SecurityBadPasswordToggling((UserException)xBadPasswordToggling2);
        }
        catch (xBadPasswordFlipping xBadPasswordFlipping2) {
            throw new SecurityBadPasswordFlipping((UserException)xBadPasswordFlipping2);
        }
        catch (NotAuthenticated notAuthenticated) {
            throw new SecurityNotAuthenticated((UserException)notAuthenticated);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public eSecurityLevel getUserSecurityLevel(String string) throws UnknownUser {
        try {
            return (eSecurityLevel)this.userSecurityLevel.get(string);
        }
        catch (UnknownUser unknownUser) {
            throw unknownUser;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getLockoutThreshold() {
        try {
            return ((sLockoutPolicy)this.lockoutPolicy.get()).maxBadLogins;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public boolean getLockoutForever() {
        try {
            return ((sLockoutPolicy)this.lockoutPolicy.get()).durationForever;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getLockoutDuration() {
        try {
            return ((sLockoutPolicy)this.lockoutPolicy.get()).lockoutSeconds;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setLockoutPolicy(int n, boolean bl, int n2) throws InvalidParams {
        sLockoutPolicy sLockoutPolicy2 = new sLockoutPolicy();
        sLockoutPolicy2.maxBadLogins = (short)n;
        sLockoutPolicy2.durationForever = bl;
        sLockoutPolicy2.lockoutSeconds = (short)n2;
        try {
            this.lockoutPolicy.set(sLockoutPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid Lockout Policy");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getPasswordTogglingPolicy() {
        try {
            return ((Short)this.passwordTogglingPolicy.get()).shortValue();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setPasswordTogglingPolicy(int n) throws InvalidParams {
        try {
            this.passwordTogglingPolicy.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid Password Change Policy");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getSingleSessionPerUser() {
        try {
            return (Boolean)this.singleSessionPerUser.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setSingleSessionPerUser(boolean bl) {
        try {
            this.singleSessionPerUser.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public String getLegalDisclaimer() {
        try {
            return (String)this.legalDisclaimer.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getLegalDisclaimerMaxLength() {
        return 1600;
    }

    public void setLegalDisclaimer(String string) throws Exception {
        if (string.length() > 1600) {
            throw new Exception("The login legal disclaimer field is limited to 1600 characters");
        }
        try {
            this.legalDisclaimer.set(string);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void adminLockUsername(String string) throws SecurityUnknownUser, SecurityKeepOneSuperUser, SecurityActiveUserSession {
        try {
            this.adminLockUsername.set(string);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void adminUnlockUsername(String string) throws SecurityUnknownUser, SecurityActiveUserSession {
        try {
            this.adminUnlockUsername.set(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void logoutUser(String string, IIpAddr iIpAddr, boolean bl) throws SecurityUnknownUser, SecurityUserNotLoggedIn, SecurityKeepOneSuperUser {
        try {
            Object[] objectArray = new Object[]{string, IpAddrFactory.getIpAddr(iIpAddr), new Boolean(bl)};
            this.logoutUser.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xUserNotLoggedIn xUserNotLoggedIn2) {
            throw new SecurityUserNotLoggedIn((UserException)xUserNotLoggedIn2);
        }
        catch (xKeepOneSuperUser xKeepOneSuperUser2) {
            throw new SecurityKeepOneSuperUser((UserException)xKeepOneSuperUser2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getIdleUserPolicy(eSecurityLevel eSecurityLevel2) {
        try {
            sIdleUserTimeout[] sIdleUserTimeoutArray = (sIdleUserTimeout[])this.idleUserTimeout.get();
            for (int i = 0; i < sIdleUserTimeoutArray.length; ++i) {
                if (sIdleUserTimeoutArray[i].securityLevel.value() != eSecurityLevel2.value()) continue;
                return sIdleUserTimeoutArray[i].timeoutMinutes;
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return 0;
    }

    public void setIdleUserPolicy(eSecurityLevel eSecurityLevel2, int n) throws InvalidParams {
        sIdleUserTimeout sIdleUserTimeout2 = new sIdleUserTimeout();
        sIdleUserTimeout2.securityLevel = eSecurityLevel2;
        sIdleUserTimeout2.timeoutMinutes = (short)n;
        try {
            this.idleUserTimeout.set(sIdleUserTimeout2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid User Idle Time");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public ISecurityPolicy getSecurityPolicy() {
        try {
            int n;
            sIdleUserTimeout[] sIdleUserTimeoutArray = (sIdleUserTimeout[])this.idleUserTimeout.get();
            sLockoutPolicy sLockoutPolicy2 = (sLockoutPolicy)this.lockoutPolicy.get();
            sPasswordFlippingPolicy sPasswordFlippingPolicy2 = (sPasswordFlippingPolicy)this.passwordFlippingPolicy.get();
            sPasswordExprPolicy sPasswordExprPolicy2 = (sPasswordExprPolicy)this.passwordExprPolicy.get();
            sDisableInactiveUserPolicy sDisableInactiveUserPolicy2 = (sDisableInactiveUserPolicy)this.disableInactiveUserPolicy.get();
            SecurityPolicy securityPolicy = new SecurityPolicy();
            for (n = 0; n < sIdleUserTimeoutArray.length; ++n) {
                securityPolicy.setIdleTimeout(sIdleUserTimeoutArray[n].securityLevel.value(), sIdleUserTimeoutArray[n].timeoutMinutes);
            }
            securityPolicy.setLockoutThreshold(sLockoutPolicy2.maxBadLogins);
            securityPolicy.setManualUnlock(sLockoutPolicy2.durationForever);
            securityPolicy.setLockoutDuration(sLockoutPolicy2.lockoutSeconds);
            securityPolicy.setPasswordReuseThreshold(this.getPasswordTogglingPolicy());
            securityPolicy.setSingleSessionPerUser(this.getSingleSessionPerUser());
            securityPolicy.setForcePasswordChange(this.getForcePasswordChange());
            securityPolicy.setPasswordFlippingPolicyEnabled(sPasswordFlippingPolicy2.enforce);
            securityPolicy.setPasswordFlippingPolicyThreshold(sPasswordFlippingPolicy2.minDaysBetweenChanges);
            securityPolicy.setDisableInactiveUserPolicyEnabled(sDisableInactiveUserPolicy2.enforce);
            securityPolicy.setMaxInactiveDaysBeforeDisable(sDisableInactiveUserPolicy2.maxInactiveDays);
            securityPolicy.setPasswordExprPolicyEnabled(sPasswordExprPolicy2.enforce);
            for (n = 0; n < sPasswordExprPolicy2.pwExprList.length; ++n) {
                sPasswordExpr sPasswordExpr2 = sPasswordExprPolicy2.pwExprList[n];
                securityPolicy.setPasswordExprPolicy(sPasswordExpr2.securityLevel.value(), sPasswordExpr2.numDaysPasswordValid, sPasswordExpr2.numDaysWarningPeriod);
            }
            return securityPolicy;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return DEF_POLICY;
        }
    }

    public void setSecurityPolicy(ISecurityPolicy iSecurityPolicy) throws InvalidParams {
        Object object;
        int n;
        int n2;
        ArrayList<sPasswordExpr> arrayList = new ArrayList<sPasswordExpr>();
        if (iSecurityPolicy.getLockoutThreshold() != this.getLockoutThreshold() || iSecurityPolicy.isManualUnlock() != this.getLockoutForever() || iSecurityPolicy.getLockoutDuration() != this.getLockoutDuration()) {
            this.setLockoutPolicy(iSecurityPolicy.getLockoutThreshold(), iSecurityPolicy.isManualUnlock(), iSecurityPolicy.getLockoutDuration());
        }
        if (iSecurityPolicy.getPasswordReuseThreshold() != this.getPasswordTogglingPolicy()) {
            this.setPasswordTogglingPolicy(iSecurityPolicy.getPasswordReuseThreshold());
        }
        if (iSecurityPolicy.isSingleSessionPerUser() != this.getSingleSessionPerUser()) {
            this.setSingleSessionPerUser(iSecurityPolicy.isSingleSessionPerUser());
        }
        for (n2 = 0; n2 < SecurityLevel.SECURITY_LEVELS.length; ++n2) {
            n = SecurityLevel.SECURITY_LEVELS[n2].value();
            object = eSecurityLevel.from_int(n);
            int n3 = iSecurityPolicy.getIdleTimeout(n);
            if (this.getIdleUserPolicy((eSecurityLevel)object) != n3) {
                this.setIdleUserPolicy((eSecurityLevel)object, n3);
            }
            int n4 = iSecurityPolicy.getPasswordExprPeriod(n);
            int n5 = iSecurityPolicy.getPasswordExprWarningPeriod(n);
            if (this.getPasswordExprAgingPeriod((eSecurityLevel)object) == n4 && this.getPasswordExprWarningPeriod((eSecurityLevel)object) == n5) continue;
            arrayList.add(SecurityModel.createPasswordExpr(object, n4, n5));
        }
        if (iSecurityPolicy.getForcePasswordChange() != this.getForcePasswordChange()) {
            this.setForcePasswordChange(iSecurityPolicy.getForcePasswordChange());
        }
        n2 = arrayList.size() > 0 || iSecurityPolicy.isPasswordExprPolicyEnabled() != this.getPasswordExprPolicyEnabled() ? 1 : 0;
        int n6 = n = iSecurityPolicy.getPasswordFlippingPolicyEnabled() != this.getPasswordFlippingPolicyEnabled() || iSecurityPolicy.getPasswordFlippingPolicyThreshold() != this.getPasswordFlippingPolicyThreshold() ? 1 : 0;
        if (n2 != 0 && n != 0 && iSecurityPolicy.getPasswordFlippingPolicyThreshold() < this.getPasswordFlippingPolicyThreshold()) {
            this.setPasswordFlippingPolicy(iSecurityPolicy.getPasswordFlippingPolicyEnabled(), iSecurityPolicy.getPasswordFlippingPolicyThreshold());
            n = 0;
        }
        if (n2 != 0) {
            object = new sPasswordExprPolicy();
            ((sPasswordExprPolicy)object).enforce = iSecurityPolicy.isPasswordExprPolicyEnabled();
            ((sPasswordExprPolicy)object).pwExprList = arrayList.toArray(new sPasswordExpr[arrayList.size()]);
            this.setPasswordExprPolicy((sPasswordExprPolicy)object);
        }
        if (n != 0) {
            this.setPasswordFlippingPolicy(iSecurityPolicy.getPasswordFlippingPolicyEnabled(), iSecurityPolicy.getPasswordFlippingPolicyThreshold());
        }
        if (iSecurityPolicy.getDisableInactiveUserPolicyEnabled() != this.getDisableInactiveUserPolicyEnabled() || iSecurityPolicy.getMaxInactiveDaysBeforeDisable() != this.getDisableInactiveUserPolicyThreshold()) {
            this.setDisableInactiveUserPolicy(iSecurityPolicy.getDisableInactiveUserPolicyEnabled(), iSecurityPolicy.getMaxInactiveDaysBeforeDisable());
        }
    }

    private UserInfoModel findUser(String string) {
        try {
            ArrayList arrayList = (ArrayList)this.userList.get();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                UserInfoModel userInfoModel = (UserInfoModel)iterator.next();
                if (!userInfoModel.getName().equals(string)) continue;
                return userInfoModel;
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return null;
    }

    public IUserInfoModel[] getLoggedOnUsers() {
        IActiveUserInfoModel[] iActiveUserInfoModelArray = this.getActiveUsers();
        IUserInfoModel[] iUserInfoModelArray = null;
        if (iActiveUserInfoModelArray != null) {
            iUserInfoModelArray = new IUserInfoModel[iActiveUserInfoModelArray.length];
            for (int i = 0; i < iActiveUserInfoModelArray.length; ++i) {
                iUserInfoModelArray[i] = this.findUser(iActiveUserInfoModelArray[i].getUserId());
            }
        }
        return iUserInfoModelArray;
    }

    public boolean getForcePasswordChange() {
        try {
            return (Boolean)this.forcePasswordChange.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setForcePasswordChange(boolean bl) {
        try {
            this.forcePasswordChange.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserForcePasswordChange(String string, boolean bl) throws SecurityUnknownUser, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE};
            this.userForcePasswordChange.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean isPasswordChangeRequired(String string) throws SecurityUnknownUser {
        try {
            return (Boolean)this.requirePasswordChange.get(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getRemainingPasswordDays(String string) throws SecurityUnknownUser {
        try {
            return (Integer)this.passwordCloseToExpiring.get(string);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public boolean getPasswordFlippingPolicyEnabled() {
        try {
            return ((sPasswordFlippingPolicy)this.passwordFlippingPolicy.get()).enforce;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getPasswordFlippingPolicyThreshold() {
        try {
            return ((sPasswordFlippingPolicy)this.passwordFlippingPolicy.get()).minDaysBetweenChanges;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setPasswordFlippingPolicy(boolean bl, int n) throws InvalidParams {
        try {
            sPasswordFlippingPolicy sPasswordFlippingPolicy2 = new sPasswordFlippingPolicy();
            sPasswordFlippingPolicy2.enforce = bl;
            sPasswordFlippingPolicy2.minDaysBetweenChanges = (short)n;
            this.passwordFlippingPolicy.set(sPasswordFlippingPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid minimum days to change password policy.\n The value must be between 20 and 95 days \nand less than password aging period.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getDisableInactiveUserPolicyEnabled() {
        try {
            return ((sDisableInactiveUserPolicy)this.disableInactiveUserPolicy.get()).enforce;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getDisableInactiveUserPolicyThreshold() {
        try {
            return ((sDisableInactiveUserPolicy)this.disableInactiveUserPolicy.get()).maxInactiveDays;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setDisableInactiveUserPolicy(boolean bl, int n) throws InvalidParams {
        sDisableInactiveUserPolicy sDisableInactiveUserPolicy2 = new sDisableInactiveUserPolicy();
        sDisableInactiveUserPolicy2.enforce = bl;
        sDisableInactiveUserPolicy2.maxInactiveDays = (short)n;
        try {
            this.disableInactiveUserPolicy.set(sDisableInactiveUserPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid disable UserId policy.\nThe idle duration must be between 45 and 90 days");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setUserDisabled(String string, boolean bl) throws SecurityUnknownUser, SecurityActiveUserSession {
        try {
            Object[] objectArray = new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE};
            this.userDisabled.set(objectArray);
        }
        catch (UnknownUser unknownUser) {
            throw new SecurityUnknownUser((UserException)unknownUser);
        }
        catch (xActiveUserSession xActiveUserSession2) {
            throw new SecurityActiveUserSession((UserException)xActiveUserSession2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setPasswordExprPolicyEnabled(boolean bl) throws InvalidParams {
        sPasswordExprPolicy sPasswordExprPolicy2 = new sPasswordExprPolicy();
        sPasswordExprPolicy2.enforce = bl;
        sPasswordExprPolicy2.pwExprList = new sPasswordExpr[0];
        this.setPasswordExprPolicy(sPasswordExprPolicy2);
    }

    public void setPasswordExprPolicy(eSecurityLevel eSecurityLevel2, int n, int n2) throws InvalidParams {
        sPasswordExprPolicy sPasswordExprPolicy2 = new sPasswordExprPolicy();
        sPasswordExprPolicy2.enforce = this.getPasswordExprPolicyEnabled();
        sPasswordExprPolicy2.pwExprList = new sPasswordExpr[1];
        sPasswordExprPolicy2.pwExprList[0] = SecurityModel.createPasswordExpr(eSecurityLevel2, n, n2);
        this.setPasswordExprPolicy(sPasswordExprPolicy2);
    }

    public boolean getPasswordExprPolicyEnabled() {
        try {
            return ((sPasswordExprPolicy)this.passwordExprPolicy.get()).enforce;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public int getPasswordExprAgingPeriod(eSecurityLevel eSecurityLevel2) {
        sPasswordExpr sPasswordExpr2 = this.getPasswordExpr(eSecurityLevel2);
        return sPasswordExpr2 == null ? (short)0 : sPasswordExpr2.numDaysPasswordValid;
    }

    public int getPasswordExprWarningPeriod(eSecurityLevel eSecurityLevel2) {
        sPasswordExpr sPasswordExpr2 = this.getPasswordExpr(eSecurityLevel2);
        return sPasswordExpr2 == null ? (short)0 : sPasswordExpr2.numDaysWarningPeriod;
    }

    private sPasswordExpr getPasswordExpr(eSecurityLevel eSecurityLevel2) {
        try {
            sPasswordExprPolicy sPasswordExprPolicy2 = (sPasswordExprPolicy)this.passwordExprPolicy.get();
            for (int i = 0; i < sPasswordExprPolicy2.pwExprList.length; ++i) {
                if (sPasswordExprPolicy2.pwExprList[i].securityLevel != eSecurityLevel2) continue;
                return sPasswordExprPolicy2.pwExprList[i];
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return null;
    }

    private void setPasswordExprPolicy(sPasswordExprPolicy sPasswordExprPolicy2) throws InvalidParams {
        try {
            this.passwordExprPolicy.set(sPasswordExprPolicy2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid password aging policy.\nThe password aging period must be between 20 and 90 days\nand greater than the password change waiting period.\nThe password warning period must be between 2 and 20 days");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getFrontLANAccess() {
        try {
            return (Boolean)this.frontLanAccess.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean getBackLANAccess() {
        try {
            return (Boolean)this.backLanAccess.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public LANAccessMode getLANAccess() {
        return LANAccessMode.from_int((this.getFrontLANAccess() ? 2 : 0) + (this.getBackLANAccess() ? 1 : 0));
    }

    public void setLANAccess(LANAccessMode lANAccessMode) throws DccNotConnected, OperationFailed, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{lANAccessMode.isFrontLANAccessEnabled() ? Boolean.TRUE : Boolean.FALSE, lANAccessMode.isBackLANAccessEnabled() ? Boolean.TRUE : Boolean.FALSE};
            this.backLanAccess.set(objectArray);
        }
        catch (xDccNotConnected xDccNotConnected2) {
            throw new DccNotConnected((UserException)xDccNotConnected2);
        }
        catch (xOperationFailed xOperationFailed2) {
            throw new OperationFailed((UserException)xOperationFailed2);
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw new UnsupportedOperation((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getLANAccessTimeout() {
        try {
            return ((Short)this.lanAccessTimeout.get()).shortValue();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setLANAccessTimeout(int n) throws InvalidParams {
        try {
            this.lanAccessTimeout.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid LAN access timeout.\nThe value must be between 0 and 60 minutes");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getSerialPortAccess() {
        try {
            return (Boolean)this.serialPortAccess.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setSerialPortAccess(boolean bl) {
        try {
            this.serialPortAccess.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getTelnetPort() {
        try {
            return (Short)this.telnetPort.get() & 0xFFFF;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public int getStandardTelnetPort() {
        return 23;
    }

    public void setTelnetPort(int n) throws InvalidParams, PortInUse {
        try {
            this.telnetPort.set(new Short((short)n));
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams(TELNET_PORT_ERROR_MSG);
        }
        catch (xPortInUse xPortInUse2) {
            throw new PortInUse("There is an active TELNET session.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getSshPort() {
        return 22;
    }

    public boolean isSshEnabled() {
        try {
            return (Boolean)this.enableSsh.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setSshEnabled(boolean bl) throws xOperationNotSupported {
        try {
            this.enableSsh.set(new Boolean(bl));
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw xOperationNotSupported2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "setSshEnabled", userException);
        }
    }

    public boolean isEnforceShellPassword() {
        try {
            return (Boolean)this.enforceShellPassword.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setEnforceShellPasswordOn() {
        try {
            this.enforceShellPassword.set(null);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setEnforceShellPasswordOff(String string) throws NotAuthenticated {
        try {
            this.enforceShellPassword.set(string);
        }
        catch (NotAuthenticated notAuthenticated) {
            throw notAuthenticated;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public eSecurityLevel getPmClearingPrivilege() {
        try {
            return (eSecurityLevel)this.pmClearingPrivilege.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return eSecurityLevel.SUPERUSER;
        }
    }

    public void setPmClearingPrivilege(eSecurityLevel eSecurityLevel2) throws InvalidParams {
        try {
            this.pmClearingPrivilege.set(eSecurityLevel2);
        }
        catch (xInvalidParms xInvalidParms2) {
            throw new InvalidParams("Invalid security level");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getAlarmOnLostBackLanLink() {
        try {
            return (Boolean)this.alarmOnLostBackLanLink.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setAlarmOnLostBackLanLink(boolean bl) throws UnsupportedOperation {
        try {
            this.alarmOnLostBackLanLink.set(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (xOperationNotSupported xOperationNotSupported2) {
            throw new UnsupportedOperation((UserException)xOperationNotSupported2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter SecurityModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 0, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 1, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 2, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 3, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 4, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSecurity, 5, (Observer)this);
        }
        this.userList.dispose();
        this.activeUserList.dispose();
        this.lockoutPolicy.dispose();
        this.passwordTogglingPolicy.dispose();
        this.singleSessionPerUser.dispose();
        this.legalDisclaimer.dispose();
        this.forcePasswordChange.dispose();
        this.passwordFlippingPolicy.dispose();
        this.passwordExprPolicy.dispose();
        this.disableInactiveUserPolicy.dispose();
        this.frontLanAccess.dispose();
        this.backLanAccess.dispose();
        this.lanAccessTimeout.dispose();
        this.serialPortAccess.dispose();
        this.telnetPort.dispose();
        this.enableSsh.dispose();
        this.enforceShellPassword.dispose();
        this.pmClearingPrivilege.dispose();
        this.alarmOnLostBackLanLink.dispose();
        this.idleUserTimeout.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        Integer n = ModelUpdateType.CHANGED;
        if (this.db.on) {
            this.db.println("Enter SecurityModel update()");
        }
        switch (((IObjectMessageInfo)object).getIndex()) {
            case 0: {
                this.userList.update();
                break;
            }
            case 1: {
                this.legalDisclaimer.update();
                break;
            }
            case 2: {
                this.activeUserList.update();
                break;
            }
            case 3: {
                this.lockoutPolicy.update();
                this.passwordTogglingPolicy.update();
                this.singleSessionPerUser.update();
                this.idleUserTimeout.update();
                this.forcePasswordChange.update();
                this.passwordFlippingPolicy.update();
                this.passwordExprPolicy.update();
                this.disableInactiveUserPolicy.update();
                this.backLanAccess.update();
                this.lanAccessTimeout.update();
                this.serialPortAccess.update();
                this.telnetPort.update();
                this.pmClearingPrivilege.update();
                this.passwordFlippingPolicy.update();
                this.passwordExprPolicy.update();
                this.disableInactiveUserPolicy.update();
                break;
            }
            case 5: {
                this.frontLanAccess.update();
                this.backLanAccess.update();
                this.lanAccessTimeout.update();
                this.serialPortAccess.update();
                this.telnetPort.update();
                this.enableSsh.update();
                this.enforceShellPassword.update();
                this.pmClearingPrivilege.update();
                this.alarmOnLostBackLanLink.update();
                break;
            }
            case 4: {
                this.activeUserList.update();
                if (!this.nodeModel.forcedLogout()) break;
                n = ModelUpdateType.LOGOUT;
                break;
            }
            default: {
                if (!this.db.on) break;
                this.db.println("Unknown notification index from securityObject");
            }
        }
        this.setChanged();
        this.notifyObservers(n);
    }

    private static sPasswordExpr createPasswordExpr(eSecurityLevel eSecurityLevel2, int n, int n2) {
        sPasswordExpr sPasswordExpr2 = new sPasswordExpr();
        sPasswordExpr2.securityLevel = eSecurityLevel2;
        sPasswordExpr2.numDaysPasswordValid = (short)n;
        sPasswordExpr2.numDaysWarningPeriod = (short)n2;
        return sPasswordExpr2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TELNET_PORT_ERROR_MSG = "The node failed to restart the TELNET service on the\nselected port. Try using another port that is not\nbeing used within the following ranges:\n\n  23, 1001-2000, 2019-2360, 2362-9999\n\nNote: You will not be able to use ports already in use.";
        NO_WARNING = new Integer(-1);
        DEF_POLICY = new SecurityPolicy();
    }

    class AlarmOnLostBackLanLink
    extends CachedValue {
        public AlarmOnLostBackLanLink(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().isAlarmOnLostBackLanLinkEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setAlarmOnLostBackLanLink((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PmClearingPrivilege
    extends CachedValue {
        public PmClearingPrivilege(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPmClearingPrivilege();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPmClearingPrivilege((eSecurityLevel)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class EnforceShellPassword
    extends CachedValue {
        public EnforceShellPassword(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(SecurityModel.this.getSecurityRef().getEnforceShellPassword());
        }

        protected void setValue(Object object) throws UserException {
            if (object == null) {
                SecurityModel.this.getSecurityRef().setEnforceShellPasswordOn();
            } else {
                SecurityModel.this.getSecurityRef().setEnforceShellPasswordOff((String)object);
            }
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class EnableSsh
    extends CachedValue {
        public EnableSsh(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(SecurityModel.this.getSecurityRef().isSshEnabled());
        }

        protected void setValue(Object object) throws xOperationNotSupported {
            SecurityModel.this.getSecurityRef().setSshEnabled((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class TelnetPort
    extends CachedValue {
        public TelnetPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getTelnetPort());
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setTelnetPort((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class SerialPortAccess
    extends CachedValue {
        public SerialPortAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getSerialPortAccess() ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setSerialPortAccess((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LANAccessTimeout
    extends CachedValue {
        public LANAccessTimeout(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getLanAccessTimeout());
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setLanAccessTimeout((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class BackLANAccess
    extends CachedValue {
        public BackLANAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getBackLanAccess() ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setBothLanAccess((Boolean)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class FrontLANAccess
    extends CachedValue {
        public FrontLANAccess(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getFrontLanAccess() ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserDisabled
    extends NonCachedValue {
        public UserDisabled(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setUserDisabled((String)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class DisableInactiveUserPolicy
    extends CachedValue {
        public DisableInactiveUserPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getDisableInactiveUserPolicy();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setDisableInactiveUserPolicy((sDisableInactiveUserPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordCloseToExpiring
    extends NonCachedValue {
        public PasswordCloseToExpiring(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            ShortHolder shortHolder = new ShortHolder();
            if (SecurityModel.this.getSecurityRef().isPasswordCloseToExpiring((String)object, shortHolder)) {
                return new Integer(shortHolder.value);
            }
            return NO_WARNING;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordExprPolicy
    extends CachedValue {
        public PasswordExprPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPasswordExprPolicy();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordExprPolicy((sPasswordExprPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordFlippingPolicy
    extends CachedValue {
        public PasswordFlippingPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getPasswordFlippingPolicy();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordFlippingPolicy((sPasswordFlippingPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class RequirePasswordChange
    extends NonCachedValue {
        public RequirePasswordChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return SecurityModel.this.getSecurityRef().isPasswordChangeRequired((String)object) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserForcePasswordChange
    extends NonCachedValue {
        public UserForcePasswordChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setUserForcePasswordChange((String)objectArray[0], (Boolean)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class ForcePasswordChange
    extends CachedValue {
        public ForcePasswordChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getDefaultForcePasswordChange() ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setDefaultForcePasswordChange((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class Login
    extends NonCachedValue {
        public Login(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return new Integer(SecurityModel.this.getSecurityRef().login((String)objectArray[0], (String)objectArray[1], (sIpAddr)objectArray[2]));
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class Logout
    extends NonCachedValue {
        public Logout(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            SecurityModel.this.getSecurityRef().logout();
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LogoutUser
    extends NonCachedValue {
        public LogoutUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            String string = (String)objectArray[0];
            sIpAddr sIpAddr2 = (sIpAddr)objectArray[1];
            boolean bl = (Boolean)objectArray[2];
            SecurityModel.this.getSecurityRef().logoutUser(string, sIpAddr2, bl);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class AdminUnlockUsername
    extends NonCachedValue {
        public AdminUnlockUsername(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().adminUnlockUsername((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class AdminLockUsername
    extends NonCachedValue {
        public AdminLockUsername(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().adminLockUsername((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserSecurityLevel
    extends NonCachedValue {
        public UserSecurityLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return SecurityModel.this.getSecurityRef().getUserSecurityLevel((String)object);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().setUserSecurityLevel((String)objectArray[0], (eSecurityLevel)objectArray[1]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserPassword
    extends NonCachedValue {
        public UserPassword(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 2) {
                SecurityModel.this.getSecurityRef().setUserPassword((String)objectArray[0], (String)objectArray[1]);
            } else if (objectArray.length == 3) {
                SecurityModel.this.getSecurityRef().changePassword((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
            } else {
                throw new IllegalArgumentException("UserPassword.setValue: internal error: expecting an array of length 2 or 3");
            }
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class ClearSecurityIntrusionAlarm
    extends NonCachedValue {
        public ClearSecurityIntrusionAlarm(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            SecurityModel.this.getSecurityRef().clearSecurityIntrusionAlarm();
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class DeleteUser
    extends NonCachedValue {
        public DeleteUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().deleteUser((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class CreateUser
    extends NonCachedValue {
        public CreateUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            SecurityModel.this.getSecurityRef().createUser((String)objectArray[0], (String)objectArray[1], (eSecurityLevel)objectArray[2]);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class UserList
    extends CachedValue {
        public UserList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            List list = (List)this.value;
            ArrayList<UserInfoModel> arrayList = new ArrayList<UserInfoModel>();
            userInfo[] userInfoArray = SecurityModel.this.getSecurityRef().users();
            if (list == null || list.isEmpty()) {
                for (int i = 0; i < userInfoArray.length; ++i) {
                    arrayList.add(new UserInfoModel(SecurityModel.this.nodeModel, userInfoArray[i]));
                }
            } else {
                for (int i = 0; i < userInfoArray.length; ++i) {
                    UserInfoModel userInfoModel = null;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        UserInfoModel userInfoModel2 = (UserInfoModel)iterator.next();
                        if (userInfoModel2.getName() != userInfoArray[i].name) continue;
                        userInfoModel = userInfoModel2;
                        iterator.remove();
                        break;
                    }
                    if (userInfoModel == null) {
                        userInfoModel = new UserInfoModel(SecurityModel.this.nodeModel, userInfoArray[i]);
                    }
                    arrayList.add(userInfoModel);
                }
            }
            return arrayList;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class ActiveUserList
    extends CachedValue {
        public ActiveUserList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            List list = (List)this.value;
            ArrayList<ActiveUserInfoModel> arrayList = new ArrayList<ActiveUserInfoModel>();
            sActiveUserInfo[] sActiveUserInfoArray = SecurityModel.this.getSecurityRef().loggedOnUsers();
            if (list == null || list.isEmpty()) {
                for (int i = 0; i < sActiveUserInfoArray.length; ++i) {
                    arrayList.add(new ActiveUserInfoModel(SecurityModel.this.nodeModel, sActiveUserInfoArray[i]));
                }
            } else {
                for (int i = 0; i < sActiveUserInfoArray.length; ++i) {
                    ActiveUserInfoModel activeUserInfoModel = null;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ActiveUserInfoModel activeUserInfoModel2 = (ActiveUserInfoModel)iterator.next();
                        if (activeUserInfoModel2.getUserId() != sActiveUserInfoArray[i].userId) continue;
                        activeUserInfoModel = activeUserInfoModel2;
                        iterator.remove();
                        break;
                    }
                    if (activeUserInfoModel == null) {
                        activeUserInfoModel = new ActiveUserInfoModel(SecurityModel.this.nodeModel, sActiveUserInfoArray[i]);
                    }
                    arrayList.add(activeUserInfoModel);
                }
            }
            return arrayList;
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class IdleUserTimeout
    extends CachedValue {
        public IdleUserTimeout(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getIdleUserTimeoutList();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setIdleUserTimeOut((sIdleUserTimeout)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LegalDisclaimer
    extends CachedValue {
        public LegalDisclaimer(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getDisclaimer();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setDisclaimer((String)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class SingleSessionPerUser
    extends CachedValue {
        public SingleSessionPerUser(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getOneActiveLogin() ? Boolean.TRUE : Boolean.FALSE;
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setOneActiveLogin((Boolean)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class PasswordTogglingPolicy
    extends CachedValue {
        public PasswordTogglingPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(SecurityModel.this.getSecurityRef().getPasswordTogglingPolicy());
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setPasswordTogglingPolicy((Short)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }

    class LockoutPolicy
    extends CachedValue {
        public LockoutPolicy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return SecurityModel.this.getSecurityRef().getLockoutPolicy();
        }

        protected void setValue(Object object) throws UserException {
            SecurityModel.this.getSecurityRef().setLockoutPolicy((sLockoutPolicy)object);
        }

        public Object outer() {
            return SecurityModel.this;
        }
    }
}

