/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sCircuitRetryRw;
import cerent.cms.idl.Ucp.sRsvpNodeRw;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xNodeIdInUse;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeIdInUse;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.ucp.Ipccs;
import cerent.cms.model.ucp.UcpInterfaces;
import cerent.cms.model.ucp.UcpNeighbors;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class UcpNodeModel
extends Model {
    private NodeModelDelegate node;
    private NodeId nodeId;
    private RetryConfig retryConfig;
    private RsvpConfig rsvpConfig;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection ucpNodeModelSingletons;
    static /* synthetic */ Class class$cerent$cms$model$ucp$UcpNodeModel;

    public static synchronized UcpNodeModel getInstance(NodeModelDelegate nodeModelDelegate) {
        UcpNodeModel ucpNodeModel;
        if (ucpNodeModelSingletons == null) {
            ucpNodeModelSingletons = ModelSingletonCollection.getMSCInstanceByName("UcpNodeModel");
        }
        if ((ucpNodeModel = (UcpNodeModel)ucpNodeModelSingletons.get(nodeModelDelegate)) == null) {
            ucpNodeModel = new UcpNodeModel(nodeModelDelegate);
            ucpNodeModelSingletons.add(nodeModelDelegate, ucpNodeModel);
        }
        return ucpNodeModel;
    }

    private UcpNodeModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$ucp$UcpNodeModel == null ? (class$cerent$cms$model$ucp$UcpNodeModel = UcpNodeModel.class$("cerent.cms.model.ucp.UcpNodeModel")) : class$cerent$cms$model$ucp$UcpNodeModel));
        this.node = nodeModelDelegate;
        this.nodeId = new NodeId(nodeModelDelegate, "UcpNodeModel.nodeId");
        this.retryConfig = new RetryConfig(nodeModelDelegate, "UcpNodeModel.retryConfig");
        this.rsvpConfig = new RsvpConfig(nodeModelDelegate, "UcpNodeModel.rsvpConfig");
        this.dispatcher = null;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public int getNodeId() {
        int n = 0;
        try {
            n = (Integer)this.nodeId.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return n;
    }

    public void setNodeId(int n) throws NodeIdInUse, InvalidParams {
        try {
            this.nodeId.set(new Integer(n));
        }
        catch (xNodeIdInUse xNodeIdInUse2) {
            throw new NodeIdInUse(AnnotatedException.getString((Exception)((Object)xNodeIdInUse2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sCircuitRetryRw getRetryConfig() {
        sCircuitRetryRw sCircuitRetryRw2 = null;
        try {
            sCircuitRetryRw2 = (sCircuitRetryRw)this.retryConfig.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return sCircuitRetryRw2;
    }

    public void setRetryConfig(sCircuitRetryRw sCircuitRetryRw2) throws InvalidParams {
        try {
            this.retryConfig.set(sCircuitRetryRw2);
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sRsvpNodeRw getRsvpConfig() {
        sRsvpNodeRw sRsvpNodeRw2 = null;
        try {
            sRsvpNodeRw2 = (sRsvpNodeRw)this.rsvpConfig.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return sRsvpNodeRw2;
    }

    public void setRsvpConfig(sRsvpNodeRw sRsvpNodeRw2) throws InvalidParams {
        try {
            this.rsvpConfig.set(sRsvpNodeRw2);
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public UcpInterfaces getUcpInterfaces() {
        return UcpInterfaces.getInstance(this.node);
    }

    public UcpNeighbors getUcpNeighbors() {
        return UcpNeighbors.getInstance(this.node);
    }

    public Ipccs getIpccs() {
        return Ipccs.getInstance(this.node);
    }

    protected void updateLocal() {
        this.nodeId.update();
        this.rsvpConfig.update();
        this.retryConfig.update();
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update():    this DELETED");
                    }
                    this.delete();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " update():    thisCHANGED");
                    }
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + " update():    STRUCTURE CHANGED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println(this.getClass().getName() + "update():    " + "UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectUcpNode, 0, (Observer)this);
        }
        this.getUcpNeighbors().init();
        this.getUcpInterfaces().init();
        this.getIpccs().init();
    }

    public void delete() {
        this.dispose();
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectUcpNode, 0, (Observer)this);
        }
        this.getIpccs().dispose();
        this.getUcpNeighbors().dispose();
        this.getUcpInterfaces().dispose();
        this.nodeId.dispose();
        this.retryConfig.dispose();
        this.rsvpConfig.dispose();
        super.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RsvpConfig
    extends CachedValue {
        public RsvpConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpNodeRef().rsvpConfig();
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getUcpNodeRef().setRsvpNodeConfig((sRsvpNodeRw)object);
        }

        protected Object cloneValue() {
            sRsvpNodeRw sRsvpNodeRw2 = (sRsvpNodeRw)this.value;
            sRsvpNodeRw sRsvpNodeRw3 = new sRsvpNodeRw(sRsvpNodeRw2.restartTime, sRsvpNodeRw2.recoveryTime, sRsvpNodeRw2.rxmtInterval, sRsvpNodeRw2.refreshInterval, sRsvpNodeRw2.resvTimeout, sRsvpNodeRw2.resvConfTimeout, sRsvpNodeRw2.sourceDip, sRsvpNodeRw2.destinationDip);
            return sRsvpNodeRw3;
        }

        public Object outer() {
            return UcpNodeModel.this;
        }
    }

    private class RetryConfig
    extends CachedValue {
        public RetryConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpNodeRef().retryConfig();
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getUcpNodeRef().setRetryConfig((sCircuitRetryRw)object);
        }

        protected Object cloneValue() {
            sCircuitRetryRw sCircuitRetryRw2 = (sCircuitRetryRw)this.value;
            sCircuitRetryRw sCircuitRetryRw3 = new sCircuitRetryRw(sCircuitRetryRw2.initialRetryInterval, sCircuitRetryRw2.maxRetryInterval);
            return sCircuitRetryRw3;
        }

        public Object outer() {
            return UcpNodeModel.this;
        }
    }

    private class NodeId
    extends CachedValue {
        public NodeId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(this.node.getIorRepository().getUcpNodeRef().nodeId());
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getUcpNodeRef().setNodeId((Integer)object);
        }

        public Object outer() {
            return UcpNodeModel.this;
        }
    }
}

