/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmHoModel;
import cerent.cms.ui.AbstractHoProvTableModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class AbstractHoProvPane
extends NodeProvPane
implements TableModelListener {
    protected AbstractHoProvTableModel dataModel = null;
    protected TdmHoModel[] hoModels = null;
    protected InterfaceModel[] lineModels = null;
    protected int indexOfHo = 0;
    protected Runnable addDeleteThread = null;
    protected static final SDebug db = new SDebug("AbstractHoProv");
    private ObservableManager _obsMgr = null;

    public AbstractHoProvPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, int n) {
        super(string, tabbedView);
        this.lineModels = interfaceModelArray;
        this.indexOfHo = n;
        this.hoModels = this.getHO(interfaceModelArray, n);
        this.initializeTable();
        this.registerWithModel();
    }

    protected ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected abstract AbstractHoProvTableModel getHoProvTableModel();

    public abstract void applyChangesToModel() throws Exception;

    protected void initColumns() {
    }

    protected void initializeTable() {
        TableColumn tableColumn = null;
        Object var2_2 = null;
        this.dataModel = this.getHoProvTableModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(150);
        this.initColumns();
        this.table.setAutoCreateColumnsFromModel(false);
        this.add((Component)uScrollPane, "Center");
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public Attribute[] getAttributeArray(String string) {
        return this.dataModel.getAttributeMap().getAttributeArray(string);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.hoModels.length; ++i) {
            for (int j = 0; j < this.dataModel.getColumnCount(); ++j) {
                if (!this.dataModel.isDirty(i, j)) continue;
                if (db.on()) {
                    db.println("setting dirty (" + i + "," + j + ")");
                }
                this.setDirty();
                return;
            }
        }
        this.resetDirty();
    }

    protected void changeMessage(Observable observable, Object object) {
        int n;
        if (db.on()) {
            db.println("got a changed message from " + observable);
        }
        if ((n = Arrays.asList(this.hoModels).indexOf(observable)) != -1) {
            this.requestRefresh(observable, new Runnable(){

                public void run() {
                    AbstractHoProvPane.this.dataModel.refreshLineFromModel(n);
                }
            });
        } else if (db.on()) {
            db.println("Error in finding the changed line in response to update");
        }
    }

    protected void deleteMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got a delete message from " + observable);
        }
        this.initializeLines();
        super.deleteMessage(observable, object);
    }

    protected void structureChangeMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got an added message from " + observable);
        }
        this.initializeLines();
        super.structureChangeMessage(observable, object);
    }

    protected void registerWithModel() {
        this.registerForUpdates();
        super.registerWithModel();
    }

    protected void registerForUpdates() {
        this.getObsMgr().addObservable((Observable[])this.hoModels);
        this.getObsMgr().addObservable((Observable[])this.lineModels);
    }

    protected void deregisterForUpdates() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.hoModels);
            this._obsMgr.removeObservable((Observable[])this.lineModels);
        }
    }

    protected synchronized void initializeLines() {
        if (this._obsMgr != null) {
            this._obsMgr.removeObservable((Observable[])this.hoModels);
        }
        this.hoModels = this.getHO(this.lineModels, this.indexOfHo);
        if (this._obsMgr != null) {
            this._obsMgr.addObservable((Observable[])this.hoModels);
        }
        this.dataModel.setHoModel(this.hoModels);
    }

    protected TdmHoModel[] getHO(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, n);
        return collection.toArray(new TdmHoModel[0]);
    }

    public void dispose() {
        this.deregisterForUpdates();
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate || object instanceof EtherLineUpdate) {
            this.deregisterForUpdates();
            if (object instanceof OcnLineUpdate) {
                this.lineModels = (InterfaceModel[])((OcnLineUpdate)object).getModels();
            } else if (object instanceof EtherLineUpdate) {
                this.lineModels = ((EtherLineUpdate)object).getPosLineModels();
            }
            this.initializeLines();
            this.registerForUpdates();
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void setShowing(boolean bl) throws Exception {
        if (bl) {
            this.initializeLines();
        }
        super.setShowing(bl);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }
}

