/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PpmUpdate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.AlarmProfileListCellRenderer;
import cerent.cms.ui.AlarmProfileTableCellRenderer;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CardProvAlarmsTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.SDebug;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CardProvAlarmsBehaviorPane
extends AbstractProvTablePane
implements TableModelListener {
    private static final SDebug db = new SDebug("CardProvAlarmsBehaviorPane");
    protected String[] profileNames;
    protected JComboBox profileComboBox;
    protected JComboBox forceComboBox;
    protected JButton forceButton = new JButton("Force (still need to \"Apply\")");
    protected JLabel parentProfileLabel = new JLabel();
    protected ModuleModel cardModel = null;
    private EntityModel shelfModel = null;
    private boolean _inited;

    protected CardProvAlarmsTableModel getDataModel() {
        return (CardProvAlarmsTableModel)this.dataModel;
    }

    protected synchronized void initializeComboBox() {
        if (this.dataModel == null || this.table == null || this.profileComboBox == null || this.forceComboBox == null) {
            db.println("NPE/s in initializeCombobox; the following are null:");
            db.println("\tdataModel? " + (this.dataModel == null) + "\t" + "table? " + (this.dataModel == null));
            db.println("\tprofileCB? " + (this.profileComboBox == null) + "\t" + "forceCB? " + (this.forceComboBox == null));
            return;
        }
        this.table.editingCanceled(new ChangeEvent(this.table));
        String string = (String)this.forceComboBox.getSelectedItem();
        this.profileComboBox.removeAllItems();
        this.forceComboBox.removeAllItems();
        this.profileNames = this.getDataModel().getProfileNames();
        for (int i = 0; i < this.profileNames.length; ++i) {
            this.profileComboBox.addItem(this.profileNames[i]);
            this.forceComboBox.addItem(this.profileNames[i]);
        }
        this.profileComboBox.setRenderer(new AlarmProfileListCellRenderer("Card"));
        this.forceComboBox.setRenderer(new AlarmProfileListCellRenderer("Card"));
        this.forceComboBox.setSelectedItem(string);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this._inited) {
            this.initializeComboBox();
        }
    }

    protected void initializeTableColumns() {
        JTable jTable = this.getTable();
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = jTable.getColumn(tableModel.getColumnName(0));
        tableColumn.setPreferredWidth(200);
        TableColumn tableColumn2 = jTable.getColumn(tableModel.getColumnName(1));
        tableColumn2.setCellRenderer(new AlarmProfileTableCellRenderer("Card"));
        tableColumn2.setCellEditor(new DefaultCellEditor(this.profileComboBox));
        tableColumn2.setPreferredWidth(175);
        TableColumn tableColumn3 = jTable.getColumn(tableModel.getColumnName(2));
        tableColumn3.setPreferredWidth(120);
    }

    public void changeMessage(Observable observable, Object object) {
        this.updateCardData();
        super.changeMessage(observable, object);
    }

    protected void updateCardData() {
        boolean bl = false;
        boolean bl2 = false;
        String string = "unknown";
        if (this.cardModel != null) {
            try {
                bl = this.cardModel.getSuppressAlarms();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (!bl && this.shelfModel != null) {
                try {
                    bl2 = this.shelfModel.getSuppressAlarms();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                string = this.cardModel.getAlarmProfileName();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        string = AlarmProfileTableCellRenderer.getProfileNameString(string, "Node");
        this.parentProfileLabel.setText("Parent Card Profile: " + string + ", Suppressed: " + (bl ? "Yes (at card)" : (bl2 ? "Yes (at shelf)" : "No")));
    }

    protected JPanel createBottomPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        jPanel.add(new JLabel("Force all ports to profile: "));
        jPanel.add(this.forceComboBox);
        jPanel.add(this.forceButton);
        this.forceButton.addActionListener(new ForceListener());
        return jPanel;
    }

    protected Attribute[] getAttributes(String string) {
        return this.getDataModel().getAttributeMap().getAttributeArray(string);
    }

    public CardProvAlarmsBehaviorPane(String string, TabbedView tabbedView) {
        this(string, tabbedView, (ModuleModel)tabbedView.getUiModel());
    }

    public CardProvAlarmsBehaviorPane(String string, TabbedView tabbedView, ModuleModel moduleModel) {
        super(string, tabbedView, new CardProvAlarmsTableModel(moduleModel), true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.cardModel = moduleModel;
        this.shelfModel = (EntityModel)this.cardModel.getParent().getParent().getParent();
        this._inited = false;
    }

    private void init() {
        this._inited = true;
        this.profileComboBox = new JComboBox();
        this.forceComboBox = new JComboBox();
        this.initializeComboBox();
        this.initializeTableColumns();
        this.forceComboBox.setSelectedIndex(0);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.enableComponent(this.forceComboBox);
        this.enableComponent(this.forceButton);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        jPanel.add(this.parentProfileLabel);
        this.add(jPanel, "North");
        this.add(this.createBottomPanel(), "South");
        this.getDataModel().addTableModelListener(this);
        this.getDataModel().init();
        this.getObservableManager().addObservable((Observable)((Object)this.shelfModel));
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void dispose() {
        this.getObservableManager().removeObservable((Observable)((Object)this.shelfModel));
        if (this.profileComboBox != null) {
            this.profileComboBox.removeAllItems();
            this.profileComboBox = null;
        }
        if (this.forceComboBox != null) {
            this.forceComboBox.removeAllItems();
            this.forceComboBox = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    public void setShowing(boolean bl) throws Exception {
        if (!this._inited) {
            this.init();
        }
        super.setShowing(bl);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof PpmUpdate) {
            return;
        }
        if (object instanceof ModuleModelUpdate) {
            this.getDataModel().refreshMyPorts();
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.CardProvAlarmsBehaviorPane;
    }

    class ForceListener
    implements ActionListener {
        ForceListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = CardProvAlarmsBehaviorPane.this.getTable();
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                jTable.getValueAt(i, 1);
                jTable.setValueAt(CardProvAlarmsBehaviorPane.this.forceComboBox.getSelectedItem(), i, 1);
                jTable.getValueAt(i, 2);
            }
            CardProvAlarmsBehaviorPane.this.initializeComboBox();
        }
    }
}

