/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmUpdate;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.VitalStatsPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.UObservable;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class CardVitalStatsPane
extends VitalStatsPane
implements Observer {
    private ModuleModel moduleM;
    private NodeModelDelegate nodeModel;
    private String cardName = null;
    private String nodeName = null;
    private int slotNo;
    private PortModel[] portModels = null;
    private InterfaceModel[] lineModels = null;
    private EntityCellRenderer myPortRenderer;
    private TDMTerminology terms;
    private UObservable tvObs;
    private static final SDebug db = new SDebug("CardVitalStatsPane");

    public CardVitalStatsPane(ModuleModel moduleModel, UObservable uObservable) {
        super((IAlarmStore)null);
        this.moduleM = moduleModel;
        this.moduleM.addObserver(this);
        this.nodeModel = moduleModel.getNodeModelDelegate();
        this.terms = this.nodeModel.getTDMTerminology();
        this.nodeModel.addObserver(this);
        this.nodeName = this.nodeModel.getName();
        this.slotNo = moduleModel.getSlot();
        this.cardName = EntityModel.eqType2Name(this.terms, moduleModel.getEqType());
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.nodeModel.getElementAlarmStore();
        ElementAlarmStore elementAlarmStore2 = elementAlarmStore.getAlarmStore(this.slotNo);
        this.setAlarmStore(elementAlarmStore2);
        this.myPortRenderer = new EntityCellRenderer();
        if (uObservable != null) {
            this.tvObs = uObservable;
            db.fine("Adding " + this + "as observer of " + this.tvObs);
            this.tvObs.addObserver((Observer)this);
        }
        this.populateInterfaces();
        this.refreshText();
    }

    private void refreshText() {
        block6: {
            this.nodeName = this.moduleM.getNodeModel().getName();
            this.setTitle(this.nodeName + " slot " + this.slotNo + " " + this.cardName);
            try {
                String string;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = this.moduleM.getEqTypeName();
                if (!string2.equals("")) {
                    stringBuffer.append("Eqpt: " + string2 + "\n");
                }
                if (!(string = this.getStateString()).equals("")) {
                    stringBuffer.append("Status: " + this.getProtectString() + string + "\n");
                }
                stringBuffer.append("Service State: " + this.moduleM.getServiceSt().toString(this.terms) + "\n");
                int n = this.moduleM.getEqType();
                if (this.moduleM instanceof DwdmModuleModel) {
                    stringBuffer.append(this.getDwdmState());
                } else {
                    stringBuffer.append(this.getPortStateString());
                }
                this.setText(stringBuffer.toString());
            }
            catch (Exception exception) {
                db.println("Caught exception in refreshText()");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.textArea.setCaretPosition(0);
    }

    private String getPortStateString() {
        StringBuffer stringBuffer;
        block9: {
            stringBuffer = new StringBuffer();
            if (this.moduleM.getEqType() == 145 && ((Ds3xmModuleModel)this.moduleM).isOneForNProtectModule()) {
                return stringBuffer.toString();
            }
            try {
                stringBuffer.append("\n");
                for (int i = 0; i < this.lineModels.length; ++i) {
                    if (this.lineModels[i] == null) {
                        db.fine("getPortStateString: Got a null InterfaceModel at " + i + ", port = " + this.portModels[i].toString());
                        continue;
                    }
                    stringBuffer.append("Port " + PortHelper.getPortNumAndTypeString((IPortModel)this.lineModels[i].getPortModel(), (boolean)false, (boolean)true));
                    stringBuffer.append(this.getPortType(this.lineModels[i]));
                    stringBuffer.append(":" + this.terms.getTermForServiceState(this.lineModels[i].getPortModel().getServiceStateType()));
                    if (this.lineModels[i] instanceof TdmLineModel) {
                        TdmLineModel tdmLineModel = (TdmLineModel)this.lineModels[i];
                        switch (this.lineModels[i].getAdminState()) {
                            case 0: 
                            case 2: 
                            case 3: {
                                stringBuffer.append(this.myPortRenderer.getSonetLineProtectionDescription(tdmLineModel, false));
                                break;
                            }
                        }
                    }
                    stringBuffer.append("\n");
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getOCNPortStateString");
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private void populateInterfaces() {
        PortModel[] portModelArray = this.moduleM.getPortModels();
        this.clearLineModels();
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        ArrayList<InterfaceModel> arrayList2 = new ArrayList<InterfaceModel>();
        for (int i = 0; i < portModelArray.length; ++i) {
            InterfaceModel interfaceModel = null;
            try {
                interfaceModel = (InterfaceModel)portModelArray[i].getInterfaceModel();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                continue;
            }
            if (interfaceModel == null) continue;
            arrayList.add(portModelArray[i]);
            arrayList2.add(interfaceModel);
            interfaceModel.addObserver(this);
        }
        this.portModels = arrayList.toArray(new PortModel[arrayList.size()]);
        this.lineModels = arrayList2.toArray(new InterfaceModel[arrayList2.size()]);
    }

    private String getDwdmState() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.getFramingType());
        stringBuffer.append(this.getTermMode());
        stringBuffer.append(this.getRegenPeerSlot());
        stringBuffer.append(this.getCardOperMode());
        stringBuffer.append(this.getDwdmPortStateString());
        return stringBuffer.toString();
    }

    private String getFramingType() {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer("");
            if (this.moduleM.getEqType() == 120 || this.moduleM.getEqType() == 121) {
                try {
                    if (this.lineModels.length > 0 && this.moduleM instanceof DwdmModuleModel) {
                        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.moduleM;
                        DwdmTrkLineModel dwdmTrkLineModel = dwdmModuleModel.getFirstTrunkLine();
                        Attribute attribute = ElementDefaults.getAttributeMap(dwdmModuleModel).getAttributeForVal("declTXP25GFramingType", EntityCellRenderer.mapPayloadType(dwdmTrkLineModel.getDataRate()));
                        stringBuffer.append("Framing Type: ");
                        stringBuffer.append(attribute);
                        stringBuffer.append("\n");
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in getFramingType");
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getTermMode() {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer("");
            if (this.moduleM.getEqType() != 183 && this.moduleM.getEqType() != 184) {
                try {
                    if (this.lineModels.length > 0 && this.moduleM instanceof DwdmModuleModel) {
                        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.moduleM;
                        stringBuffer.append("Term Mode: ");
                        stringBuffer.append(this.myPortRenderer.getTermMode(dwdmModuleModel.getFirstTrunkLine()));
                        stringBuffer.append("\n");
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in getTermMode");
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getRegenPeerSlot() {
        StringBuffer stringBuffer;
        block5: {
            stringBuffer = new StringBuffer("");
            if (this.moduleM.getEqType() != 183 && this.moduleM.getEqType() != 184) {
                try {
                    int n = 0;
                    for (int i = 0; i < this.lineModels.length; ++i) {
                        if (!(this.lineModels[i] instanceof DwdmTrkLineModel)) continue;
                        DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.lineModels[i];
                        n = dwdmTrkLineModel.getRegenPeer();
                        break;
                    }
                    if (n > 0) {
                        stringBuffer.append("Regeneration Peer Slot: " + n);
                        stringBuffer.append("\n");
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in getRegenPeerSlot");
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getCardOperMode() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.moduleM.getEqType() == 183 || this.moduleM.getEqType() == 184) {
            stringBuffer.append("Operational Mode: ");
            stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("dwdmCardMode", this.moduleM.getCardOperMode().value()));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getDwdmPortStateString() {
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("\n");
                for (int i = 0; i < this.lineModels.length; ++i) {
                    if (this.lineModels[i] instanceof DwdmCliLineModel) continue;
                    stringBuffer.append("Port " + PortHelper.getPortNumAndTypeString((IPortModel)this.lineModels[i].getPortModel(), (boolean)false, (boolean)false));
                    stringBuffer.append(":" + this.lineModels[i].getServiceSt().toString(this.terms));
                    switch (this.lineModels[i].getAdminState()) {
                        case 0: 
                        case 2: 
                        case 3: {
                            stringBuffer.append(this.myPortRenderer.getDwdmLineProtectionDescription(this.lineModels[i], false));
                            break;
                        }
                    }
                    stringBuffer.append("\n");
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getDwdmPortStateString");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private String getPortType(InterfaceModel interfaceModel) {
        TdmLineModel tdmLineModel;
        String string;
        if (interfaceModel instanceof TdmLineModel && (string = this.myPortRenderer.getMediumTypeStr(tdmLineModel = (TdmLineModel)interfaceModel)).length() > 0) {
            return " (" + string + ")";
        }
        return "";
    }

    private String getStateString() {
        switch (this.moduleM.getEqType()) {
            case 9: 
            case 10: 
            case 11: 
            case 60: 
            case 85: 
            case 106: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 181: 
            case 182: {
                return ElementDefaults.eqStateToOCNString(this.moduleM.getState());
            }
        }
        return ElementDefaults.eqStateToString(this.moduleM.getState());
    }

    private String getProtectString() {
        String string = "";
        ProtectionGroupModel protectionGroupModel = this.moduleM.getProtectionGroupModel();
        if (protectionGroupModel != null) {
            string = this.moduleM == protectionGroupModel.getProtectModuleModel() ? "Protect/" : "Working/";
        }
        return string;
    }

    public void update(Observable observable, Object object) {
        db.fine("update from " + observable + "arg obj is " + object);
        if (object instanceof PpmUpdate) {
            return;
        }
        if (object instanceof ModuleModelUpdate || object.equals(ModelUpdateType.DELETED) && observable instanceof GfpLineModel) {
            this.populateInterfaces();
            this.refreshText();
        } else if (object.equals(ModelUpdateType.CHANGED)) {
            this.refreshText();
        }
    }

    private void unregisterWithModels() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                if (this.lineModels[i] != null) {
                    this.lineModels[i].deleteObserver(this);
                    db.fine("unregisterWithModels: Deleting me as an observer for " + i + ", lineModels[" + i + "] = " + this.lineModels[i]);
                    continue;
                }
                db.fine("unregisterWithModels: lineModel at " + i + " is NULL");
            }
            this.lineModels = null;
        } else {
            db.fine("unregisterWithModels: lineModels array is null");
        }
    }

    public void dispose() {
        this.nodeModel.deleteObserver(this);
        this.moduleM.deleteObserver(this);
        this.clearLineModels();
        if (this.tvObs != null) {
            this.tvObs.deleteObserver((Observer)this);
        }
        this.myPortRenderer = null;
        super.dispose();
    }

    private void clearLineModels() {
        this.unregisterWithModels();
        this.portModels = null;
    }
}

